/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.solvers;

import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math.analysis.solvers.UnivariateRealSolverImpl;
import org.apache.commons.math.complex.Complex;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.util.FastMath;

public class LaguerreSolver
extends UnivariateRealSolverImpl {
    @Deprecated
    private final PolynomialFunction p;

    @Deprecated
    public LaguerreSolver(UnivariateRealFunction f2) throws IllegalArgumentException {
        super(f2, 100, 1.0E-6);
        if (!(f2 instanceof PolynomialFunction)) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.FUNCTION_NOT_POLYNOMIAL, new Object[0]);
        }
        this.p = (PolynomialFunction)f2;
    }

    @Deprecated
    public LaguerreSolver() {
        super(100, 1.0E-6);
        this.p = null;
    }

    @Deprecated
    public PolynomialFunction getPolynomialFunction() {
        return new PolynomialFunction(this.p.getCoefficients());
    }

    @Deprecated
    public double solve(double min, double max) throws ConvergenceException, FunctionEvaluationException {
        return this.solve(this.p, min, max);
    }

    @Deprecated
    public double solve(double min, double max, double initial) throws ConvergenceException, FunctionEvaluationException {
        return this.solve(this.p, min, max, initial);
    }

    public double solve(int maxEval, UnivariateRealFunction f2, double min, double max, double initial) throws ConvergenceException, FunctionEvaluationException {
        this.setMaximalIterationCount(maxEval);
        return this.solve(f2, min, max, initial);
    }

    @Deprecated
    public double solve(UnivariateRealFunction f2, double min, double max, double initial) throws ConvergenceException, FunctionEvaluationException {
        if (f2.value(min) == 0.0) {
            return min;
        }
        if (f2.value(max) == 0.0) {
            return max;
        }
        if (f2.value(initial) == 0.0) {
            return initial;
        }
        this.verifyBracketing(min, max, f2);
        this.verifySequence(min, initial, max);
        if (this.isBracketing(min, initial, f2)) {
            return this.solve(f2, min, initial);
        }
        return this.solve(f2, initial, max);
    }

    public double solve(int maxEval, UnivariateRealFunction f2, double min, double max) throws ConvergenceException, FunctionEvaluationException {
        this.setMaximalIterationCount(maxEval);
        return this.solve(f2, min, max);
    }

    @Deprecated
    public double solve(UnivariateRealFunction f2, double min, double max) throws ConvergenceException, FunctionEvaluationException {
        if (!(f2 instanceof PolynomialFunction)) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.FUNCTION_NOT_POLYNOMIAL, new Object[0]);
        }
        if (f2.value(min) == 0.0) {
            return min;
        }
        if (f2.value(max) == 0.0) {
            return max;
        }
        this.verifyBracketing(min, max, f2);
        double[] coefficients = ((PolynomialFunction)f2).getCoefficients();
        Complex[] c2 = new Complex[coefficients.length];
        for (int i = 0; i < coefficients.length; ++i) {
            c2[i] = new Complex(coefficients[i], 0.0);
        }
        Complex initial = new Complex(0.5 * (min + max), 0.0);
        Complex z = this.solve(c2, initial);
        if (this.isRootOK(min, max, z)) {
            this.setResult(z.getReal(), this.iterationCount);
            return this.result;
        }
        Complex[] root = this.solveAll(c2, initial);
        for (int i = 0; i < root.length; ++i) {
            if (!this.isRootOK(min, max, root[i])) continue;
            this.setResult(root[i].getReal(), this.iterationCount);
            return this.result;
        }
        throw new ConvergenceException();
    }

    protected boolean isRootOK(double min, double max, Complex z) {
        double tolerance = FastMath.max(this.relativeAccuracy * z.abs(), this.absoluteAccuracy);
        return this.isSequence(min, z.getReal(), max) && (FastMath.abs(z.getImaginary()) <= tolerance || z.abs() <= this.functionValueAccuracy);
    }

    @Deprecated
    public Complex[] solveAll(double[] coefficients, double initial) throws ConvergenceException, FunctionEvaluationException {
        Complex[] c2 = new Complex[coefficients.length];
        Complex z = new Complex(initial, 0.0);
        for (int i = 0; i < c2.length; ++i) {
            c2[i] = new Complex(coefficients[i], 0.0);
        }
        return this.solveAll(c2, z);
    }

    @Deprecated
    public Complex[] solveAll(Complex[] coefficients, Complex initial) throws MaxIterationsExceededException, FunctionEvaluationException {
        int n = coefficients.length - 1;
        int iterationCount = 0;
        if (n < 1) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NON_POSITIVE_POLYNOMIAL_DEGREE, n);
        }
        Complex[] c2 = new Complex[n + 1];
        for (int i = 0; i <= n; ++i) {
            c2[i] = coefficients[i];
        }
        Complex[] root = new Complex[n];
        for (int i = 0; i < n; ++i) {
            Complex[] subarray = new Complex[n - i + 1];
            System.arraycopy(c2, 0, subarray, 0, subarray.length);
            root[i] = this.solve(subarray, initial);
            Complex newc = c2[n - i];
            Complex oldc = null;
            for (int j = n - i - 1; j >= 0; --j) {
                oldc = c2[j];
                c2[j] = newc;
                newc = oldc.add(newc.multiply(root[i]));
            }
            iterationCount += this.iterationCount;
        }
        this.resultComputed = true;
        this.iterationCount = iterationCount;
        return root;
    }

    @Deprecated
    public Complex solve(Complex[] coefficients, Complex initial) throws MaxIterationsExceededException, FunctionEvaluationException {
        int n = coefficients.length - 1;
        if (n < 1) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NON_POSITIVE_POLYNOMIAL_DEGREE, n);
        }
        Complex N = new Complex(n, 0.0);
        Complex N1 = new Complex(n - 1, 0.0);
        Complex pv = null;
        Complex dv = null;
        Complex d2v = null;
        Complex G = null;
        Complex G2 = null;
        Complex H = null;
        Complex delta = null;
        Complex denominator = null;
        Complex z = initial;
        Complex oldz = new Complex(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        for (int i = 1; i <= this.maximalIterationCount; ++i) {
            pv = coefficients[n];
            dv = Complex.ZERO;
            d2v = Complex.ZERO;
            for (int j = n - 1; j >= 0; --j) {
                d2v = dv.add(z.multiply(d2v));
                dv = pv.add(z.multiply(dv));
                pv = coefficients[j].add(z.multiply(pv));
            }
            d2v = d2v.multiply(new Complex(2.0, 0.0));
            double tolerance = FastMath.max(this.relativeAccuracy * z.abs(), this.absoluteAccuracy);
            if (z.subtract(oldz).abs() <= tolerance) {
                this.resultComputed = true;
                this.iterationCount = i;
                return z;
            }
            if (pv.abs() <= this.functionValueAccuracy) {
                this.resultComputed = true;
                this.iterationCount = i;
                return z;
            }
            G = dv.divide(pv);
            G2 = G.multiply(G);
            H = G2.subtract(d2v.divide(pv));
            delta = N1.multiply(N.multiply(H).subtract(G2));
            Complex deltaSqrt = delta.sqrt();
            Complex dplus = G.add(deltaSqrt);
            Complex dminus = G.subtract(deltaSqrt);
            Complex complex = denominator = dplus.abs() > dminus.abs() ? dplus : dminus;
            if (denominator.equals(new Complex(0.0, 0.0))) {
                z = z.add(new Complex(this.absoluteAccuracy, this.absoluteAccuracy));
                oldz = new Complex(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
                continue;
            }
            oldz = z;
            z = z.subtract(N.divide(denominator));
        }
        throw new MaxIterationsExceededException(this.maximalIterationCount);
    }
}

