/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization.fitting;

import java.io.Serializable;
import org.apache.commons.math.analysis.DifferentiableUnivariateRealFunction;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.exception.DimensionMismatchException;
import org.apache.commons.math.exception.NullArgumentException;
import org.apache.commons.math.exception.ZeroException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.optimization.fitting.GaussianDerivativeFunction;

public class GaussianFunction
implements DifferentiableUnivariateRealFunction,
Serializable {
    private static final long serialVersionUID = -3195385616125629512L;
    private final double a;
    private final double b;
    private final double c;
    private final double d;

    public GaussianFunction(double a2, double b2, double c2, double d2) {
        if (d2 == 0.0) {
            throw new ZeroException();
        }
        this.a = a2;
        this.b = b2;
        this.c = c2;
        this.d = d2;
    }

    public GaussianFunction(double[] parameters) {
        if (parameters == null) {
            throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY);
        }
        if (parameters.length != 4) {
            throw new DimensionMismatchException(4, parameters.length);
        }
        if (parameters[3] == 0.0) {
            throw new ZeroException();
        }
        this.a = parameters[0];
        this.b = parameters[1];
        this.c = parameters[2];
        this.d = parameters[3];
    }

    public UnivariateRealFunction derivative() {
        return new GaussianDerivativeFunction(this.b, this.c, this.d);
    }

    public double value(double x) {
        double xMc = x - this.c;
        return this.a + this.b * Math.exp(-xMc * xMc / (2.0 * (this.d * this.d)));
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public double getC() {
        return this.c;
    }

    public double getD() {
        return this.d;
    }
}

