/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization.fitting;

import org.apache.commons.math.analysis.DifferentiableUnivariateRealFunction;
import org.apache.commons.math.util.FastMath;

public class HarmonicFunction
implements DifferentiableUnivariateRealFunction {
    private final double a;
    private final double omega;
    private final double phi;

    public HarmonicFunction(double a2, double omega, double phi) {
        this.a = a2;
        this.omega = omega;
        this.phi = phi;
    }

    public double value(double x) {
        return this.a * FastMath.cos(this.omega * x + this.phi);
    }

    public HarmonicFunction derivative() {
        return new HarmonicFunction(this.a * this.omega, this.omega, this.phi + 1.5707963267948966);
    }

    public double getAmplitude() {
        return this.a;
    }

    public double getPulsation() {
        return this.omega;
    }

    public double getPhase() {
        return this.phi;
    }
}

