/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization.fitting;

import java.io.Serializable;
import org.apache.commons.math.exception.DimensionMismatchException;
import org.apache.commons.math.exception.NullArgumentException;
import org.apache.commons.math.exception.ZeroException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.optimization.fitting.ParametricRealFunction;

public class ParametricGaussianFunction
implements ParametricRealFunction,
Serializable {
    private static final long serialVersionUID = -3875578602503903233L;

    public double value(double x, double[] parameters) throws ZeroException {
        this.validateParameters(parameters);
        double a2 = parameters[0];
        double b2 = parameters[1];
        double c2 = parameters[2];
        double d2 = parameters[3];
        double xMc = x - c2;
        return a2 + b2 * Math.exp(-xMc * xMc / (2.0 * (d2 * d2)));
    }

    public double[] gradient(double x, double[] parameters) throws ZeroException {
        this.validateParameters(parameters);
        double b2 = parameters[1];
        double c2 = parameters[2];
        double d2 = parameters[3];
        double xMc = x - c2;
        double d22 = d2 * d2;
        double exp = Math.exp(-xMc * xMc / (2.0 * d22));
        double f2 = b2 * exp * xMc / d22;
        return new double[]{1.0, exp, f2, f2 * xMc / d2};
    }

    private void validateParameters(double[] parameters) throws ZeroException {
        if (parameters == null) {
            throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY);
        }
        if (parameters.length != 4) {
            throw new DimensionMismatchException(4, parameters.length);
        }
        if (parameters[3] == 0.0) {
            throw new ZeroException();
        }
    }
}

