/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.transform;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.transform.FastFourierTransformer;
import org.apache.commons.math.transform.RealTransformer;

public class FastHadamardTransformer
implements RealTransformer {
    public double[] transform(double[] f2) throws IllegalArgumentException {
        return this.fht(f2);
    }

    public double[] transform(UnivariateRealFunction f2, double min, double max, int n) throws FunctionEvaluationException, IllegalArgumentException {
        return this.fht(FastFourierTransformer.sample(f2, min, max, n));
    }

    public double[] inversetransform(double[] f2) throws IllegalArgumentException {
        return FastFourierTransformer.scaleArray(this.fht(f2), 1.0 / (double)f2.length);
    }

    public double[] inversetransform(UnivariateRealFunction f2, double min, double max, int n) throws FunctionEvaluationException, IllegalArgumentException {
        double[] unscaled = this.fht(FastFourierTransformer.sample(f2, min, max, n));
        return FastFourierTransformer.scaleArray(unscaled, 1.0 / (double)n);
    }

    public int[] transform(int[] f2) throws IllegalArgumentException {
        return this.fht(f2);
    }

    protected double[] fht(double[] x) throws IllegalArgumentException {
        int n = x.length;
        int halfN = n / 2;
        if (!FastFourierTransformer.isPowerOf2(n)) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NOT_POWER_OF_TWO, n);
        }
        double[] yPrevious = new double[n];
        double[] yCurrent = (double[])x.clone();
        for (int j = 1; j < n; j <<= 1) {
            int twoI;
            int i;
            double[] yTmp = yCurrent;
            yCurrent = yPrevious;
            yPrevious = yTmp;
            for (i = 0; i < halfN; ++i) {
                twoI = 2 * i;
                yCurrent[i] = yPrevious[twoI] + yPrevious[twoI + 1];
            }
            for (i = halfN; i < n; ++i) {
                twoI = 2 * i;
                yCurrent[i] = yPrevious[twoI - n] - yPrevious[twoI - n + 1];
            }
        }
        return yCurrent;
    }

    protected int[] fht(int[] x) throws IllegalArgumentException {
        int n = x.length;
        int halfN = n / 2;
        if (!FastFourierTransformer.isPowerOf2(n)) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NOT_POWER_OF_TWO, n);
        }
        int[] yPrevious = new int[n];
        int[] yCurrent = (int[])x.clone();
        for (int j = 1; j < n; j <<= 1) {
            int twoI;
            int i;
            int[] yTmp = yCurrent;
            yCurrent = yPrevious;
            yPrevious = yTmp;
            for (i = 0; i < halfN; ++i) {
                twoI = 2 * i;
                yCurrent[i] = yPrevious[twoI] + yPrevious[twoI + 1];
            }
            for (i = halfN; i < n; ++i) {
                twoI = 2 * i;
                yCurrent[i] = yPrevious[twoI - n] - yPrevious[twoI - n + 1];
            }
        }
        return yCurrent;
    }
}

