/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.hpsf.ClassID;
import org.apache.poi.hpsf.IllegalPropertySetDataException;
import org.apache.poi.hpsf.Property;
import org.apache.poi.hpsf.UnsupportedVariantTypeException;
import org.apache.poi.hpsf.VariantSupport;
import org.apache.poi.util.LittleEndian;

public class TypeWriter {
    public static int writeToStream(OutputStream out, short n) throws IOException {
        int length = 2;
        byte[] buffer = new byte[2];
        LittleEndian.putShort(buffer, 0, n);
        out.write(buffer, 0, 2);
        return 2;
    }

    public static int writeToStream(OutputStream out, int n) throws IOException {
        int l = 4;
        byte[] buffer = new byte[4];
        LittleEndian.putInt(buffer, 0, n);
        out.write(buffer, 0, 4);
        return 4;
    }

    public static int writeToStream(OutputStream out, long n) throws IOException {
        int l = 8;
        byte[] buffer = new byte[8];
        LittleEndian.putLong(buffer, 0, n);
        out.write(buffer, 0, 8);
        return 8;
    }

    public static void writeUShortToStream(OutputStream out, int n) throws IOException {
        int high = n & 0xFFFF0000;
        if (high != 0) {
            throw new IllegalPropertySetDataException("Value " + n + " cannot be represented by 2 bytes.");
        }
        TypeWriter.writeToStream(out, (short)n);
    }

    public static int writeUIntToStream(OutputStream out, long n) throws IOException {
        long high = n & 0xFFFFFFFF00000000L;
        if (high != 0L && high != -4294967296L) {
            throw new IllegalPropertySetDataException("Value " + n + " cannot be represented by 4 bytes.");
        }
        return TypeWriter.writeToStream(out, (int)n);
    }

    public static int writeToStream(OutputStream out, ClassID n) throws IOException {
        byte[] b2 = new byte[16];
        n.write(b2, 0);
        out.write(b2, 0, b2.length);
        return b2.length;
    }

    public static void writeToStream(OutputStream out, Property[] properties, int codepage) throws IOException, UnsupportedVariantTypeException {
        Property p;
        int i;
        if (properties == null) {
            return;
        }
        for (i = 0; i < properties.length; ++i) {
            p = properties[i];
            TypeWriter.writeUIntToStream(out, p.getID());
            TypeWriter.writeUIntToStream(out, p.getSize());
        }
        for (i = 0; i < properties.length; ++i) {
            p = properties[i];
            long type = p.getType();
            TypeWriter.writeUIntToStream(out, type);
            VariantSupport.write(out, (int)type, p.getValue(), codepage);
        }
    }

    public static int writeToStream(OutputStream out, double n) throws IOException {
        int l = 8;
        byte[] buffer = new byte[8];
        LittleEndian.putDouble(buffer, 0, n);
        out.write(buffer, 0, 8);
        return 8;
    }
}

