/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static final long EPOCH_DIFF = 11644473600000L;

    public static boolean equal(byte[] a2, byte[] b2) {
        if (a2.length != b2.length) {
            return false;
        }
        for (int i = 0; i < a2.length; ++i) {
            if (a2[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    public static void copy(byte[] src, int srcOffset, int length, byte[] dst, int dstOffset) {
        for (int i = 0; i < length; ++i) {
            dst[dstOffset + i] = src[srcOffset + i];
        }
    }

    public static byte[] cat(byte[][] byteArrays) {
        int capacity = 0;
        for (int i = 0; i < byteArrays.length; ++i) {
            capacity += byteArrays[i].length;
        }
        byte[] result = new byte[capacity];
        int r = 0;
        for (int i = 0; i < byteArrays.length; ++i) {
            for (int j = 0; j < byteArrays[i].length; ++j) {
                result[r++] = byteArrays[i][j];
            }
        }
        return result;
    }

    public static byte[] copy(byte[] src, int offset, int length) {
        byte[] result = new byte[length];
        Util.copy(src, offset, length, result, 0);
        return result;
    }

    public static Date filetimeToDate(int high, int low) {
        long filetime = (long)high << 32 | (long)low & 0xFFFFFFFFL;
        return Util.filetimeToDate(filetime);
    }

    public static Date filetimeToDate(long filetime) {
        long ms_since_16010101 = filetime / 10000L;
        long ms_since_19700101 = ms_since_16010101 - 11644473600000L;
        return new Date(ms_since_19700101);
    }

    public static long dateToFileTime(Date date) {
        long ms_since_19700101 = date.getTime();
        long ms_since_16010101 = ms_since_19700101 + 11644473600000L;
        return ms_since_16010101 * 10000L;
    }

    public static boolean equals(Collection<?> c1, Collection<?> c2) {
        Object[] o1 = c1.toArray();
        Object[] o2 = c2.toArray();
        return Util.internalEquals(o1, o2);
    }

    public static boolean equals(Object[] c1, Object[] c2) {
        Object[] o1 = (Object[])c1.clone();
        Object[] o2 = (Object[])c2.clone();
        return Util.internalEquals(o1, o2);
    }

    private static boolean internalEquals(Object[] o1, Object[] o2) {
        for (int i1 = 0; i1 < o1.length; ++i1) {
            Object obj1 = o1[i1];
            boolean matchFound = false;
            for (int i2 = 0; !matchFound && i2 < o1.length; ++i2) {
                Object obj2 = o2[i2];
                if (!obj1.equals(obj2)) continue;
                matchFound = true;
                o2[i2] = null;
            }
            if (matchFound) continue;
            return false;
        }
        return true;
    }

    public static byte[] pad4(byte[] ba) {
        byte[] result;
        int PAD = 4;
        int l = ba.length % 4;
        if (l == 0) {
            result = ba;
        } else {
            l = 4 - l;
            result = new byte[ba.length + l];
            System.arraycopy(ba, 0, result, 0, ba.length);
        }
        return result;
    }

    public static char[] pad4(char[] ca) {
        char[] result;
        int PAD = 4;
        int l = ca.length % 4;
        if (l == 0) {
            result = ca;
        } else {
            l = 4 - l;
            result = new char[ca.length + l];
            System.arraycopy(ca, 0, result, 0, ca.length);
        }
        return result;
    }

    public static char[] pad4(String s) {
        return Util.pad4(s.toCharArray());
    }

    public static String toString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.close();
        try {
            sw.close();
            return sw.toString();
        }
        catch (IOException e2) {
            StringBuffer b2 = new StringBuffer(t.getMessage());
            b2.append("\n");
            b2.append("Could not create a stacktrace. Reason: ");
            b2.append(e2.getMessage());
            return b2.toString();
        }
    }
}

