/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.atp;

import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.EvaluationException;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.OperandResolver;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.FreeRefFunction;
import org.apache.poi.ss.formula.OperationEvaluationContext;

final class RandBetween
implements FreeRefFunction {
    public static final FreeRefFunction instance = new RandBetween();

    private RandBetween() {
    }

    public ValueEval evaluate(ValueEval[] args, OperationEvaluationContext ec) {
        double top;
        double bottom;
        if (args.length != 2) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            bottom = OperandResolver.coerceValueToDouble(OperandResolver.getSingleValue(args[0], ec.getRowIndex(), ec.getColumnIndex()));
            top = OperandResolver.coerceValueToDouble(OperandResolver.getSingleValue(args[1], ec.getRowIndex(), ec.getColumnIndex()));
            if (bottom > top) {
                return ErrorEval.NUM_ERROR;
            }
        }
        catch (EvaluationException e2) {
            return ErrorEval.VALUE_INVALID;
        }
        bottom = Math.ceil(bottom);
        top = Math.floor(top);
        if (bottom > top) {
            top = bottom;
        }
        return new NumberEval(bottom + (double)((int)(Math.random() * (top - bottom + 1.0))));
    }
}

