/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

final class MathX {
    private MathX() {
    }

    public static double round(double n, int p) {
        double retval;
        if (Double.isNaN(n) || Double.isInfinite(n)) {
            retval = Double.NaN;
        } else if (p != 0) {
            double temp = Math.pow(10.0, p);
            retval = (double)Math.round(n * temp) / temp;
        } else {
            retval = Math.round(n);
        }
        return retval;
    }

    public static double roundUp(double n, int p) {
        double retval;
        if (Double.isNaN(n) || Double.isInfinite(n)) {
            retval = Double.NaN;
        } else if (p != 0) {
            double temp = Math.pow(10.0, p);
            double nat = Math.abs(n * temp);
            retval = (double)MathX.sign(n) * (nat == (double)((long)nat) ? nat / temp : (double)Math.round(nat + 0.5) / temp);
        } else {
            double na = Math.abs(n);
            retval = (double)MathX.sign(n) * (na == (double)((long)na) ? na : (double)((long)na + 1L));
        }
        return retval;
    }

    public static double roundDown(double n, int p) {
        double retval;
        if (Double.isNaN(n) || Double.isInfinite(n)) {
            retval = Double.NaN;
        } else if (p != 0) {
            double temp = Math.pow(10.0, p);
            retval = (double)((long)MathX.sign(n) * Math.round(Math.abs(n) * temp - 0.5)) / temp;
        } else {
            retval = (long)n;
        }
        return retval;
    }

    public static short sign(double d2) {
        return (short)(d2 == 0.0 ? 0 : (d2 < 0.0 ? -1 : 1));
    }

    public static double average(double[] values) {
        double ave = 0.0;
        double sum = 0.0;
        int iSize = values.length;
        for (int i = 0; i < iSize; ++i) {
            sum += values[i];
        }
        ave = sum / (double)values.length;
        return ave;
    }

    public static double sum(double[] values) {
        double sum = 0.0;
        int iSize = values.length;
        for (int i = 0; i < iSize; ++i) {
            sum += values[i];
        }
        return sum;
    }

    public static double sumsq(double[] values) {
        double sumsq = 0.0;
        int iSize = values.length;
        for (int i = 0; i < iSize; ++i) {
            sumsq += values[i] * values[i];
        }
        return sumsq;
    }

    public static double product(double[] values) {
        double product = 0.0;
        if (values != null && values.length > 0) {
            product = 1.0;
            int iSize = values.length;
            for (int i = 0; i < iSize; ++i) {
                product *= values[i];
            }
        }
        return product;
    }

    public static double min(double[] values) {
        double min = Double.POSITIVE_INFINITY;
        int iSize = values.length;
        for (int i = 0; i < iSize; ++i) {
            min = Math.min(min, values[i]);
        }
        return min;
    }

    public static double max(double[] values) {
        double max = Double.NEGATIVE_INFINITY;
        int iSize = values.length;
        for (int i = 0; i < iSize; ++i) {
            max = Math.max(max, values[i]);
        }
        return max;
    }

    public static double floor(double n, double s) {
        double f2 = n < 0.0 && s > 0.0 || n > 0.0 && s < 0.0 || s == 0.0 && n != 0.0 ? Double.NaN : (n == 0.0 || s == 0.0 ? 0.0 : Math.floor(n / s) * s);
        return f2;
    }

    public static double ceiling(double n, double s) {
        double c2 = n < 0.0 && s > 0.0 || n > 0.0 && s < 0.0 ? Double.NaN : (n == 0.0 || s == 0.0 ? 0.0 : Math.ceil(n / s) * s);
        return c2;
    }

    public static double factorial(int n) {
        double d2 = 1.0;
        if (n >= 0) {
            if (n <= 170) {
                for (int i = 1; i <= n; ++i) {
                    d2 *= (double)i;
                }
            } else {
                d2 = Double.POSITIVE_INFINITY;
            }
        } else {
            d2 = Double.NaN;
        }
        return d2;
    }

    public static double mod(double n, double d2) {
        double result = 0.0;
        result = d2 == 0.0 ? Double.NaN : (MathX.sign(n) == MathX.sign(d2) ? n % d2 : (n % d2 + d2) % d2);
        return result;
    }

    public static double acosh(double d2) {
        return Math.log(Math.sqrt(Math.pow(d2, 2.0) - 1.0) + d2);
    }

    public static double asinh(double d2) {
        return Math.log(Math.sqrt(d2 * d2 + 1.0) + d2);
    }

    public static double atanh(double d2) {
        return Math.log((1.0 + d2) / (1.0 - d2)) / 2.0;
    }

    public static double cosh(double d2) {
        double ePowX = Math.pow(Math.E, d2);
        double ePowNegX = Math.pow(Math.E, -d2);
        return (ePowX + ePowNegX) / 2.0;
    }

    public static double sinh(double d2) {
        double ePowX = Math.pow(Math.E, d2);
        double ePowNegX = Math.pow(Math.E, -d2);
        return (ePowX - ePowNegX) / 2.0;
    }

    public static double tanh(double d2) {
        double ePowX = Math.pow(Math.E, d2);
        double ePowNegX = Math.pow(Math.E, -d2);
        return (ePowX - ePowNegX) / (ePowX + ePowNegX);
    }

    public static double nChooseK(int n, int k) {
        double d2 = 1.0;
        if (n < 0 || k < 0 || n < k) {
            d2 = Double.NaN;
        } else {
            int maxnk;
            int minnk = Math.min(n - k, k);
            for (int i = maxnk = Math.max(n - k, k); i < n; ++i) {
                d2 *= (double)(i + 1);
            }
            d2 /= MathX.factorial(minnk);
        }
        return d2;
    }
}

