/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.poi.POIDocument;
import org.apache.poi.ddf.EscherBSERecord;
import org.apache.poi.ddf.EscherBitmapBlip;
import org.apache.poi.ddf.EscherBlipRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.hssf.OldExcelFormatException;
import org.apache.poi.hssf.model.HSSFFormulaParser;
import org.apache.poi.hssf.model.InternalSheet;
import org.apache.poi.hssf.model.InternalWorkbook;
import org.apache.poi.hssf.model.RecordStream;
import org.apache.poi.hssf.record.AbstractEscherHolderRecord;
import org.apache.poi.hssf.record.BackupRecord;
import org.apache.poi.hssf.record.DrawingGroupRecord;
import org.apache.poi.hssf.record.EmbeddedObjectRefSubRecord;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.FontRecord;
import org.apache.poi.hssf.record.LabelRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NameRecord;
import org.apache.poi.hssf.record.ObjRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFactory;
import org.apache.poi.hssf.record.SubRecord;
import org.apache.poi.hssf.record.UnknownRecord;
import org.apache.poi.hssf.record.aggregates.RecordAggregate;
import org.apache.poi.hssf.record.common.UnicodeString;
import org.apache.poi.hssf.record.formula.Area3DPtg;
import org.apache.poi.hssf.record.formula.MemFuncPtg;
import org.apache.poi.hssf.record.formula.NameXPtg;
import org.apache.poi.hssf.record.formula.OperandPtg;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.record.formula.Ref3DPtg;
import org.apache.poi.hssf.record.formula.SheetNameFormatter;
import org.apache.poi.hssf.record.formula.UnionPtg;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFCreationHelper;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFName;
import org.apache.poi.hssf.usermodel.HSSFObjectData;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFPictureData;
import org.apache.poi.hssf.usermodel.HSSFPrintSetup;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.util.CellReference;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.WorkbookUtil;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HSSFWorkbook
extends POIDocument
implements Workbook {
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    private static final int MAX_ROW = 65535;
    private static final short MAX_COLUMN = 255;
    private static final int DEBUG = POILogger.DEBUG;
    public static final int INITIAL_CAPACITY = 3;
    private InternalWorkbook workbook;
    protected List _sheets;
    private ArrayList names;
    private Hashtable fonts;
    private boolean preserveNodes;
    private HSSFDataFormat formatter;
    private Row.MissingCellPolicy missingCellPolicy = HSSFRow.RETURN_NULL_AND_BLANK;
    private static POILogger log = POILogFactory.getLogger(HSSFWorkbook.class);
    private static final String[] WORKBOOK_DIR_ENTRY_NAMES = new String[]{"Workbook", "WORKBOOK"};

    public static HSSFWorkbook create(InternalWorkbook book) {
        return new HSSFWorkbook(book);
    }

    public HSSFWorkbook() {
        this(InternalWorkbook.createWorkbook());
    }

    private HSSFWorkbook(InternalWorkbook book) {
        super(null, null);
        this.workbook = book;
        this._sheets = new ArrayList(3);
        this.names = new ArrayList(3);
    }

    public HSSFWorkbook(POIFSFileSystem fs) throws IOException {
        this(fs, true);
    }

    public HSSFWorkbook(POIFSFileSystem fs, boolean preserveNodes) throws IOException {
        this(fs.getRoot(), fs, preserveNodes);
    }

    private static String getWorkbookDirEntryName(DirectoryNode directory) {
        String[] potentialNames = WORKBOOK_DIR_ENTRY_NAMES;
        for (int i = 0; i < potentialNames.length; ++i) {
            String wbName = potentialNames[i];
            try {
                directory.getEntry(wbName);
                return wbName;
            }
            catch (FileNotFoundException e2) {
                continue;
            }
        }
        try {
            directory.getEntry("Book");
            throw new OldExcelFormatException("The supplied spreadsheet seems to be Excel 5.0/7.0 (BIFF5) format. POI only supports BIFF8 format (from Excel versions 97/2000/XP/2003)");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalArgumentException("The supplied POIFSFileSystem does not contain a BIFF8 'Workbook' entry. Is it really an excel file?");
        }
    }

    public HSSFWorkbook(DirectoryNode directory, POIFSFileSystem fs, boolean preserveNodes) throws IOException {
        super(directory, fs);
        String workbookName = HSSFWorkbook.getWorkbookDirEntryName(directory);
        this.preserveNodes = preserveNodes;
        if (!preserveNodes) {
            this.filesystem = null;
            this.directory = null;
        }
        this._sheets = new ArrayList(3);
        this.names = new ArrayList(3);
        DocumentInputStream stream = directory.createDocumentInputStream(workbookName);
        List<Record> records = RecordFactory.createRecords(stream);
        this.workbook = InternalWorkbook.createWorkbook(records);
        this.setPropertiesFromWorkbook(this.workbook);
        int recOffset = this.workbook.getNumRecords();
        boolean sheetNum = false;
        this.convertLabelRecords(records, recOffset);
        RecordStream rs = new RecordStream(records, recOffset);
        while (rs.hasNext()) {
            InternalSheet sheet = InternalSheet.createSheet(rs);
            this._sheets.add(new HSSFSheet(this, sheet));
        }
        for (int i = 0; i < this.workbook.getNumNames(); ++i) {
            NameRecord nameRecord = this.workbook.getNameRecord(i);
            HSSFName name = new HSSFName(this, nameRecord, this.workbook.getNameCommentRecord(nameRecord));
            this.names.add(name);
        }
    }

    public HSSFWorkbook(InputStream s) throws IOException {
        this(s, true);
    }

    public HSSFWorkbook(InputStream s, boolean preserveNodes) throws IOException {
        this(new POIFSFileSystem(s), preserveNodes);
    }

    private void setPropertiesFromWorkbook(InternalWorkbook book) {
        this.workbook = book;
    }

    private void convertLabelRecords(List records, int offset) {
        if (log.check(POILogger.DEBUG)) {
            log.log(POILogger.DEBUG, "convertLabelRecords called");
        }
        for (int k = offset; k < records.size(); ++k) {
            Record rec = (Record)records.get(k);
            if (rec.getSid() != 516) continue;
            LabelRecord oldrec = (LabelRecord)rec;
            records.remove(k);
            LabelSSTRecord newrec = new LabelSSTRecord();
            int stringid = this.workbook.addSSTString(new UnicodeString(oldrec.getValue()));
            newrec.setRow(oldrec.getRow());
            newrec.setColumn(oldrec.getColumn());
            newrec.setXFIndex(oldrec.getXFIndex());
            newrec.setSSTIndex(stringid);
            records.add(k, newrec);
        }
        if (log.check(POILogger.DEBUG)) {
            log.log(POILogger.DEBUG, "convertLabelRecords exit");
        }
    }

    @Override
    public Row.MissingCellPolicy getMissingCellPolicy() {
        return this.missingCellPolicy;
    }

    @Override
    public void setMissingCellPolicy(Row.MissingCellPolicy missingCellPolicy) {
        this.missingCellPolicy = missingCellPolicy;
    }

    @Override
    public void setSheetOrder(String sheetname, int pos) {
        this._sheets.add(pos, this._sheets.remove(this.getSheetIndex(sheetname)));
        this.workbook.setSheetOrder(sheetname, pos);
    }

    private void validateSheetIndex(int index) {
        int lastSheetIx = this._sheets.size() - 1;
        if (index < 0 || index > lastSheetIx) {
            throw new IllegalArgumentException("Sheet index (" + index + ") is out of range (0.." + lastSheetIx + ")");
        }
    }

    @Override
    public void setSelectedTab(int index) {
        this.validateSheetIndex(index);
        int nSheets = this._sheets.size();
        for (int i = 0; i < nSheets; ++i) {
            this.getSheetAt(i).setSelected(i == index);
        }
        this.workbook.getWindowOne().setNumSelectedTabs((short)1);
    }

    public void setSelectedTab(short index) {
        this.setSelectedTab((int)index);
    }

    public void setSelectedTabs(int[] indexes) {
        for (int i = 0; i < indexes.length; ++i) {
            this.validateSheetIndex(indexes[i]);
        }
        int nSheets = this._sheets.size();
        for (int i = 0; i < nSheets; ++i) {
            boolean bSelect = false;
            for (int j = 0; j < indexes.length; ++j) {
                if (indexes[j] != i) continue;
                bSelect = true;
                break;
            }
            this.getSheetAt(i).setSelected(bSelect);
        }
        this.workbook.getWindowOne().setNumSelectedTabs((short)indexes.length);
    }

    @Override
    public void setActiveSheet(int index) {
        this.validateSheetIndex(index);
        int nSheets = this._sheets.size();
        for (int i = 0; i < nSheets; ++i) {
            this.getSheetAt(i).setActive(i == index);
        }
        this.workbook.getWindowOne().setActiveSheetIndex(index);
    }

    @Override
    public int getActiveSheetIndex() {
        return this.workbook.getWindowOne().getActiveSheetIndex();
    }

    public short getSelectedTab() {
        return (short)this.getActiveSheetIndex();
    }

    @Override
    public void setFirstVisibleTab(int index) {
        this.workbook.getWindowOne().setFirstVisibleTab(index);
    }

    public void setDisplayedTab(short index) {
        this.setFirstVisibleTab(index);
    }

    @Override
    public int getFirstVisibleTab() {
        return this.workbook.getWindowOne().getFirstVisibleTab();
    }

    public short getDisplayedTab() {
        return (short)this.getFirstVisibleTab();
    }

    @Override
    public void setSheetName(int sheetIx, String name) {
        if (this.workbook.doesContainsSheetName(name, sheetIx)) {
            throw new IllegalArgumentException("The workbook already contains a sheet with this name");
        }
        this.validateSheetIndex(sheetIx);
        this.workbook.setSheetName(sheetIx, name);
    }

    @Override
    public String getSheetName(int sheetIndex) {
        this.validateSheetIndex(sheetIndex);
        return this.workbook.getSheetName(sheetIndex);
    }

    @Override
    public boolean isHidden() {
        return this.workbook.getWindowOne().getHidden();
    }

    @Override
    public void setHidden(boolean hiddenFlag) {
        this.workbook.getWindowOne().setHidden(hiddenFlag);
    }

    @Override
    public boolean isSheetHidden(int sheetIx) {
        this.validateSheetIndex(sheetIx);
        return this.workbook.isSheetHidden(sheetIx);
    }

    @Override
    public boolean isSheetVeryHidden(int sheetIx) {
        this.validateSheetIndex(sheetIx);
        return this.workbook.isSheetVeryHidden(sheetIx);
    }

    @Override
    public void setSheetHidden(int sheetIx, boolean hidden) {
        this.validateSheetIndex(sheetIx);
        this.workbook.setSheetHidden(sheetIx, hidden);
    }

    @Override
    public void setSheetHidden(int sheetIx, int hidden) {
        this.validateSheetIndex(sheetIx);
        WorkbookUtil.validateSheetState(hidden);
        this.workbook.setSheetHidden(sheetIx, hidden);
    }

    @Override
    public int getSheetIndex(String name) {
        return this.workbook.getSheetIndex(name);
    }

    @Override
    public int getSheetIndex(Sheet sheet) {
        for (int i = 0; i < this._sheets.size(); ++i) {
            if (this._sheets.get(i) != sheet) continue;
            return i;
        }
        return -1;
    }

    public int getExternalSheetIndex(int internalSheetIndex) {
        return this.workbook.checkExternSheet(internalSheetIndex);
    }

    public String findSheetNameFromExternSheet(int externSheetIndex) {
        return this.workbook.findSheetNameFromExternSheet(externSheetIndex);
    }

    public String resolveNameXText(int refIndex, int definedNameIndex) {
        return this.workbook.resolveNameXText(refIndex, definedNameIndex);
    }

    @Override
    public HSSFSheet createSheet() {
        HSSFSheet sheet = new HSSFSheet(this);
        this._sheets.add(sheet);
        this.workbook.setSheetName(this._sheets.size() - 1, "Sheet" + (this._sheets.size() - 1));
        boolean isOnlySheet = this._sheets.size() == 1;
        sheet.setSelected(isOnlySheet);
        sheet.setActive(isOnlySheet);
        return sheet;
    }

    @Override
    public HSSFSheet cloneSheet(int sheetIndex) {
        this.validateSheetIndex(sheetIndex);
        HSSFSheet srcSheet = (HSSFSheet)this._sheets.get(sheetIndex);
        String srcName = this.workbook.getSheetName(sheetIndex);
        HSSFSheet clonedSheet = srcSheet.cloneSheet(this);
        clonedSheet.setSelected(false);
        clonedSheet.setActive(false);
        String name = this.getUniqueSheetName(srcName);
        int newSheetIndex = this._sheets.size();
        this._sheets.add(clonedSheet);
        this.workbook.setSheetName(newSheetIndex, name);
        int filterDbNameIndex = this.findExistingBuiltinNameRecordIdx(sheetIndex, (byte)13);
        if (filterDbNameIndex >= 0) {
            NameRecord origNameRecord = this.workbook.getNameRecord(filterDbNameIndex);
            short newExtSheetIx = this.workbook.checkExternSheet(newSheetIndex);
            Ptg[] ptgs = origNameRecord.getNameDefinition();
            for (int i = 0; i < ptgs.length; ++i) {
                Ptg ptg = ptgs[i];
                if (ptg instanceof Area3DPtg) {
                    Area3DPtg a3p = (Area3DPtg)((OperandPtg)ptg).copy();
                    a3p.setExternSheetIndex(newExtSheetIx);
                    ptgs[i] = a3p;
                    continue;
                }
                if (!(ptg instanceof Ref3DPtg)) continue;
                Ref3DPtg r3p = (Ref3DPtg)((OperandPtg)ptg).copy();
                r3p.setExternSheetIndex(newExtSheetIx);
                ptgs[i] = r3p;
            }
            NameRecord newNameRecord = this.workbook.createBuiltInName((byte)13, newSheetIndex + 1);
            newNameRecord.setNameDefinition(ptgs);
            newNameRecord.setHidden(true);
            HSSFName newName = new HSSFName(this, newNameRecord);
            this.names.add(newName);
            this.workbook.cloneDrawings(clonedSheet.getSheet());
        }
        return clonedSheet;
    }

    private String getUniqueSheetName(String srcName) {
        String index;
        String name;
        int uniqueIndex = 2;
        String baseName = srcName;
        int bracketPos = srcName.lastIndexOf(40);
        if (bracketPos > 0 && srcName.endsWith(")")) {
            String suffix = srcName.substring(bracketPos + 1, srcName.length() - ")".length());
            try {
                uniqueIndex = Integer.parseInt(suffix.trim());
                baseName = srcName.substring(0, bracketPos).trim();
            }
            catch (NumberFormatException e2) {
                // empty catch block
            }
        }
        do {
            int n = ++uniqueIndex;
            ++uniqueIndex;
            index = Integer.toString(n);
        } while (this.workbook.getSheetIndex(name = baseName.length() + index.length() + 2 < 31 ? baseName + " (" + index + ")" : baseName.substring(0, 31 - index.length() - 2) + "(" + index + ")") != -1);
        return name;
    }

    @Override
    public HSSFSheet createSheet(String sheetname) {
        if (this.workbook.doesContainsSheetName(sheetname, this._sheets.size())) {
            throw new IllegalArgumentException("The workbook already contains a sheet of this name");
        }
        HSSFSheet sheet = new HSSFSheet(this);
        this.workbook.setSheetName(this._sheets.size(), sheetname);
        this._sheets.add(sheet);
        boolean isOnlySheet = this._sheets.size() == 1;
        sheet.setSelected(isOnlySheet);
        sheet.setActive(isOnlySheet);
        return sheet;
    }

    @Override
    public int getNumberOfSheets() {
        return this._sheets.size();
    }

    public int getSheetIndexFromExternSheetIndex(int externSheetNumber) {
        return this.workbook.getSheetIndexFromExternSheetIndex(externSheetNumber);
    }

    private HSSFSheet[] getSheets() {
        HSSFSheet[] result = new HSSFSheet[this._sheets.size()];
        this._sheets.toArray(result);
        return result;
    }

    @Override
    public HSSFSheet getSheetAt(int index) {
        this.validateSheetIndex(index);
        return (HSSFSheet)this._sheets.get(index);
    }

    @Override
    public HSSFSheet getSheet(String name) {
        HSSFSheet retval = null;
        for (int k = 0; k < this._sheets.size(); ++k) {
            String sheetname = this.workbook.getSheetName(k);
            if (!sheetname.equalsIgnoreCase(name)) continue;
            retval = (HSSFSheet)this._sheets.get(k);
        }
        return retval;
    }

    @Override
    public void removeSheetAt(int index) {
        this.validateSheetIndex(index);
        boolean wasActive = this.getSheetAt(index).isActive();
        boolean wasSelected = this.getSheetAt(index).isSelected();
        this._sheets.remove(index);
        this.workbook.removeSheet(index);
        int nSheets = this._sheets.size();
        if (nSheets < 1) {
            return;
        }
        int newSheetIndex = index;
        if (newSheetIndex >= nSheets) {
            newSheetIndex = nSheets - 1;
        }
        if (wasActive) {
            this.setActiveSheet(newSheetIndex);
        }
        if (wasSelected) {
            boolean someOtherSheetIsStillSelected = false;
            for (int i = 0; i < nSheets; ++i) {
                if (!this.getSheetAt(i).isSelected()) continue;
                someOtherSheetIsStillSelected = true;
                break;
            }
            if (!someOtherSheetIsStillSelected) {
                this.setSelectedTab(newSheetIndex);
            }
        }
    }

    public void setBackupFlag(boolean backupValue) {
        BackupRecord backupRecord = this.workbook.getBackupRecord();
        backupRecord.setBackup(backupValue ? (short)1 : 0);
    }

    public boolean getBackupFlag() {
        BackupRecord backupRecord = this.workbook.getBackupRecord();
        return backupRecord.getBackup() != 0;
    }

    @Override
    public void setRepeatingRowsAndColumns(int sheetIndex, int startColumn, int endColumn, int startRow, int endRow) {
        boolean isNewRecord;
        NameRecord nameRecord;
        if (startColumn == -1 && endColumn != -1) {
            throw new IllegalArgumentException("Invalid column range specification");
        }
        if (startRow == -1 && endRow != -1) {
            throw new IllegalArgumentException("Invalid row range specification");
        }
        if (startColumn < -1 || startColumn >= 255) {
            throw new IllegalArgumentException("Invalid column range specification");
        }
        if (endColumn < -1 || endColumn >= 255) {
            throw new IllegalArgumentException("Invalid column range specification");
        }
        if (startRow < -1 || startRow > 65535) {
            throw new IllegalArgumentException("Invalid row range specification");
        }
        if (endRow < -1 || endRow > 65535) {
            throw new IllegalArgumentException("Invalid row range specification");
        }
        if (startColumn > endColumn) {
            throw new IllegalArgumentException("Invalid column range specification");
        }
        if (startRow > endRow) {
            throw new IllegalArgumentException("Invalid row range specification");
        }
        HSSFSheet sheet = this.getSheetAt(sheetIndex);
        short externSheetIndex = this.getWorkbook().checkExternSheet(sheetIndex);
        boolean settingRowAndColumn = startColumn != -1 && endColumn != -1 && startRow != -1 && endRow != -1;
        boolean removingRange = startColumn == -1 && endColumn == -1 && startRow == -1 && endRow == -1;
        int rowColHeaderNameIndex = this.findExistingBuiltinNameRecordIdx(sheetIndex, (byte)7);
        if (removingRange) {
            if (rowColHeaderNameIndex >= 0) {
                this.workbook.removeName(rowColHeaderNameIndex);
            }
            return;
        }
        if (rowColHeaderNameIndex < 0) {
            nameRecord = this.workbook.createBuiltInName((byte)7, sheetIndex + 1);
            isNewRecord = true;
        } else {
            nameRecord = this.workbook.getNameRecord(rowColHeaderNameIndex);
            isNewRecord = false;
        }
        ArrayList<Ptg> temp = new ArrayList<Ptg>();
        if (settingRowAndColumn) {
            int exprsSize = 23;
            temp.add(new MemFuncPtg(23));
        }
        if (startColumn >= 0) {
            Area3DPtg colArea = new Area3DPtg(0, 65535, startColumn, endColumn, false, false, false, false, externSheetIndex);
            temp.add(colArea);
        }
        if (startRow >= 0) {
            Area3DPtg rowArea = new Area3DPtg(startRow, endRow, 0, 255, false, false, false, false, externSheetIndex);
            temp.add(rowArea);
        }
        if (settingRowAndColumn) {
            temp.add(UnionPtg.instance);
        }
        Ptg[] ptgs = new Ptg[temp.size()];
        temp.toArray(ptgs);
        nameRecord.setNameDefinition(ptgs);
        if (isNewRecord) {
            HSSFName newName = new HSSFName(this, nameRecord, nameRecord.isBuiltInName() ? null : this.workbook.getNameCommentRecord(nameRecord));
            this.names.add(newName);
        }
        HSSFPrintSetup printSetup = sheet.getPrintSetup();
        printSetup.setValidSettings(false);
        sheet.setActive(true);
    }

    private int findExistingBuiltinNameRecordIdx(int sheetIndex, byte builtinCode) {
        for (int defNameIndex = 0; defNameIndex < this.names.size(); ++defNameIndex) {
            NameRecord r = this.workbook.getNameRecord(defNameIndex);
            if (r == null) {
                throw new RuntimeException("Unable to find all defined names to iterate over");
            }
            if (!r.isBuiltInName() || r.getBuiltInName() != builtinCode || r.getSheetNumber() - 1 != sheetIndex) continue;
            return defNameIndex;
        }
        return -1;
    }

    @Override
    public HSSFFont createFont() {
        FontRecord font = this.workbook.createNewFont();
        short fontindex = (short)(this.getNumberOfFonts() - 1);
        if (fontindex > 3) {
            fontindex = (short)(fontindex + 1);
        }
        if (fontindex == Short.MAX_VALUE) {
            throw new IllegalArgumentException("Maximum number of fonts was exceeded");
        }
        return this.getFontAt(fontindex);
    }

    @Override
    public HSSFFont findFont(short boldWeight, short color, short fontHeight, String name, boolean italic, boolean strikeout, short typeOffset, byte underline) {
        for (short i = 0; i <= this.getNumberOfFonts(); i = (short)(i + 1)) {
            HSSFFont hssfFont;
            if (i == 4 || (hssfFont = this.getFontAt(i)).getBoldweight() != boldWeight || hssfFont.getColor() != color || hssfFont.getFontHeight() != fontHeight || !hssfFont.getFontName().equals(name) || hssfFont.getItalic() != italic || hssfFont.getStrikeout() != strikeout || hssfFont.getTypeOffset() != typeOffset || hssfFont.getUnderline() != underline) continue;
            return hssfFont;
        }
        return null;
    }

    @Override
    public short getNumberOfFonts() {
        return (short)this.workbook.getNumberOfFontRecords();
    }

    @Override
    public HSSFFont getFontAt(short idx) {
        Short sIdx;
        if (this.fonts == null) {
            this.fonts = new Hashtable();
        }
        if (this.fonts.containsKey(sIdx = Short.valueOf(idx))) {
            return (HSSFFont)this.fonts.get(sIdx);
        }
        FontRecord font = this.workbook.getFontRecordAt(idx);
        HSSFFont retval = new HSSFFont(idx, font);
        this.fonts.put(sIdx, retval);
        return retval;
    }

    protected void resetFontCache() {
        this.fonts = new Hashtable();
    }

    @Override
    public HSSFCellStyle createCellStyle() {
        ExtendedFormatRecord xfr = this.workbook.createCellXF();
        short index = (short)(this.getNumCellStyles() - 1);
        HSSFCellStyle style = new HSSFCellStyle(index, xfr, this);
        return style;
    }

    @Override
    public short getNumCellStyles() {
        return (short)this.workbook.getNumExFormats();
    }

    @Override
    public HSSFCellStyle getCellStyleAt(short idx) {
        ExtendedFormatRecord xfr = this.workbook.getExFormatAt(idx);
        HSSFCellStyle style = new HSSFCellStyle(idx, xfr, this);
        return style;
    }

    @Override
    public void write(OutputStream stream) throws IOException {
        byte[] bytes = this.getBytes();
        POIFSFileSystem fs = new POIFSFileSystem();
        ArrayList<String> excepts = new ArrayList<String>(1);
        fs.createDocument(new ByteArrayInputStream(bytes), "Workbook");
        this.writeProperties(fs, excepts);
        if (this.preserveNodes) {
            excepts.add("Workbook");
            excepts.add("WORKBOOK");
            POIFSFileSystem srcFs = this.filesystem;
            this.copyNodes(srcFs, fs, excepts);
            fs.getRoot().setStorageClsid(srcFs.getRoot().getStorageClsid());
        }
        fs.writeFilesystem(stream);
    }

    public byte[] getBytes() {
        if (log.check(POILogger.DEBUG)) {
            log.log(DEBUG, "HSSFWorkbook.getBytes()");
        }
        HSSFSheet[] sheets = this.getSheets();
        int nSheets = sheets.length;
        for (int i = 0; i < nSheets; ++i) {
            sheets[i].getSheet().preSerialize();
        }
        int totalsize = this.workbook.getSize();
        SheetRecordCollector[] srCollectors = new SheetRecordCollector[nSheets];
        for (int k = 0; k < nSheets; ++k) {
            this.workbook.setSheetBof(k, totalsize);
            SheetRecordCollector src = new SheetRecordCollector();
            sheets[k].getSheet().visitContainedRecords(src, totalsize);
            totalsize += src.getTotalSize();
            srCollectors[k] = src;
        }
        byte[] retval = new byte[totalsize];
        int pos = this.workbook.serialize(0, retval);
        for (int k = 0; k < nSheets; ++k) {
            SheetRecordCollector src = srCollectors[k];
            int serializedSize = src.serialize(pos, retval);
            if (serializedSize != src.getTotalSize()) {
                throw new IllegalStateException("Actual serialized sheet size (" + serializedSize + ") differs from pre-calculated size (" + src.getTotalSize() + ") for sheet (" + k + ")");
            }
            pos += serializedSize;
        }
        return retval;
    }

    public int addSSTString(String string) {
        return this.workbook.addSSTString(new UnicodeString(string));
    }

    public String getSSTString(int index) {
        return this.workbook.getSSTString(index).getString();
    }

    InternalWorkbook getWorkbook() {
        return this.workbook;
    }

    @Override
    public int getNumberOfNames() {
        int result = this.names.size();
        return result;
    }

    @Override
    public HSSFName getName(String name) {
        int nameIndex = this.getNameIndex(name);
        if (nameIndex < 0) {
            return null;
        }
        return (HSSFName)this.names.get(nameIndex);
    }

    @Override
    public HSSFName getNameAt(int nameIndex) {
        int nNames = this.names.size();
        if (nNames < 1) {
            throw new IllegalStateException("There are no defined names in this workbook");
        }
        if (nameIndex < 0 || nameIndex > nNames) {
            throw new IllegalArgumentException("Specified name index " + nameIndex + " is outside the allowable range (0.." + (nNames - 1) + ").");
        }
        return (HSSFName)this.names.get(nameIndex);
    }

    public NameRecord getNameRecord(int nameIndex) {
        return this.getWorkbook().getNameRecord(nameIndex);
    }

    public String getNameName(int index) {
        String result = this.getNameAt(index).getNameName();
        return result;
    }

    @Override
    public void setPrintArea(int sheetIndex, String reference) {
        NameRecord name = this.workbook.getSpecificBuiltinRecord((byte)6, sheetIndex + 1);
        if (name == null) {
            name = this.workbook.createBuiltInName((byte)6, sheetIndex + 1);
        }
        String[] parts = COMMA_PATTERN.split(reference);
        StringBuffer sb = new StringBuffer(32);
        for (int i = 0; i < parts.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            SheetNameFormatter.appendFormat(sb, this.getSheetName(sheetIndex));
            sb.append("!");
            sb.append(parts[i]);
        }
        name.setNameDefinition(HSSFFormulaParser.parse(sb.toString(), this, 0, sheetIndex));
    }

    @Override
    public void setPrintArea(int sheetIndex, int startColumn, int endColumn, int startRow, int endRow) {
        CellReference cell = new CellReference(startRow, startColumn, true, true);
        String reference = cell.formatAsString();
        cell = new CellReference(endRow, endColumn, true, true);
        reference = reference + ":" + cell.formatAsString();
        this.setPrintArea(sheetIndex, reference);
    }

    @Override
    public String getPrintArea(int sheetIndex) {
        NameRecord name = this.workbook.getSpecificBuiltinRecord((byte)6, sheetIndex + 1);
        if (name == null) {
            return null;
        }
        return HSSFFormulaParser.toFormulaString(this, name.getNameDefinition());
    }

    @Override
    public void removePrintArea(int sheetIndex) {
        this.getWorkbook().removeBuiltinRecord((byte)6, sheetIndex + 1);
    }

    @Override
    public HSSFName createName() {
        NameRecord nameRecord = this.workbook.createName();
        HSSFName newName = new HSSFName(this, nameRecord);
        this.names.add(newName);
        return newName;
    }

    @Override
    public int getNameIndex(String name) {
        for (int k = 0; k < this.names.size(); ++k) {
            String nameName = this.getNameName(k);
            if (!nameName.equalsIgnoreCase(name)) continue;
            return k;
        }
        return -1;
    }

    @Override
    public void removeName(int index) {
        this.names.remove(index);
        this.workbook.removeName(index);
    }

    @Override
    public HSSFDataFormat createDataFormat() {
        if (this.formatter == null) {
            this.formatter = new HSSFDataFormat(this.workbook);
        }
        return this.formatter;
    }

    @Override
    public void removeName(String name) {
        int index = this.getNameIndex(name);
        this.removeName(index);
    }

    public HSSFPalette getCustomPalette() {
        return new HSSFPalette(this.workbook.getCustomPalette());
    }

    public void insertChartRecord() {
        int loc = this.workbook.findFirstRecordLocBySid((short)252);
        byte[] data = new byte[]{15, 0, 0, -16, 82, 0, 0, 0, 0, 0, 6, -16, 24, 0, 0, 0, 1, 8, 0, 0, 2, 0, 0, 0, 2, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 3, 0, 0, 0, 51, 0, 11, -16, 18, 0, 0, 0, -65, 0, 8, 0, 8, 0, -127, 1, 9, 0, 0, 8, -64, 1, 64, 0, 0, 8, 64, 0, 30, -15, 16, 0, 0, 0, 13, 0, 0, 8, 12, 0, 0, 8, 23, 0, 0, 8, -9, 0, 0, 16};
        UnknownRecord r = new UnknownRecord(235, data);
        this.workbook.getRecords().add(loc, r);
    }

    public void dumpDrawingGroupRecords(boolean fat) {
        DrawingGroupRecord r = (DrawingGroupRecord)this.workbook.findFirstRecordBySid((short)235);
        r.decode();
        List<EscherRecord> escherRecords = r.getEscherRecords();
        PrintWriter w = new PrintWriter(System.out);
        for (EscherRecord escherRecord : escherRecords) {
            if (fat) {
                System.out.println(escherRecord.toString());
                continue;
            }
            escherRecord.display(w, 0);
        }
        w.flush();
    }

    @Override
    public int addPicture(byte[] pictureData, int format) {
        byte[] uid = HSSFWorkbook.newUID();
        EscherBitmapBlip blipRecord = new EscherBitmapBlip();
        blipRecord.setRecordId((short)(-4072 + format));
        switch (format) {
            case 2: {
                blipRecord.setOptions((short)15680);
                break;
            }
            case 3: {
                blipRecord.setOptions((short)8544);
                break;
            }
            case 4: {
                blipRecord.setOptions((short)21536);
                break;
            }
            case 6: {
                blipRecord.setOptions((short)28160);
                break;
            }
            case 5: {
                blipRecord.setOptions((short)18080);
                break;
            }
            case 7: {
                blipRecord.setOptions((short)31360);
            }
        }
        blipRecord.setUID(uid);
        blipRecord.setMarker((byte)-1);
        blipRecord.setPictureData(pictureData);
        EscherBSERecord r = new EscherBSERecord();
        r.setRecordId((short)-4089);
        r.setOptions((short)(2 | format << 4));
        r.setBlipTypeMacOS((byte)format);
        r.setBlipTypeWin32((byte)format);
        r.setUid(uid);
        r.setTag((short)255);
        r.setSize(pictureData.length + 25);
        r.setRef(1);
        r.setOffset(0);
        r.setBlipRecord(blipRecord);
        return this.workbook.addBSERecord(r);
    }

    public List<HSSFPictureData> getAllPictures() {
        ArrayList<HSSFPictureData> pictures = new ArrayList<HSSFPictureData>();
        for (Record r : this.workbook.getRecords()) {
            if (!(r instanceof AbstractEscherHolderRecord)) continue;
            ((AbstractEscherHolderRecord)r).decode();
            List<EscherRecord> escherRecords = ((AbstractEscherHolderRecord)r).getEscherRecords();
            this.searchForPictures(escherRecords, pictures);
        }
        return pictures;
    }

    private void searchForPictures(List<EscherRecord> escherRecords, List<HSSFPictureData> pictures) {
        for (EscherRecord escherRecord : escherRecords) {
            EscherBlipRecord blip;
            if (escherRecord instanceof EscherBSERecord && (blip = ((EscherBSERecord)escherRecord).getBlipRecord()) != null) {
                HSSFPictureData picture = new HSSFPictureData(blip);
                pictures.add(picture);
            }
            this.searchForPictures(escherRecord.getChildRecords(), pictures);
        }
    }

    public boolean isWriteProtected() {
        return this.workbook.isWriteProtected();
    }

    public void writeProtectWorkbook(String password, String username) {
        this.workbook.writeProtectWorkbook(password, username);
    }

    public void unwriteProtectWorkbook() {
        this.workbook.unwriteProtectWorkbook();
    }

    public List<HSSFObjectData> getAllEmbeddedObjects() {
        ArrayList<HSSFObjectData> objects = new ArrayList<HSSFObjectData>();
        for (int i = 0; i < this.getNumberOfSheets(); ++i) {
            this.getAllEmbeddedObjects(this.getSheetAt(i).getSheet().getRecords(), objects);
        }
        return objects;
    }

    private void getAllEmbeddedObjects(List records, List<HSSFObjectData> objects) {
        for (Object obj : records) {
            if (!(obj instanceof ObjRecord)) continue;
            for (SubRecord sub : ((ObjRecord)obj).getSubRecords()) {
                if (!(sub instanceof EmbeddedObjectRefSubRecord)) continue;
                objects.add(new HSSFObjectData((ObjRecord)obj, this.filesystem));
            }
        }
    }

    @Override
    public CreationHelper getCreationHelper() {
        return new HSSFCreationHelper(this);
    }

    private static byte[] newUID() {
        return new byte[16];
    }

    public NameXPtg getNameXPtg(String name) {
        return this.workbook.getNameXPtg(name);
    }

    private static final class SheetRecordCollector
    implements RecordAggregate.RecordVisitor {
        private List _list = new ArrayList(128);
        private int _totalSize = 0;

        public int getTotalSize() {
            return this._totalSize;
        }

        public void visitRecord(Record r) {
            this._list.add(r);
            this._totalSize += r.getRecordSize();
        }

        public int serialize(int offset, byte[] data) {
            int result = 0;
            int nRecs = this._list.size();
            for (int i = 0; i < nRecs; ++i) {
                Record rec = (Record)this._list.get(i);
                result += rec.serialize(offset + result, data);
            }
            return result;
        }
    }
}

