/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.filesystem;

import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentNode;
import org.apache.poi.poifs.filesystem.POIFSDocument;
import org.apache.poi.poifs.storage.DataInputBlock;
import org.apache.poi.util.LittleEndianInput;

public final class DocumentInputStream
extends InputStream
implements LittleEndianInput {
    private static final int EOF = -1;
    private static final int SIZE_SHORT = 2;
    private static final int SIZE_INT = 4;
    private static final int SIZE_LONG = 8;
    private int _current_offset;
    private int _marked_offset;
    private int _document_size;
    private boolean _closed;
    private POIFSDocument _document;
    private DataInputBlock _currentBlock;

    public DocumentInputStream(DocumentEntry document) throws IOException {
        if (!(document instanceof DocumentNode)) {
            throw new IOException("Cannot open internal document storage");
        }
        this._current_offset = 0;
        this._marked_offset = 0;
        this._document_size = document.getSize();
        this._closed = false;
        this._document = ((DocumentNode)document).getDocument();
        this._currentBlock = this.getDataInputBlock(0);
    }

    public DocumentInputStream(POIFSDocument document) {
        this._current_offset = 0;
        this._marked_offset = 0;
        this._document_size = document.getSize();
        this._closed = false;
        this._document = document;
        this._currentBlock = this.getDataInputBlock(0);
    }

    public int available() {
        if (this._closed) {
            throw new IllegalStateException("cannot perform requested operation on a closed stream");
        }
        return this._document_size - this._current_offset;
    }

    public void close() {
        this._closed = true;
    }

    public void mark(int ignoredReadlimit) {
        this._marked_offset = this._current_offset;
    }

    public boolean markSupported() {
        return true;
    }

    private DataInputBlock getDataInputBlock(int offset) {
        return this._document.getDataInputBlock(offset);
    }

    public int read() throws IOException {
        this.dieIfClosed();
        if (this.atEOD()) {
            return -1;
        }
        int result = this._currentBlock.readUByte();
        ++this._current_offset;
        if (this._currentBlock.available() < 1) {
            this._currentBlock = this.getDataInputBlock(this._current_offset);
        }
        return result;
    }

    public int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        this.dieIfClosed();
        if (b2 == null) {
            throw new IllegalArgumentException("buffer must not be null");
        }
        if (off < 0 || len < 0 || b2.length < off + len) {
            throw new IndexOutOfBoundsException("can't read past buffer boundaries");
        }
        if (len == 0) {
            return 0;
        }
        if (this.atEOD()) {
            return -1;
        }
        int limit = Math.min(this.available(), len);
        this.readFully(b2, off, limit);
        return limit;
    }

    public void reset() {
        this._current_offset = this._marked_offset;
        this._currentBlock = this.getDataInputBlock(this._current_offset);
    }

    public long skip(long n) throws IOException {
        this.dieIfClosed();
        if (n < 0L) {
            return 0L;
        }
        int new_offset = this._current_offset + (int)n;
        if (new_offset < this._current_offset) {
            new_offset = this._document_size;
        } else if (new_offset > this._document_size) {
            new_offset = this._document_size;
        }
        long rval = new_offset - this._current_offset;
        this._current_offset = new_offset;
        this._currentBlock = this.getDataInputBlock(this._current_offset);
        return rval;
    }

    private void dieIfClosed() throws IOException {
        if (this._closed) {
            throw new IOException("cannot perform requested operation on a closed stream");
        }
    }

    private boolean atEOD() {
        return this._current_offset == this._document_size;
    }

    private void checkAvaliable(int requestedSize) {
        if (this._closed) {
            throw new IllegalStateException("cannot perform requested operation on a closed stream");
        }
        if (requestedSize > this._document_size - this._current_offset) {
            throw new RuntimeException("Buffer underrun - requested " + requestedSize + " bytes but " + (this._document_size - this._current_offset) + " was available");
        }
    }

    public byte readByte() {
        return (byte)this.readUByte();
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public void readFully(byte[] buf) {
        this.readFully(buf, 0, buf.length);
    }

    public short readShort() {
        return (short)this.readUShort();
    }

    public void readFully(byte[] buf, int off, int len) {
        this.checkAvaliable(len);
        int blockAvailable = this._currentBlock.available();
        if (blockAvailable > len) {
            this._currentBlock.readFully(buf, off, len);
            this._current_offset += len;
            return;
        }
        int remaining = len;
        int writePos = off;
        while (remaining > 0) {
            boolean blockIsExpiring = remaining >= blockAvailable;
            int reqSize = blockIsExpiring ? blockAvailable : remaining;
            this._currentBlock.readFully(buf, writePos, reqSize);
            remaining -= reqSize;
            writePos += reqSize;
            this._current_offset += reqSize;
            if (!blockIsExpiring) continue;
            if (this._current_offset == this._document_size) {
                if (remaining > 0) {
                    throw new IllegalStateException("reached end of document stream unexpectedly");
                }
                this._currentBlock = null;
                break;
            }
            this._currentBlock = this.getDataInputBlock(this._current_offset);
            blockAvailable = this._currentBlock.available();
        }
    }

    public long readLong() {
        long result;
        this.checkAvaliable(8);
        int blockAvailable = this._currentBlock.available();
        if (blockAvailable > 8) {
            result = this._currentBlock.readLongLE();
        } else {
            DataInputBlock nextBlock = this.getDataInputBlock(this._current_offset + blockAvailable);
            result = blockAvailable == 8 ? this._currentBlock.readLongLE() : nextBlock.readLongLE(this._currentBlock, blockAvailable);
            this._currentBlock = nextBlock;
        }
        this._current_offset += 8;
        return result;
    }

    public int readInt() {
        int result;
        this.checkAvaliable(4);
        int blockAvailable = this._currentBlock.available();
        if (blockAvailable > 4) {
            result = this._currentBlock.readIntLE();
        } else {
            DataInputBlock nextBlock = this.getDataInputBlock(this._current_offset + blockAvailable);
            result = blockAvailable == 4 ? this._currentBlock.readIntLE() : nextBlock.readIntLE(this._currentBlock, blockAvailable);
            this._currentBlock = nextBlock;
        }
        this._current_offset += 4;
        return result;
    }

    public int readUShort() {
        int result;
        this.checkAvaliable(2);
        int blockAvailable = this._currentBlock.available();
        if (blockAvailable > 2) {
            result = this._currentBlock.readUShortLE();
        } else {
            DataInputBlock nextBlock = this.getDataInputBlock(this._current_offset + blockAvailable);
            result = blockAvailable == 2 ? this._currentBlock.readUShortLE() : nextBlock.readUShortLE(this._currentBlock);
            this._currentBlock = nextBlock;
        }
        this._current_offset += 2;
        return result;
    }

    public int readUByte() {
        this.checkAvaliable(1);
        int result = this._currentBlock.readUByte();
        ++this._current_offset;
        if (this._currentBlock.available() < 1) {
            this._currentBlock = this.getDataInputBlock(this._current_offset);
        }
        return result;
    }
}

