/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.format;

import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import org.apache.poi.ss.format.CellFormatPart;
import org.apache.poi.ss.format.CellFormatResult;
import org.apache.poi.ss.format.CellFormatter;
import org.apache.poi.ss.format.CellNumberFormatter;
import org.apache.poi.ss.usermodel.Cell;

public class CellFormat {
    private final String format;
    private final CellFormatPart posNumFmt;
    private final CellFormatPart zeroNumFmt;
    private final CellFormatPart negNumFmt;
    private final CellFormatPart textFmt;
    private static final Pattern ONE_PART = Pattern.compile(CellFormatPart.FORMAT_PAT.pattern() + "(;|$)", 6);
    private static final CellFormatPart DEFAULT_TEXT_FORMAT = new CellFormatPart("@");
    public static final CellFormat GENERAL_FORMAT = new CellFormat("General"){

        public CellFormatResult apply(Object value) {
            String text = value == null ? "" : (value instanceof Number ? CellNumberFormatter.SIMPLE_NUMBER.format(value) : value.toString());
            return new CellFormatResult(true, text, null);
        }
    };
    private static final Map<String, CellFormat> formatCache = new WeakHashMap<String, CellFormat>();

    public static CellFormat getInstance(String format) {
        CellFormat fmt = formatCache.get(format);
        if (fmt == null) {
            fmt = format.equals("General") ? GENERAL_FORMAT : new CellFormat(format);
            formatCache.put(format, fmt);
        }
        return fmt;
    }

    private CellFormat(String format) {
        this.format = format;
        Matcher m = ONE_PART.matcher(format);
        ArrayList<CellFormatPart> parts = new ArrayList<CellFormatPart>();
        while (m.find()) {
            try {
                String valueDesc = m.group();
                if (valueDesc.endsWith(";")) {
                    valueDesc = valueDesc.substring(0, valueDesc.length() - 1);
                }
                parts.add(new CellFormatPart(valueDesc));
            }
            catch (RuntimeException e2) {
                CellFormatter.logger.log(Level.WARNING, "Invalid format: " + CellFormatter.quote(m.group()), e2);
                parts.add(null);
            }
        }
        switch (parts.size()) {
            case 1: {
                this.zeroNumFmt = this.negNumFmt = (CellFormatPart)parts.get(0);
                this.posNumFmt = this.negNumFmt;
                this.textFmt = DEFAULT_TEXT_FORMAT;
                break;
            }
            case 2: {
                this.posNumFmt = this.zeroNumFmt = (CellFormatPart)parts.get(0);
                this.negNumFmt = (CellFormatPart)parts.get(1);
                this.textFmt = DEFAULT_TEXT_FORMAT;
                break;
            }
            case 3: {
                this.posNumFmt = (CellFormatPart)parts.get(0);
                this.zeroNumFmt = (CellFormatPart)parts.get(1);
                this.negNumFmt = (CellFormatPart)parts.get(2);
                this.textFmt = DEFAULT_TEXT_FORMAT;
                break;
            }
            default: {
                this.posNumFmt = (CellFormatPart)parts.get(0);
                this.zeroNumFmt = (CellFormatPart)parts.get(1);
                this.negNumFmt = (CellFormatPart)parts.get(2);
                this.textFmt = (CellFormatPart)parts.get(3);
            }
        }
    }

    public CellFormatResult apply(Object value) {
        if (value instanceof Number) {
            Number num = (Number)value;
            double val = num.doubleValue();
            if (val > 0.0) {
                return this.posNumFmt.apply(value);
            }
            if (val < 0.0) {
                return this.negNumFmt.apply(-val);
            }
            return this.zeroNumFmt.apply(value);
        }
        return this.textFmt.apply(value);
    }

    public CellFormatResult apply(Cell c2) {
        switch (CellFormat.ultimateType(c2)) {
            case 3: {
                return this.apply("");
            }
            case 4: {
                return this.apply(c2.getStringCellValue());
            }
            case 0: {
                return this.apply(c2.getNumericCellValue());
            }
            case 1: {
                return this.apply(c2.getStringCellValue());
            }
        }
        return this.apply("?");
    }

    public CellFormatResult apply(JLabel label, Object value) {
        CellFormatResult result = this.apply(value);
        label.setText(result.text);
        if (result.textColor != null) {
            label.setForeground(result.textColor);
        }
        return result;
    }

    public CellFormatResult apply(JLabel label, Cell c2) {
        switch (CellFormat.ultimateType(c2)) {
            case 3: {
                return this.apply(label, "");
            }
            case 4: {
                return this.apply(label, c2.getStringCellValue());
            }
            case 0: {
                return this.apply(label, c2.getNumericCellValue());
            }
            case 1: {
                return this.apply(label, c2.getStringCellValue());
            }
        }
        return this.apply(label, "?");
    }

    public static int ultimateType(Cell cell) {
        int type = cell.getCellType();
        if (type == 2) {
            return cell.getCachedFormulaResultType();
        }
        return type;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CellFormat) {
            CellFormat that = (CellFormat)obj;
            return this.format.equals(that.format);
        }
        return false;
    }

    public int hashCode() {
        return this.format.hashCode();
    }
}

