/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.usermodel;

import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.poi.ss.usermodel.DataFormatter;

public class ExcelStyleDateFormatter
extends SimpleDateFormat {
    public static final char MMMMM_START_SYMBOL = '\ue001';
    public static final char MMMMM_TRUNCATE_SYMBOL = '\ue002';
    public static final char H_BRACKET_SYMBOL = '\ue010';
    public static final char HH_BRACKET_SYMBOL = '\ue011';
    public static final char M_BRACKET_SYMBOL = '\ue012';
    public static final char MM_BRACKET_SYMBOL = '\ue013';
    public static final char S_BRACKET_SYMBOL = '\ue014';
    public static final char SS_BRACKET_SYMBOL = '\ue015';
    private DecimalFormat format1digit = new DecimalFormat("0");
    private DecimalFormat format2digits = new DecimalFormat("00");
    private double dateToBeFormatted;

    public ExcelStyleDateFormatter() {
        DataFormatter.setExcelStyleRoundingMode(this.format1digit);
        DataFormatter.setExcelStyleRoundingMode(this.format2digits);
        this.dateToBeFormatted = 0.0;
    }

    public ExcelStyleDateFormatter(String pattern) {
        super(ExcelStyleDateFormatter.processFormatPattern(pattern));
        DataFormatter.setExcelStyleRoundingMode(this.format1digit);
        DataFormatter.setExcelStyleRoundingMode(this.format2digits);
        this.dateToBeFormatted = 0.0;
    }

    public ExcelStyleDateFormatter(String pattern, DateFormatSymbols formatSymbols) {
        super(ExcelStyleDateFormatter.processFormatPattern(pattern), formatSymbols);
        DataFormatter.setExcelStyleRoundingMode(this.format1digit);
        DataFormatter.setExcelStyleRoundingMode(this.format2digits);
        this.dateToBeFormatted = 0.0;
    }

    public ExcelStyleDateFormatter(String pattern, Locale locale) {
        super(ExcelStyleDateFormatter.processFormatPattern(pattern), locale);
        DataFormatter.setExcelStyleRoundingMode(this.format1digit);
        DataFormatter.setExcelStyleRoundingMode(this.format2digits);
        this.dateToBeFormatted = 0.0;
    }

    private static String processFormatPattern(String f2) {
        f2 = f2.replaceAll("MMMMM", "\ue001MMM\ue002");
        f2 = f2.replaceAll("\\[H\\]", String.valueOf('\ue010'));
        f2 = f2.replaceAll("\\[HH\\]", String.valueOf('\ue011'));
        f2 = f2.replaceAll("\\[m\\]", String.valueOf('\ue012'));
        f2 = f2.replaceAll("\\[mm\\]", String.valueOf('\ue013'));
        f2 = f2.replaceAll("\\[s\\]", String.valueOf('\ue014'));
        f2 = f2.replaceAll("\\[ss\\]", String.valueOf('\ue015'));
        return f2;
    }

    public void setDateToBeFormatted(double date) {
        this.dateToBeFormatted = date;
    }

    public StringBuffer format(Date date, StringBuffer paramStringBuffer, FieldPosition paramFieldPosition) {
        String s = super.format(date, paramStringBuffer, paramFieldPosition).toString();
        if (s.indexOf(57345) != -1) {
            s = s.replaceAll("\ue001(\\w)\\w+\ue002", "$1");
        }
        if (s.indexOf(57360) != -1 || s.indexOf(57361) != -1) {
            double hours = this.dateToBeFormatted * 24.0;
            s = s.replaceAll(String.valueOf('\ue010'), this.format1digit.format(hours));
            s = s.replaceAll(String.valueOf('\ue011'), this.format2digits.format(hours));
        }
        if (s.indexOf(57362) != -1 || s.indexOf(57363) != -1) {
            double minutes = this.dateToBeFormatted * 24.0 * 60.0;
            s = s.replaceAll(String.valueOf('\ue012'), this.format1digit.format(minutes));
            s = s.replaceAll(String.valueOf('\ue013'), this.format2digits.format(minutes));
        }
        if (s.indexOf(57364) != -1 || s.indexOf(57365) != -1) {
            double seconds = this.dateToBeFormatted * 24.0 * 60.0 * 60.0;
            s = s.replaceAll(String.valueOf('\ue014'), this.format1digit.format(seconds));
            s = s.replaceAll(String.valueOf('\ue015'), this.format2digits.format(seconds));
        }
        return new StringBuffer(s);
    }
}

