/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.util;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.ss.util.CellRangeAddressBase;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.util.LittleEndianByteArrayOutputStream;
import org.apache.poi.util.LittleEndianOutput;

public class CellRangeAddress
extends CellRangeAddressBase {
    public static final int ENCODED_SIZE = 8;

    public CellRangeAddress(int firstRow, int lastRow, int firstCol, int lastCol) {
        super(firstRow, lastRow, firstCol, lastCol);
    }

    public int serialize(int offset, byte[] data) {
        this.serialize(new LittleEndianByteArrayOutputStream(data, offset, 8));
        return 8;
    }

    public void serialize(LittleEndianOutput out) {
        out.writeShort(this.getFirstRow());
        out.writeShort(this.getLastRow());
        out.writeShort(this.getFirstColumn());
        out.writeShort(this.getLastColumn());
    }

    public CellRangeAddress(RecordInputStream in) {
        super(CellRangeAddress.readUShortAndCheck(in), in.readUShort(), in.readUShort(), in.readUShort());
    }

    private static int readUShortAndCheck(RecordInputStream in) {
        if (in.remaining() < 8) {
            throw new RuntimeException("Ran out of data reading CellRangeAddress");
        }
        return in.readUShort();
    }

    public CellRangeAddress copy() {
        return new CellRangeAddress(this.getFirstRow(), this.getLastRow(), this.getFirstColumn(), this.getLastColumn());
    }

    public static int getEncodedSize(int numberOfItems) {
        return numberOfItems * 8;
    }

    public String formatAsString() {
        StringBuffer sb = new StringBuffer();
        CellReference cellRefFrom = new CellReference(this.getFirstRow(), this.getFirstColumn());
        CellReference cellRefTo = new CellReference(this.getLastRow(), this.getLastColumn());
        sb.append(cellRefFrom.formatAsString());
        if (!cellRefFrom.equals(cellRefTo)) {
            sb.append(':');
            sb.append(cellRefTo.formatAsString());
        }
        return sb.toString();
    }

    public static CellRangeAddress valueOf(String ref) {
        CellReference b2;
        CellReference a2;
        int sep = ref.indexOf(":");
        if (sep == -1) {
            b2 = a2 = new CellReference(ref);
        } else {
            a2 = new CellReference(ref.substring(0, sep));
            b2 = new CellReference(ref.substring(sep + 1));
        }
        return new CellRangeAddress(a2.getRow(), b2.getRow(), a2.getCol(), b2.getCol());
    }
}

