/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Map;
import org.apache.sanselan.FormatCompliance;
import org.apache.sanselan.ImageFormat;
import org.apache.sanselan.ImageInfo;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.SanselanConstants;
import org.apache.sanselan.common.BinaryFileParser;
import org.apache.sanselan.common.IBufferedImageFactory;
import org.apache.sanselan.common.IImageMetadata;
import org.apache.sanselan.common.SimpleBufferedImageFactory;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.common.byteSources.ByteSourceArray;
import org.apache.sanselan.common.byteSources.ByteSourceFile;
import org.apache.sanselan.formats.bmp.BmpImageParser;
import org.apache.sanselan.formats.gif.GifImageParser;
import org.apache.sanselan.formats.ico.IcoImageParser;
import org.apache.sanselan.formats.jpeg.JpegImageParser;
import org.apache.sanselan.formats.png.PngImageParser;
import org.apache.sanselan.formats.pnm.PNMImageParser;
import org.apache.sanselan.formats.psd.PsdImageParser;
import org.apache.sanselan.formats.tiff.TiffImageParser;
import org.apache.sanselan.util.Debug;

public abstract class ImageParser
extends BinaryFileParser
implements SanselanConstants {
    public static final ImageParser[] getAllImageParsers() {
        ImageParser[] result = new ImageParser[]{new JpegImageParser(), new TiffImageParser(), new PngImageParser(), new BmpImageParser(), new GifImageParser(), new PsdImageParser(), new PNMImageParser(), new IcoImageParser()};
        return result;
    }

    public final IImageMetadata getMetadata(ByteSource byteSource) throws ImageReadException, IOException {
        return this.getMetadata(byteSource, null);
    }

    public abstract IImageMetadata getMetadata(ByteSource var1, Map var2) throws ImageReadException, IOException;

    public final IImageMetadata getMetadata(byte[] bytes) throws ImageReadException, IOException {
        return this.getMetadata(bytes);
    }

    public final IImageMetadata getMetadata(byte[] bytes, Map params) throws ImageReadException, IOException {
        return this.getMetadata(new ByteSourceArray(bytes), params);
    }

    public final IImageMetadata getMetadata(File file) throws ImageReadException, IOException {
        return this.getMetadata(file, null);
    }

    public final IImageMetadata getMetadata(File file, Map params) throws ImageReadException, IOException {
        if (this.debug) {
            System.out.println(this.getName() + ".getMetadata" + ": " + file.getName());
        }
        if (!this.canAcceptExtension(file)) {
            return null;
        }
        return this.getMetadata(new ByteSourceFile(file), params);
    }

    public abstract ImageInfo getImageInfo(ByteSource var1, Map var2) throws ImageReadException, IOException;

    public final ImageInfo getImageInfo(ByteSource byteSource) throws ImageReadException, IOException {
        return this.getImageInfo(byteSource, null);
    }

    public final ImageInfo getImageInfo(byte[] bytes, Map params) throws ImageReadException, IOException {
        return this.getImageInfo(new ByteSourceArray(bytes), params);
    }

    public final ImageInfo getImageInfo(File file, Map params) throws ImageReadException, IOException {
        if (!this.canAcceptExtension(file)) {
            return null;
        }
        return this.getImageInfo(new ByteSourceFile(file), params);
    }

    public FormatCompliance getFormatCompliance(ByteSource byteSource) throws ImageReadException, IOException {
        return null;
    }

    public final FormatCompliance getFormatCompliance(byte[] bytes) throws ImageReadException, IOException {
        return this.getFormatCompliance(new ByteSourceArray(bytes));
    }

    public final FormatCompliance getFormatCompliance(File file) throws ImageReadException, IOException {
        if (!this.canAcceptExtension(file)) {
            return null;
        }
        return this.getFormatCompliance(new ByteSourceFile(file));
    }

    public ArrayList getAllBufferedImages(ByteSource byteSource) throws ImageReadException, IOException {
        BufferedImage bi = this.getBufferedImage(byteSource, null);
        ArrayList<BufferedImage> result = new ArrayList<BufferedImage>();
        result.add(bi);
        return result;
    }

    public final ArrayList getAllBufferedImages(byte[] bytes) throws ImageReadException, IOException {
        return this.getAllBufferedImages(new ByteSourceArray(bytes));
    }

    public final ArrayList getAllBufferedImages(File file) throws ImageReadException, IOException {
        if (!this.canAcceptExtension(file)) {
            return null;
        }
        return this.getAllBufferedImages(new ByteSourceFile(file));
    }

    public abstract BufferedImage getBufferedImage(ByteSource var1, Map var2) throws ImageReadException, IOException;

    public final BufferedImage getBufferedImage(byte[] bytes, Map params) throws ImageReadException, IOException {
        return this.getBufferedImage(new ByteSourceArray(bytes), params);
    }

    public final BufferedImage getBufferedImage(File file, Map params) throws ImageReadException, IOException {
        if (!this.canAcceptExtension(file)) {
            return null;
        }
        return this.getBufferedImage(new ByteSourceFile(file), params);
    }

    public void writeImage(BufferedImage src, OutputStream os, Map params) throws ImageWriteException, IOException {
        try {
            os.close();
        }
        catch (Exception e2) {
            Debug.debug(e2);
        }
        throw new ImageWriteException("This image format (" + this.getName() + ") cannot be written.");
    }

    public final Dimension getImageSize(byte[] bytes) throws ImageReadException, IOException {
        return this.getImageSize(bytes, null);
    }

    public final Dimension getImageSize(byte[] bytes, Map params) throws ImageReadException, IOException {
        return this.getImageSize(new ByteSourceArray(bytes), params);
    }

    public final Dimension getImageSize(File file) throws ImageReadException, IOException {
        return this.getImageSize(file, null);
    }

    public final Dimension getImageSize(File file, Map params) throws ImageReadException, IOException {
        if (!this.canAcceptExtension(file)) {
            return null;
        }
        return this.getImageSize(new ByteSourceFile(file), params);
    }

    public abstract Dimension getImageSize(ByteSource var1, Map var2) throws ImageReadException, IOException;

    public abstract String getXmpXml(ByteSource var1, Map var2) throws ImageReadException, IOException;

    public final byte[] getICCProfileBytes(byte[] bytes) throws ImageReadException, IOException {
        return this.getICCProfileBytes(bytes, null);
    }

    public final byte[] getICCProfileBytes(byte[] bytes, Map params) throws ImageReadException, IOException {
        return this.getICCProfileBytes(new ByteSourceArray(bytes), params);
    }

    public final byte[] getICCProfileBytes(File file) throws ImageReadException, IOException {
        return this.getICCProfileBytes(file, null);
    }

    public final byte[] getICCProfileBytes(File file, Map params) throws ImageReadException, IOException {
        if (!this.canAcceptExtension(file)) {
            return null;
        }
        if (this.debug) {
            System.out.println(this.getName() + ": " + file.getName());
        }
        return this.getICCProfileBytes(new ByteSourceFile(file), params);
    }

    public abstract byte[] getICCProfileBytes(ByteSource var1, Map var2) throws ImageReadException, IOException;

    public final String dumpImageFile(byte[] bytes) throws ImageReadException, IOException {
        return this.dumpImageFile(new ByteSourceArray(bytes));
    }

    public final String dumpImageFile(File file) throws ImageReadException, IOException {
        if (!this.canAcceptExtension(file)) {
            return null;
        }
        if (this.debug) {
            System.out.println(this.getName() + ": " + file.getName());
        }
        return this.dumpImageFile(new ByteSourceFile(file));
    }

    public final String dumpImageFile(ByteSource byteSource) throws ImageReadException, IOException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.dumpImageFile(pw, byteSource);
        pw.flush();
        return sw.toString();
    }

    public boolean dumpImageFile(PrintWriter pw, ByteSource byteSource) throws ImageReadException, IOException {
        return false;
    }

    public abstract boolean embedICCProfile(File var1, File var2, byte[] var3);

    public abstract String getName();

    public abstract String getDefaultExtension();

    protected abstract String[] getAcceptedExtensions();

    protected abstract ImageFormat[] getAcceptedTypes();

    public boolean canAcceptType(ImageFormat type) {
        ImageFormat[] types = this.getAcceptedTypes();
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].equals(type)) continue;
            return true;
        }
        return false;
    }

    protected final boolean canAcceptExtension(File file) {
        return this.canAcceptExtension(file.getName());
    }

    protected final boolean canAcceptExtension(String filename) {
        String[] exts = this.getAcceptedExtensions();
        if (exts == null) {
            return true;
        }
        int index = filename.lastIndexOf(46);
        if (index >= 0) {
            String ext = filename.substring(index);
            ext = ext.toLowerCase();
            for (int i = 0; i < exts.length; ++i) {
                if (!exts[i].toLowerCase().equals(ext)) continue;
                return true;
            }
        }
        return false;
    }

    protected IBufferedImageFactory getBufferedImageFactory(Map params) {
        if (params == null) {
            return new SimpleBufferedImageFactory();
        }
        IBufferedImageFactory result = (IBufferedImageFactory)params.get("BUFFERED_IMAGE_FACTORY");
        if (null != result) {
            return result;
        }
        return new SimpleBufferedImageFactory();
    }

    public static final boolean isStrict(Map params) {
        if (params == null || !params.containsKey("STRICT")) {
            return false;
        }
        return (Boolean)params.get("STRICT");
    }
}

