/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.color;

import org.apache.sanselan.color.ColorCIELCH;
import org.apache.sanselan.color.ColorCIELab;
import org.apache.sanselan.color.ColorCIELuv;
import org.apache.sanselan.color.ColorCMY;
import org.apache.sanselan.color.ColorCMYK;
import org.apache.sanselan.color.ColorHSL;
import org.apache.sanselan.color.ColorHSV;
import org.apache.sanselan.color.ColorHunterLab;
import org.apache.sanselan.color.ColorXYZ;
import org.apache.sanselan.util.Debug;

public abstract class ColorConversions {
    private static final double ref_X = 95.047;
    private static final double ref_Y = 100.0;
    private static final double ref_Z = 108.883;

    public static final void main(String[] args) {
        try {
            for (int C = 0; C <= 256; C += 64) {
                for (int M = 0; M <= 256; M += 64) {
                    for (int Y = 0; Y <= 256; Y += 64) {
                        for (int K = 0; K <= 256; K += 64) {
                            int rgb2;
                            int rgb1 = ColorConversions.convertCMYKtoRGB(Math.min(255, C), Math.min(255, M), Math.min(255, Y), Math.min(255, K));
                            if (rgb1 == (rgb2 = ColorConversions.convertCMYKtoRGB_old(Math.min(255, C), Math.min(255, M), Math.min(255, Y), Math.min(255, K)))) continue;
                            Debug.debug();
                            Debug.debug("C", C);
                            Debug.debug("M", M);
                            Debug.debug("Y", Y);
                            Debug.debug("K", K);
                            Debug.debug("rgb1", rgb1 + " (" + Integer.toHexString(rgb1) + ")");
                            Debug.debug("rgb2", rgb2 + " (" + Integer.toHexString(rgb2) + ")");
                        }
                    }
                }
            }
            int[] sample_rgbs = new int[]{-1, -16777216, -65536, -16711936, -16776961, -65281, -983296, -16711681, 0, -8421505};
            for (int i = 0; i < sample_rgbs.length; ++i) {
                int rgb = sample_rgbs[i];
                ColorXYZ xyz = ColorConversions.convertRGBtoXYZ(rgb);
                int xyz_rgb = ColorConversions.convertXYZtoRGB(xyz);
                Debug.debug();
                Debug.debug("rgb", rgb + " (" + Integer.toHexString(rgb) + ")");
                Debug.debug("xyz", xyz);
                Debug.debug("xyz_rgb", xyz_rgb + " (" + Integer.toHexString(xyz_rgb) + ")");
                if ((0xFFFFFF & xyz_rgb) != (0xFFFFFF & rgb)) {
                    Debug.debug("!!!!!!!!!!!!!!!!!!!!!!!");
                }
                ColorCIELab cielab = ColorConversions.convertXYZtoCIELab(xyz);
                ColorXYZ cielab_xyz = ColorConversions.convertCIELabtoXYZ(cielab);
                int cielab_xyz_rgb = ColorConversions.convertXYZtoRGB(cielab_xyz);
                Debug.debug("cielab", cielab);
                Debug.debug("cielab_xyz", cielab_xyz);
                Debug.debug("cielab_xyz_rgb", cielab_xyz_rgb + " (" + Integer.toHexString(cielab_xyz_rgb) + ")");
                if ((0xFFFFFF & cielab_xyz_rgb) != (0xFFFFFF & rgb)) {
                    Debug.debug("!!!!!!!!!!!!!!!!!!!!!!!");
                }
                ColorHunterLab hunterlab = ColorConversions.convertXYZtoHunterLab(xyz);
                ColorXYZ hunterlab_xyz = ColorConversions.convertHunterLabtoXYZ(hunterlab);
                int hunterlab_xyz_rgb = ColorConversions.convertXYZtoRGB(hunterlab_xyz);
                Debug.debug("hunterlab", hunterlab);
                Debug.debug("hunterlab_xyz", hunterlab_xyz);
                Debug.debug("hunterlab_xyz_rgb", hunterlab_xyz_rgb + " (" + Integer.toHexString(hunterlab_xyz_rgb) + ")");
                if ((0xFFFFFF & hunterlab_xyz_rgb) != (0xFFFFFF & rgb)) {
                    Debug.debug("!!!!!!!!!!!!!!!!!!!!!!!");
                }
                ColorCMY cmy = ColorConversions.convertRGBtoCMY(rgb);
                ColorCMYK cmyk = ColorConversions.convertCMYtoCMYK(cmy);
                ColorCMY cmyk_cmy = ColorConversions.convertCMYKtoCMY(cmyk);
                int cmyk_cmy_rgb = ColorConversions.convertCMYtoRGB(cmyk_cmy);
                Debug.debug("cmy", cmy);
                Debug.debug("cmyk", cmyk);
                Debug.debug("cmyk_cmy", cmyk_cmy);
                Debug.debug("cmyk_cmy_rgb", cmyk_cmy_rgb + " (" + Integer.toHexString(cmyk_cmy_rgb) + ")");
                if ((0xFFFFFF & cmyk_cmy_rgb) != (0xFFFFFF & rgb)) {
                    Debug.debug("!!!!!!!!!!!!!!!!!!!!!!!");
                }
                ColorHSL hsl = ColorConversions.convertRGBtoHSL(rgb);
                int hsl_rgb = ColorConversions.convertHSLtoRGB(hsl);
                Debug.debug("hsl", hsl);
                Debug.debug("hsl_rgb", hsl_rgb + " (" + Integer.toHexString(hsl_rgb) + ")");
                if ((0xFFFFFF & hsl_rgb) != (0xFFFFFF & rgb)) {
                    Debug.debug("!!!!!!!!!!!!!!!!!!!!!!!");
                }
                ColorHSV hsv = ColorConversions.convertRGBtoHSV(rgb);
                int hsv_rgb = ColorConversions.convertHSVtoRGB(hsv);
                Debug.debug("hsv", hsv);
                Debug.debug("hsv_rgb", hsv_rgb + " (" + Integer.toHexString(hsv_rgb) + ")");
                if ((0xFFFFFF & hsv_rgb) != (0xFFFFFF & rgb)) {
                    Debug.debug("!!!!!!!!!!!!!!!!!!!!!!!");
                }
                ColorCIELCH cielch = ColorConversions.convertCIELabtoCIELCH(cielab);
                ColorCIELab cielch_cielab = ColorConversions.convertCIELCHtoCIELab(cielch);
                Debug.debug("cielch", cielch);
                Debug.debug("cielch_cielab", cielch_cielab);
                ColorCIELuv cieluv = ColorConversions.convertXYZtoCIELuv(xyz);
                ColorXYZ cieluv_xyz = ColorConversions.convertCIELuvtoXYZ(cieluv);
                Debug.debug("cieluv", cieluv);
                Debug.debug("cieluv_xyz", cieluv_xyz);
            }
        }
        catch (Throwable e2) {
            Debug.debug(e2);
        }
    }

    public static final ColorCIELab convertXYZtoCIELab(ColorXYZ xyz) {
        return ColorConversions.convertXYZtoCIELab(xyz.X, xyz.Y, xyz.Z);
    }

    public static final ColorCIELab convertXYZtoCIELab(double X, double Y, double Z) {
        double var_X = X / 95.047;
        double var_Y = Y / 100.0;
        double var_Z = Z / 108.883;
        var_X = var_X > 0.008856 ? Math.pow(var_X, 0.3333333333333333) : 7.787 * var_X + 0.13793103448275862;
        var_Y = var_Y > 0.008856 ? Math.pow(var_Y, 0.3333333333333333) : 7.787 * var_Y + 0.13793103448275862;
        var_Z = var_Z > 0.008856 ? Math.pow(var_Z, 0.3333333333333333) : 7.787 * var_Z + 0.13793103448275862;
        double L = 116.0 * var_Y - 16.0;
        double a2 = 500.0 * (var_X - var_Y);
        double b2 = 200.0 * (var_Y - var_Z);
        return new ColorCIELab(L, a2, b2);
    }

    public static final ColorXYZ convertCIELabtoXYZ(ColorCIELab cielab) {
        return ColorConversions.convertCIELabtoXYZ(cielab.L, cielab.a, cielab.b);
    }

    public static final ColorXYZ convertCIELabtoXYZ(double L, double a2, double b2) {
        double var_Y = (L + 16.0) / 116.0;
        double var_X = a2 / 500.0 + var_Y;
        double var_Z = var_Y - b2 / 200.0;
        var_Y = Math.pow(var_Y, 3.0) > 0.008856 ? Math.pow(var_Y, 3.0) : (var_Y - 0.13793103448275862) / 7.787;
        var_X = Math.pow(var_X, 3.0) > 0.008856 ? Math.pow(var_X, 3.0) : (var_X - 0.13793103448275862) / 7.787;
        var_Z = Math.pow(var_Z, 3.0) > 0.008856 ? Math.pow(var_Z, 3.0) : (var_Z - 0.13793103448275862) / 7.787;
        double X = 95.047 * var_X;
        double Y = 100.0 * var_Y;
        double Z = 108.883 * var_Z;
        return new ColorXYZ(X, Y, Z);
    }

    public static final ColorHunterLab convertXYZtoHunterLab(ColorXYZ xyz) {
        return ColorConversions.convertXYZtoHunterLab(xyz.X, xyz.Y, xyz.Z);
    }

    public static final ColorHunterLab convertXYZtoHunterLab(double X, double Y, double Z) {
        double L = 10.0 * Math.sqrt(Y);
        double a2 = 17.5 * ((1.02 * X - Y) / Math.sqrt(Y));
        double b2 = 7.0 * ((Y - 0.847 * Z) / Math.sqrt(Y));
        return new ColorHunterLab(L, a2, b2);
    }

    public static final ColorXYZ convertHunterLabtoXYZ(ColorHunterLab cielab) {
        return ColorConversions.convertHunterLabtoXYZ(cielab.L, cielab.a, cielab.b);
    }

    public static final ColorXYZ convertHunterLabtoXYZ(double L, double a2, double b2) {
        double var_Y = L / 10.0;
        double var_X = a2 / 17.5 * L / 10.0;
        double var_Z = b2 / 7.0 * L / 10.0;
        double Y = Math.pow(var_Y, 2.0);
        double X = (var_X + Y) / 1.02;
        double Z = -(var_Z - Y) / 0.847;
        return new ColorXYZ(X, Y, Z);
    }

    public static final int convertXYZtoRGB(ColorXYZ xyz) {
        return ColorConversions.convertXYZtoRGB(xyz.X, xyz.Y, xyz.Z);
    }

    public static final int convertXYZtoRGB(double X, double Y, double Z) {
        double var_X = X / 100.0;
        double var_Y = Y / 100.0;
        double var_Z = Z / 100.0;
        double var_R = var_X * 3.2406 + var_Y * -1.5372 + var_Z * -0.4986;
        double var_G = var_X * -0.9689 + var_Y * 1.8758 + var_Z * 0.0415;
        double var_B = var_X * 0.0557 + var_Y * -0.204 + var_Z * 1.057;
        var_R = var_R > 0.0031308 ? 1.055 * Math.pow(var_R, 0.4166666666666667) - 0.055 : 12.92 * var_R;
        var_G = var_G > 0.0031308 ? 1.055 * Math.pow(var_G, 0.4166666666666667) - 0.055 : 12.92 * var_G;
        var_B = var_B > 0.0031308 ? 1.055 * Math.pow(var_B, 0.4166666666666667) - 0.055 : 12.92 * var_B;
        double R = var_R * 255.0;
        double G = var_G * 255.0;
        double B = var_B * 255.0;
        return ColorConversions.convertRGBtoRGB(R, G, B);
    }

    public static final ColorXYZ convertRGBtoXYZ(int rgb) {
        int r = 0xFF & rgb >> 16;
        int g2 = 0xFF & rgb >> 8;
        int b2 = 0xFF & rgb >> 0;
        double var_R = (double)r / 255.0;
        double var_G = (double)g2 / 255.0;
        double var_B = (double)b2 / 255.0;
        var_R = var_R > 0.04045 ? Math.pow((var_R + 0.055) / 1.055, 2.4) : (var_R /= 12.92);
        var_G = var_G > 0.04045 ? Math.pow((var_G + 0.055) / 1.055, 2.4) : (var_G /= 12.92);
        var_B = var_B > 0.04045 ? Math.pow((var_B + 0.055) / 1.055, 2.4) : (var_B /= 12.92);
        double X = (var_R *= 100.0) * 0.4124 + (var_G *= 100.0) * 0.3576 + (var_B *= 100.0) * 0.1805;
        double Y = var_R * 0.2126 + var_G * 0.7152 + var_B * 0.0722;
        double Z = var_R * 0.0193 + var_G * 0.1192 + var_B * 0.9505;
        return new ColorXYZ(X, Y, Z);
    }

    public static final ColorCMY convertRGBtoCMY(int rgb) {
        int R = 0xFF & rgb >> 16;
        int G = 0xFF & rgb >> 8;
        int B = 0xFF & rgb >> 0;
        double C = 1.0 - (double)R / 255.0;
        double M = 1.0 - (double)G / 255.0;
        double Y = 1.0 - (double)B / 255.0;
        return new ColorCMY(C, M, Y);
    }

    public static final int convertCMYtoRGB(ColorCMY cmy) {
        double R = (1.0 - cmy.C) * 255.0;
        double G = (1.0 - cmy.M) * 255.0;
        double B = (1.0 - cmy.Y) * 255.0;
        return ColorConversions.convertRGBtoRGB(R, G, B);
    }

    public static final ColorCMYK convertCMYtoCMYK(ColorCMY cmy) {
        double C = cmy.C;
        double M = cmy.M;
        double Y = cmy.Y;
        double var_K = 1.0;
        if (C < var_K) {
            var_K = C;
        }
        if (M < var_K) {
            var_K = M;
        }
        if (Y < var_K) {
            var_K = Y;
        }
        if (var_K == 1.0) {
            C = 0.0;
            M = 0.0;
            Y = 0.0;
        } else {
            C = (C - var_K) / (1.0 - var_K);
            M = (M - var_K) / (1.0 - var_K);
            Y = (Y - var_K) / (1.0 - var_K);
        }
        return new ColorCMYK(C, M, Y, var_K);
    }

    public static final ColorCMY convertCMYKtoCMY(ColorCMYK cmyk) {
        return ColorConversions.convertCMYKtoCMY(cmyk.C, cmyk.M, cmyk.Y, cmyk.K);
    }

    public static final ColorCMY convertCMYKtoCMY(double C, double M, double Y, double K) {
        C = C * (1.0 - K) + K;
        M = M * (1.0 - K) + K;
        Y = Y * (1.0 - K) + K;
        return new ColorCMY(C, M, Y);
    }

    public static final int convertCMYKtoRGB(int c2, int m, int y, int k) {
        double C = (double)c2 / 255.0;
        double M = (double)m / 255.0;
        double Y = (double)y / 255.0;
        double K = (double)k / 255.0;
        return ColorConversions.convertCMYtoRGB(ColorConversions.convertCMYKtoCMY(C, M, Y, K));
    }

    public static final ColorHSL convertRGBtoHSL(int rgb) {
        double S;
        double H;
        int R = 0xFF & rgb >> 16;
        int G = 0xFF & rgb >> 8;
        int B = 0xFF & rgb >> 0;
        double var_R = (double)R / 255.0;
        double var_G = (double)G / 255.0;
        double var_B = (double)B / 255.0;
        double var_Min = Math.min(var_R, Math.min(var_G, var_B));
        double var_Max = Math.max(var_R, Math.max(var_G, var_B));
        double del_Max = var_Max - var_Min;
        double L = (var_Max + var_Min) / 2.0;
        if (del_Max == 0.0) {
            H = 0.0;
            S = 0.0;
        } else {
            S = L < 0.5 ? del_Max / (var_Max + var_Min) : del_Max / (2.0 - var_Max - var_Min);
            double del_R = ((var_Max - var_R) / 6.0 + del_Max / 2.0) / del_Max;
            double del_G = ((var_Max - var_G) / 6.0 + del_Max / 2.0) / del_Max;
            double del_B = ((var_Max - var_B) / 6.0 + del_Max / 2.0) / del_Max;
            if (var_R == var_Max) {
                H = del_B - del_G;
            } else if (var_G == var_Max) {
                H = 0.3333333333333333 + del_R - del_B;
            } else if (var_B == var_Max) {
                H = 0.6666666666666666 + del_G - del_R;
            } else {
                Debug.debug("uh oh");
                H = 0.0;
            }
            if (H < 0.0) {
                H += 1.0;
            }
            if (H > 1.0) {
                H -= 1.0;
            }
        }
        return new ColorHSL(H, S, L);
    }

    public static int convertHSLtoRGB(ColorHSL hsl) {
        return ColorConversions.convertHSLtoRGB(hsl.H, hsl.S, hsl.L);
    }

    public static int convertHSLtoRGB(double H, double S, double L) {
        double B;
        double G;
        double R;
        if (S == 0.0) {
            R = L * 255.0;
            G = L * 255.0;
            B = L * 255.0;
        } else {
            double var_2 = L < 0.5 ? L * (1.0 + S) : L + S - S * L;
            double var_1 = 2.0 * L - var_2;
            R = 255.0 * ColorConversions.convertHuetoRGB(var_1, var_2, H + 0.3333333333333333);
            G = 255.0 * ColorConversions.convertHuetoRGB(var_1, var_2, H);
            B = 255.0 * ColorConversions.convertHuetoRGB(var_1, var_2, H - 0.3333333333333333);
        }
        return ColorConversions.convertRGBtoRGB(R, G, B);
    }

    private static double convertHuetoRGB(double v1, double v2, double vH) {
        if (vH < 0.0) {
            vH += 1.0;
        }
        if (vH > 1.0) {
            vH -= 1.0;
        }
        if (6.0 * vH < 1.0) {
            return v1 + (v2 - v1) * 6.0 * vH;
        }
        if (2.0 * vH < 1.0) {
            return v2;
        }
        if (3.0 * vH < 2.0) {
            return v1 + (v2 - v1) * (0.6666666666666666 - vH) * 6.0;
        }
        return v1;
    }

    public static final ColorHSV convertRGBtoHSV(int rgb) {
        double S;
        double H;
        int R = 0xFF & rgb >> 16;
        int G = 0xFF & rgb >> 8;
        int B = 0xFF & rgb >> 0;
        double var_R = (double)R / 255.0;
        double var_G = (double)G / 255.0;
        double var_B = (double)B / 255.0;
        double var_Min = Math.min(var_R, Math.min(var_G, var_B));
        double var_Max = Math.max(var_R, Math.max(var_G, var_B));
        double del_Max = var_Max - var_Min;
        double V = var_Max;
        if (del_Max == 0.0) {
            H = 0.0;
            S = 0.0;
        } else {
            S = del_Max / var_Max;
            double del_R = ((var_Max - var_R) / 6.0 + del_Max / 2.0) / del_Max;
            double del_G = ((var_Max - var_G) / 6.0 + del_Max / 2.0) / del_Max;
            double del_B = ((var_Max - var_B) / 6.0 + del_Max / 2.0) / del_Max;
            if (var_R == var_Max) {
                H = del_B - del_G;
            } else if (var_G == var_Max) {
                H = 0.3333333333333333 + del_R - del_B;
            } else if (var_B == var_Max) {
                H = 0.6666666666666666 + del_G - del_R;
            } else {
                Debug.debug("uh oh");
                H = 0.0;
            }
            if (H < 0.0) {
                H += 1.0;
            }
            if (H > 1.0) {
                H -= 1.0;
            }
        }
        return new ColorHSV(H, S, V);
    }

    public static int convertHSVtoRGB(ColorHSV HSV) {
        return ColorConversions.convertHSVtoRGB(HSV.H, HSV.S, HSV.V);
    }

    public static int convertHSVtoRGB(double H, double S, double V) {
        double B;
        double G;
        double R;
        if (S == 0.0) {
            R = V * 255.0;
            G = V * 255.0;
            B = V * 255.0;
        } else {
            double var_b;
            double var_g;
            double var_r;
            double var_h = H * 6.0;
            if (var_h == 6.0) {
                var_h = 0.0;
            }
            double var_i = Math.floor(var_h);
            double var_1 = V * (1.0 - S);
            double var_2 = V * (1.0 - S * (var_h - var_i));
            double var_3 = V * (1.0 - S * (1.0 - (var_h - var_i)));
            if (var_i == 0.0) {
                var_r = V;
                var_g = var_3;
                var_b = var_1;
            } else if (var_i == 1.0) {
                var_r = var_2;
                var_g = V;
                var_b = var_1;
            } else if (var_i == 2.0) {
                var_r = var_1;
                var_g = V;
                var_b = var_3;
            } else if (var_i == 3.0) {
                var_r = var_1;
                var_g = var_2;
                var_b = V;
            } else if (var_i == 4.0) {
                var_r = var_3;
                var_g = var_1;
                var_b = V;
            } else {
                var_r = V;
                var_g = var_1;
                var_b = var_2;
            }
            R = var_r * 255.0;
            G = var_g * 255.0;
            B = var_b * 255.0;
        }
        return ColorConversions.convertRGBtoRGB(R, G, B);
    }

    public static final int convertCMYKtoRGB_old(int sc, int sm, int sy, int sk) {
        int red = 255 - (sc + sk);
        int green = 255 - (sm + sk);
        int blue = 255 - (sy + sk);
        return ColorConversions.convertRGBtoRGB(red, green, blue);
    }

    private static double cube(double f2) {
        return f2 * f2 * f2;
    }

    private static double square(double f2) {
        return f2 * f2;
    }

    public static final int convertCIELabtoARGBTest(int cieL, int cieA, int cieB) {
        double var_Y = ((double)cieL * 100.0 / 255.0 + 16.0) / 116.0;
        double var_X = (double)cieA / 500.0 + var_Y;
        double var_Z = var_Y - (double)cieB / 200.0;
        double var_x_cube = ColorConversions.cube(var_X);
        double var_y_cube = ColorConversions.cube(var_Y);
        double var_z_cube = ColorConversions.cube(var_Z);
        var_Y = var_y_cube > 0.008856 ? var_y_cube : (var_Y - 0.13793103448275862) / 7.787;
        var_X = var_x_cube > 0.008856 ? var_x_cube : (var_X - 0.13793103448275862) / 7.787;
        var_Z = var_z_cube > 0.008856 ? var_z_cube : (var_Z - 0.13793103448275862) / 7.787;
        double X = 95.047 * var_X;
        double Y = 100.0 * var_Y;
        double Z = 108.883 * var_Z;
        double var_X2 = X / 100.0;
        double var_Y2 = Y / 100.0;
        double var_Z2 = Z / 100.0;
        double var_R = var_X2 * 3.2406 + var_Y2 * -1.5372 + var_Z2 * -0.4986;
        double var_G = var_X2 * -0.9689 + var_Y2 * 1.8758 + var_Z2 * 0.0415;
        double var_B = var_X2 * 0.0557 + var_Y2 * -0.204 + var_Z2 * 1.057;
        var_R = var_R > 0.0031308 ? 1.055 * Math.pow(var_R, 0.4166666666666667) - 0.055 : 12.92 * var_R;
        var_G = var_G > 0.0031308 ? 1.055 * Math.pow(var_G, 0.4166666666666667) - 0.055 : 12.92 * var_G;
        var_B = var_B > 0.0031308 ? 1.055 * Math.pow(var_B, 0.4166666666666667) - 0.055 : 12.92 * var_B;
        double R = var_R * 255.0;
        double G = var_G * 255.0;
        double B = var_B * 255.0;
        return ColorConversions.convertRGBtoRGB(R, G, B);
    }

    private static final int convertRGBtoRGB(double R, double G, double B) {
        int red = (int)Math.round(R);
        int green = (int)Math.round(G);
        int blue = (int)Math.round(B);
        red = Math.min(255, Math.max(0, red));
        green = Math.min(255, Math.max(0, green));
        blue = Math.min(255, Math.max(0, blue));
        int alpha = 255;
        int rgb = alpha << 24 | red << 16 | green << 8 | blue << 0;
        return rgb;
    }

    private static final int convertRGBtoRGB(int red, int green, int blue) {
        red = Math.min(255, Math.max(0, red));
        green = Math.min(255, Math.max(0, green));
        blue = Math.min(255, Math.max(0, blue));
        int alpha = 255;
        int rgb = alpha << 24 | red << 16 | green << 8 | blue << 0;
        return rgb;
    }

    public static ColorCIELCH convertCIELabtoCIELCH(ColorCIELab cielab) {
        return ColorConversions.convertCIELabtoCIELCH(cielab.L, cielab.a, cielab.b);
    }

    public static ColorCIELCH convertCIELabtoCIELCH(double L, double a2, double b2) {
        double var_H = Math.atan2(b2, a2);
        var_H = var_H > 0.0 ? var_H / Math.PI * 180.0 : 360.0 - ColorConversions.radian_2_degree(Math.abs(var_H));
        double C = Math.sqrt(ColorConversions.square(a2) + ColorConversions.square(b2));
        double H = var_H;
        return new ColorCIELCH(L, C, H);
    }

    public static ColorCIELab convertCIELCHtoCIELab(ColorCIELCH cielch) {
        return ColorConversions.convertCIELCHtoCIELab(cielch.L, cielch.C, cielch.H);
    }

    public static ColorCIELab convertCIELCHtoCIELab(double L, double C, double H) {
        double a2 = Math.cos(ColorConversions.degree_2_radian(H)) * C;
        double b2 = Math.sin(ColorConversions.degree_2_radian(H)) * C;
        return new ColorCIELab(L, a2, b2);
    }

    public static double degree_2_radian(double degree) {
        return degree * Math.PI / 180.0;
    }

    public static double radian_2_degree(double radian) {
        return radian * 180.0 / Math.PI;
    }

    public static ColorCIELuv convertXYZtoCIELuv(ColorXYZ xyz) {
        return ColorConversions.convertXYZtoCIELuv(xyz.X, xyz.Y, xyz.Z);
    }

    public static ColorCIELuv convertXYZtoCIELuv(double X, double Y, double Z) {
        double var_U = 4.0 * X / (X + 15.0 * Y + 3.0 * Z);
        double var_V = 9.0 * Y / (X + 15.0 * Y + 3.0 * Z);
        double var_Y = Y / 100.0;
        var_Y = var_Y > 0.008856 ? Math.pow(var_Y, 0.3333333333333333) : 7.787 * var_Y + 0.13793103448275862;
        double ref_X = 95.047;
        double ref_Y = 100.0;
        double ref_Z = 108.883;
        double ref_U = 4.0 * ref_X / (ref_X + 15.0 * ref_Y + 3.0 * ref_Z);
        double ref_V = 9.0 * ref_Y / (ref_X + 15.0 * ref_Y + 3.0 * ref_Z);
        double L = 116.0 * var_Y - 16.0;
        double u = 13.0 * L * (var_U - ref_U);
        double v = 13.0 * L * (var_V - ref_V);
        return new ColorCIELuv(L, u, v);
    }

    public static ColorXYZ convertCIELuvtoXYZ(ColorCIELuv cielch) {
        return ColorConversions.convertCIELuvtoXYZ(cielch.L, cielch.u, cielch.v);
    }

    public static ColorXYZ convertCIELuvtoXYZ(double L, double u, double v) {
        double var_Y = (L + 16.0) / 116.0;
        var_Y = Math.pow(var_Y, 3.0) > 0.008856 ? Math.pow(var_Y, 3.0) : (var_Y - 0.0) / 7.787;
        double ref_X = 95.047;
        double ref_Y = 100.0;
        double ref_Z = 108.883;
        double ref_U = 4.0 * ref_X / (ref_X + 15.0 * ref_Y + 3.0 * ref_Z);
        double ref_V = 9.0 * ref_Y / (ref_X + 15.0 * ref_Y + 3.0 * ref_Z);
        double var_U = u / (13.0 * L) + ref_U;
        double var_V = v / (13.0 * L) + ref_V;
        double Y = var_Y * 100.0;
        double X = -(9.0 * Y * var_U) / ((var_U - 4.0) * var_V - var_U * var_V);
        double Z = (9.0 * Y - 15.0 * var_V * Y - var_V * X) / (3.0 * var_V);
        return new ColorXYZ(X, Y, Z);
    }
}

