/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.common;

import java.io.IOException;
import java.io.InputStream;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.common.BinaryFileFunctions;

public class BinaryFileParser
extends BinaryFileFunctions {
    private int byteOrder = 77;

    public BinaryFileParser(int byteOrder) {
        this.byteOrder = byteOrder;
    }

    public BinaryFileParser() {
    }

    protected void setByteOrder(int a2, int b2) throws ImageReadException, IOException {
        if (a2 != b2) {
            throw new ImageReadException("Byte Order bytes don't match (" + a2 + ", " + b2 + ").");
        }
        if (a2 == 77) {
            this.byteOrder = a2;
        } else if (a2 == 73) {
            this.byteOrder = a2;
        } else {
            throw new ImageReadException("Unknown Byte Order hint: " + a2);
        }
    }

    protected void setByteOrder(int byteOrder) {
        this.byteOrder = byteOrder;
    }

    protected int getByteOrder() {
        return this.byteOrder;
    }

    protected final int convertByteArrayToInt(String name, int start, byte[] bytes) {
        return this.convertByteArrayToInt(name, bytes, start, this.byteOrder);
    }

    protected final int convertByteArrayToInt(String name, byte[] bytes) {
        return this.convertByteArrayToInt(name, bytes, this.byteOrder);
    }

    public final int convertByteArrayToShort(String name, byte[] bytes) throws ImageReadException {
        return this.convertByteArrayToShort(name, bytes, this.byteOrder);
    }

    public final int convertByteArrayToShort(String name, int start, byte[] bytes) throws ImageReadException {
        return this.convertByteArrayToShort(name, start, bytes, this.byteOrder);
    }

    public final int read4Bytes(String name, InputStream is, String exception) throws ImageReadException, IOException {
        return this.read4Bytes(name, is, exception, this.byteOrder);
    }

    public final int read3Bytes(String name, InputStream is, String exception) throws ImageReadException, IOException {
        return this.read3Bytes(name, is, exception, this.byteOrder);
    }

    public final int read2Bytes(String name, InputStream is, String exception) throws ImageReadException, IOException {
        return this.read2Bytes(name, is, exception, this.byteOrder);
    }

    public static boolean byteArrayHasPrefix(byte[] bytes, byte[] prefix) {
        if (bytes == null || bytes.length < prefix.length) {
            return false;
        }
        for (int i = 0; i < prefix.length; ++i) {
            if (bytes[i] == prefix[i]) continue;
            return false;
        }
        return true;
    }

    protected final byte[] int2ToByteArray(int value) {
        return BinaryFileParser.int2ToByteArray(value, this.byteOrder);
    }
}

