/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.common;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.common.BinaryConstants;

public class BinaryOutputStream
extends OutputStream
implements BinaryConstants {
    protected boolean debug = false;
    private int count = 0;
    private final OutputStream os;
    private int byteOrder = 77;

    public final void setDebug(boolean b2) {
        this.debug = b2;
    }

    public final boolean getDebug() {
        return this.debug;
    }

    public BinaryOutputStream(OutputStream os, int byteOrder) {
        this.byteOrder = byteOrder;
        this.os = os;
    }

    public BinaryOutputStream(OutputStream os) {
        this.os = os;
    }

    protected void setByteOrder(int a2, int b2) throws ImageWriteException, IOException {
        if (a2 != b2) {
            throw new ImageWriteException("Byte Order bytes don't match (" + a2 + ", " + b2 + ").");
        }
        if (a2 == 77) {
            this.byteOrder = a2;
        } else if (a2 == 73) {
            this.byteOrder = a2;
        } else {
            throw new ImageWriteException("Unknown Byte Order hint: " + a2);
        }
    }

    protected void setByteOrder(int byteOrder) {
        this.byteOrder = byteOrder;
    }

    public int getByteOrder() {
        return this.byteOrder;
    }

    public void write(int i) throws IOException {
        this.os.write(i);
        ++this.count;
    }

    public int getByteCount() {
        return this.count;
    }

    public final void write4Bytes(int value) throws ImageWriteException, IOException {
        this.writeNBytes(value, 4);
    }

    public final void write3Bytes(int value) throws ImageWriteException, IOException {
        this.writeNBytes(value, 3);
    }

    public final void write2Bytes(int value) throws ImageWriteException, IOException {
        this.writeNBytes(value, 2);
    }

    public final void write4ByteInteger(int value) throws ImageWriteException, IOException {
        if (this.byteOrder == 77) {
            this.write(0xFF & value >> 24);
            this.write(0xFF & value >> 16);
            this.write(0xFF & value >> 8);
            this.write(0xFF & value);
        } else {
            this.write(0xFF & value);
            this.write(0xFF & value >> 8);
            this.write(0xFF & value >> 16);
            this.write(0xFF & value >> 24);
        }
    }

    public final void write2ByteInteger(int value) throws ImageWriteException, IOException {
        if (this.byteOrder == 77) {
            this.write(0xFF & value >> 8);
            this.write(0xFF & value);
        } else {
            this.write(0xFF & value);
            this.write(0xFF & value >> 8);
        }
    }

    public final void writeByteArray(byte[] bytes) throws IOException {
        this.os.write(bytes, 0, bytes.length);
        this.count += bytes.length;
    }

    private byte[] convertValueToByteArray(int value, int n) {
        byte[] result = new byte[n];
        if (this.byteOrder == 77) {
            for (int i = 0; i < n; ++i) {
                int b2 = 0xFF & value >> 8 * (n - i - 1);
                result[i] = (byte)b2;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                int b3 = 0xFF & value >> 8 * i;
                result[i] = (byte)b3;
            }
        }
        return result;
    }

    private final void writeNBytes(int value, int n) throws ImageWriteException, IOException {
        this.write(this.convertValueToByteArray(value, n));
    }
}

