/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.common.byteSources;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.sanselan.common.byteSources.ByteSource;

public class ByteSourceInputStream
extends ByteSource {
    private final InputStream is;
    private CacheBlock cacheHead = null;
    private static final int BLOCK_SIZE = 1024;
    private byte[] readBuffer = null;
    private Long length = null;

    public ByteSourceInputStream(InputStream is, String filename) {
        super(filename);
        this.is = new BufferedInputStream(is);
    }

    private CacheBlock readBlock() throws IOException {
        int read;
        if (null == this.readBuffer) {
            this.readBuffer = new byte[1024];
        }
        if ((read = this.is.read(this.readBuffer)) < 1) {
            return null;
        }
        if (read < 1024) {
            byte[] result = new byte[read];
            System.arraycopy(this.readBuffer, 0, result, 0, read);
            return new CacheBlock(result);
        }
        byte[] result = this.readBuffer;
        this.readBuffer = null;
        return new CacheBlock(result);
    }

    private CacheBlock getFirstBlock() throws IOException {
        if (null == this.cacheHead) {
            this.cacheHead = this.readBlock();
        }
        return this.cacheHead;
    }

    public InputStream getInputStream() throws IOException {
        return new CacheReadingInputStream();
    }

    public byte[] getBlock(int start, int length) throws IOException {
        int read;
        InputStream is = this.getInputStream();
        is.skip(start);
        byte[] bytes = new byte[length];
        int total = 0;
        do {
            if ((read = is.read(bytes, total, bytes.length - total)) >= 1) continue;
            throw new IOException("Could not read block.");
        } while ((total += read) < length);
        return bytes;
    }

    public long getLength() throws IOException {
        long skipped;
        if (this.length != null) {
            return this.length;
        }
        InputStream is = this.getInputStream();
        long result = 0L;
        while ((skipped = is.skip(1024L)) > 0L) {
            result += skipped;
        }
        this.length = new Long(result);
        return result;
    }

    public byte[] getAll() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (CacheBlock block = this.getFirstBlock(); block != null; block = block.getNext()) {
            baos.write(block.bytes);
        }
        return baos.toByteArray();
    }

    public String getDescription() {
        return "Inputstream: '" + this.filename + "'";
    }

    private class CacheReadingInputStream
    extends InputStream {
        private CacheBlock block = null;
        private boolean readFirst = false;
        private int blockIndex = 0;

        private CacheReadingInputStream() {
        }

        public int read() throws IOException {
            if (null == this.block) {
                if (this.readFirst) {
                    return -1;
                }
                this.block = ByteSourceInputStream.this.getFirstBlock();
                this.readFirst = true;
            }
            if (this.block != null && this.blockIndex >= this.block.bytes.length) {
                this.block = this.block.getNext();
                this.blockIndex = 0;
            }
            if (null == this.block) {
                return -1;
            }
            if (this.blockIndex >= this.block.bytes.length) {
                return -1;
            }
            return 0xFF & this.block.bytes[this.blockIndex++];
        }

        public int read(byte[] b2, int off, int len) throws IOException {
            if (b2 == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b2.length || len < 0 || off + len > b2.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            if (null == this.block) {
                if (this.readFirst) {
                    return -1;
                }
                this.block = ByteSourceInputStream.this.getFirstBlock();
                this.readFirst = true;
            }
            if (this.block != null && this.blockIndex >= this.block.bytes.length) {
                this.block = this.block.getNext();
                this.blockIndex = 0;
            }
            if (null == this.block) {
                return -1;
            }
            if (this.blockIndex >= this.block.bytes.length) {
                return -1;
            }
            int readSize = Math.min(len, this.block.bytes.length - this.blockIndex);
            System.arraycopy(this.block.bytes, this.blockIndex, b2, off, readSize);
            this.blockIndex += readSize;
            return readSize;
        }
    }

    private class CacheBlock {
        public final byte[] bytes;
        private CacheBlock next = null;
        private boolean triedNext = false;

        public CacheBlock(byte[] bytes) {
            this.bytes = bytes;
        }

        public CacheBlock getNext() throws IOException {
            if (null != this.next) {
                return this.next;
            }
            if (this.triedNext) {
                return null;
            }
            this.triedNext = true;
            this.next = ByteSourceInputStream.this.readBlock();
            return this.next;
        }
    }
}

