/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.gif;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.sanselan.FormatCompliance;
import org.apache.sanselan.ImageFormat;
import org.apache.sanselan.ImageInfo;
import org.apache.sanselan.ImageParser;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.common.BinaryOutputStream;
import org.apache.sanselan.common.IImageMetadata;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.common.mylzw.MyLZWCompressor;
import org.apache.sanselan.common.mylzw.MyLZWDecompressor;
import org.apache.sanselan.formats.gif.GIFBlock;
import org.apache.sanselan.formats.gif.GIFHeaderInfo;
import org.apache.sanselan.formats.gif.GenericGIFBlock;
import org.apache.sanselan.formats.gif.GraphicControlExtension;
import org.apache.sanselan.formats.gif.ImageContents;
import org.apache.sanselan.formats.gif.ImageDescriptor;
import org.apache.sanselan.palette.Palette;
import org.apache.sanselan.palette.PaletteFactory;
import org.apache.sanselan.util.Debug;
import org.apache.sanselan.util.ParamMap;

public class GifImageParser
extends ImageParser {
    private static final String DEFAULT_EXTENSION = ".gif";
    private static final String[] ACCEPTED_EXTENSIONS = new String[]{".gif"};
    private static final byte[] GIF_HEADER_SIGNATURE = new byte[]{71, 73, 70};
    private static final int EXTENSION_CODE = 33;
    private static final int IMAGE_SEPARATOR = 44;
    private static final int GRAPHIC_CONTROL_EXTENSION = 8697;
    private static final int COMMENT_EXTENSION = 254;
    private static final int PLAIN_TEXT_EXTENSION = 1;
    private static final int XMP_EXTENSION = 255;
    private static final int TERMINATOR_BYTE = 59;
    private static final int APPLICATION_EXTENSION_LABEL = 255;
    private static final int XMP_COMPLETE_CODE = 8703;
    private static final int LOCAL_COLOR_TABLE_FLAG_MASK = 128;
    private static final int INTERLACE_FLAG_MASK = 64;
    private static final int SORT_FLAG_MASK = 32;
    private static final byte[] XMP_APPLICATION_ID_AND_AUTH_CODE = new byte[]{88, 77, 80, 32, 68, 97, 116, 97, 88, 77, 80};

    public GifImageParser() {
        super.setByteOrder(73);
    }

    public String getName() {
        return "Gif-Custom";
    }

    public String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    protected String[] getAcceptedExtensions() {
        return ACCEPTED_EXTENSIONS;
    }

    protected ImageFormat[] getAcceptedTypes() {
        return new ImageFormat[]{ImageFormat.IMAGE_FORMAT_GIF};
    }

    private GIFHeaderInfo readHeader(InputStream is, FormatCompliance formatCompliance) throws ImageReadException, IOException {
        boolean sortFlag;
        boolean globalColorTableFlag;
        byte identifier1 = this.readByte("identifier1", is, "Not a Valid GIF File");
        byte identifier2 = this.readByte("identifier2", is, "Not a Valid GIF File");
        byte identifier3 = this.readByte("identifier3", is, "Not a Valid GIF File");
        byte version1 = this.readByte("version1", is, "Not a Valid GIF File");
        byte version2 = this.readByte("version2", is, "Not a Valid GIF File");
        byte version3 = this.readByte("version3", is, "Not a Valid GIF File");
        if (formatCompliance != null) {
            formatCompliance.compare_bytes("Signature", GIF_HEADER_SIGNATURE, new byte[]{identifier1, identifier2, identifier3});
            formatCompliance.compare("version", 56, (int)version1);
            formatCompliance.compare("version", new int[]{55, 57}, (int)version2);
            formatCompliance.compare("version", 97, (int)version3);
        }
        if (this.debug) {
            this.printCharQuad("identifier: ", identifier1 << 16 | identifier2 << 8 | identifier3 << 0);
        }
        if (this.debug) {
            this.printCharQuad("version: ", version1 << 16 | version2 << 8 | version3 << 0);
        }
        int logicalScreenWidth = this.read2Bytes("Logical Screen Width", is, "Not a Valid GIF File");
        int logicalScreenHeight = this.read2Bytes("Logical Screen Height", is, "Not a Valid GIF File");
        if (formatCompliance != null) {
            formatCompliance.checkBounds("Width", 1, Integer.MAX_VALUE, logicalScreenWidth);
            formatCompliance.checkBounds("Height", 1, Integer.MAX_VALUE, logicalScreenHeight);
        }
        byte packedFields = this.readByte("Packed Fields", is, "Not a Valid GIF File");
        byte backgroundColorIndex = this.readByte("Background Color Index", is, "Not a Valid GIF File");
        byte pixelAspectRatio = this.readByte("Pixel Aspect Ratio", is, "Not a Valid GIF File");
        if (this.debug) {
            this.printByteBits("PackedFields bits", packedFields);
        }
        boolean bl = globalColorTableFlag = (packedFields & 0x80) > 0;
        if (this.debug) {
            System.out.println("GlobalColorTableFlag: " + globalColorTableFlag);
        }
        byte colorResolution = (byte)(packedFields >> 4 & 7);
        if (this.debug) {
            System.out.println("ColorResolution: " + colorResolution);
        }
        boolean bl2 = sortFlag = (packedFields & 8) > 0;
        if (this.debug) {
            System.out.println("SortFlag: " + sortFlag);
        }
        byte sizeofGlobalColorTable = (byte)(packedFields & 7);
        if (this.debug) {
            System.out.println("SizeofGlobalColorTable: " + sizeofGlobalColorTable);
        }
        if (formatCompliance != null && globalColorTableFlag && backgroundColorIndex != -1) {
            formatCompliance.checkBounds("Background Color Index", 0, this.convertColorTableSize(sizeofGlobalColorTable), backgroundColorIndex);
        }
        return new GIFHeaderInfo(identifier1, identifier2, identifier3, version1, version2, version3, logicalScreenWidth, logicalScreenHeight, packedFields, backgroundColorIndex, pixelAspectRatio, globalColorTableFlag, colorResolution, sortFlag, sizeofGlobalColorTable);
    }

    private GraphicControlExtension readGraphicControlExtension(int code, InputStream is) throws ImageReadException, IOException {
        this.readByte("block_size", is, "GIF: corrupt GraphicControlExt");
        byte packed = this.readByte("packed fields", is, "GIF: corrupt GraphicControlExt");
        int dispose = (packed & 0x1C) >> 2;
        boolean transparency = (packed & 1) != 0;
        int delay = this.read2Bytes("delay in milliseconds", is, "GIF: corrupt GraphicControlExt");
        int transparentColorIndex = 0xFF & this.readByte("transparent color index", is, "GIF: corrupt GraphicControlExt");
        this.readByte("block terminator", is, "GIF: corrupt GraphicControlExt");
        return new GraphicControlExtension(code, packed, dispose, transparency, delay, transparentColorIndex);
    }

    private byte[] readSubBlock(InputStream is) throws ImageReadException, IOException {
        int block_size = 0xFF & this.readByte("block_size", is, "GIF: corrupt block");
        byte[] bytes = this.readByteArray("block", block_size, is, "GIF: corrupt block");
        return bytes;
    }

    protected GenericGIFBlock readGenericGIFBlock(InputStream is, int code) throws ImageReadException, IOException {
        return this.readGenericGIFBlock(is, code, null);
    }

    protected GenericGIFBlock readGenericGIFBlock(InputStream is, int code, byte[] first) throws ImageReadException, IOException {
        byte[] bytes;
        ArrayList<byte[]> subblocks = new ArrayList<byte[]>();
        if (first != null) {
            subblocks.add(first);
        }
        while ((bytes = this.readSubBlock(is)).length >= 1) {
            subblocks.add(bytes);
        }
        return new GenericGIFBlock(code, subblocks);
    }

    private ArrayList readBlocks(GIFHeaderInfo ghi, InputStream is, boolean stopBeforeImageData, FormatCompliance formatCompliance) throws ImageReadException, IOException {
        ArrayList<GIFBlock> result = new ArrayList<GIFBlock>();
        block12: while (true) {
            int code = is.read();
            switch (code) {
                case -1: {
                    throw new ImageReadException("GIF: unexpected end of data");
                }
                case 44: {
                    ImageDescriptor id = this.readImageDescriptor(ghi, code, is, stopBeforeImageData, formatCompliance);
                    result.add(id);
                    break;
                }
                case 33: {
                    int extensionCode = is.read();
                    int completeCode = (0xFF & code) << 8 | 0xFF & extensionCode;
                    switch (extensionCode) {
                        case 249: {
                            GraphicControlExtension gce = this.readGraphicControlExtension(completeCode, is);
                            result.add(gce);
                            break;
                        }
                        case 1: 
                        case 254: {
                            GenericGIFBlock block = this.readGenericGIFBlock(is, completeCode);
                            result.add(block);
                            break;
                        }
                        case 255: {
                            byte[] label = this.readSubBlock(is);
                            if (formatCompliance != null) {
                                formatCompliance.addComment("Unknown Application Extension (" + new String(label) + ")", completeCode);
                            }
                            if (label == null || label.length <= 0) continue block12;
                            GenericGIFBlock block = this.readGenericGIFBlock(is, completeCode, label);
                            byte[] bytes = block.appendSubBlocks();
                            result.add(block);
                            break;
                        }
                        default: {
                            if (formatCompliance != null) {
                                formatCompliance.addComment("Unknown block", completeCode);
                            }
                            GenericGIFBlock block = this.readGenericGIFBlock(is, completeCode);
                            result.add(block);
                            break;
                        }
                    }
                    break;
                }
                case 59: {
                    return result;
                }
                case 0: {
                    break;
                }
                default: {
                    throw new ImageReadException("GIF: unknown code: " + code);
                }
            }
        }
    }

    private ImageDescriptor readImageDescriptor(GIFHeaderInfo ghi, int blockCode, InputStream is, boolean stopBeforeImageData, FormatCompliance formatCompliance) throws ImageReadException, IOException {
        int LZWMinimumCodeSize;
        boolean SortFlag;
        boolean InterlaceFlag;
        boolean LocalColorTableFlag;
        int ImageLeftPosition = this.read2Bytes("Image Left Position", is, "Not a Valid GIF File");
        int ImageTopPosition = this.read2Bytes("Image Top Position", is, "Not a Valid GIF File");
        int imageWidth = this.read2Bytes("Image Width", is, "Not a Valid GIF File");
        int imageHeight = this.read2Bytes("Image Height", is, "Not a Valid GIF File");
        byte PackedFields = this.readByte("Packed Fields", is, "Not a Valid GIF File");
        if (formatCompliance != null) {
            formatCompliance.checkBounds("Width", 1, ghi.logicalScreenWidth, imageWidth);
            formatCompliance.checkBounds("Height", 1, ghi.logicalScreenHeight, imageHeight);
            formatCompliance.checkBounds("Left Position", 0, ghi.logicalScreenWidth - imageWidth, ImageLeftPosition);
            formatCompliance.checkBounds("Top Position", 0, ghi.logicalScreenHeight - imageHeight, ImageTopPosition);
        }
        if (this.debug) {
            this.printByteBits("PackedFields bits", PackedFields);
        }
        boolean bl = LocalColorTableFlag = (PackedFields >> 7 & 1) > 0;
        if (this.debug) {
            System.out.println("LocalColorTableFlag: " + LocalColorTableFlag);
        }
        boolean bl2 = InterlaceFlag = (PackedFields >> 6 & 1) > 0;
        if (this.debug) {
            System.out.println("Interlace Flag: " + InterlaceFlag);
        }
        boolean bl3 = SortFlag = (PackedFields >> 5 & 1) > 0;
        if (this.debug) {
            System.out.println("Sort  Flag: " + SortFlag);
        }
        byte SizeofLocalColorTable = (byte)(PackedFields & 7);
        if (this.debug) {
            System.out.println("SizeofLocalColorTable: " + SizeofLocalColorTable);
        }
        byte[] LocalColorTable = null;
        if (LocalColorTableFlag) {
            LocalColorTable = this.readColorTable(is, SizeofLocalColorTable, formatCompliance);
        }
        byte[] imageData = null;
        if (!stopBeforeImageData) {
            LZWMinimumCodeSize = is.read();
            GenericGIFBlock block = this.readGenericGIFBlock(is, -1);
            byte[] bytes = block.appendSubBlocks();
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            int size = imageWidth * imageHeight;
            MyLZWDecompressor myLzwDecompressor = new MyLZWDecompressor(LZWMinimumCodeSize, 73);
            imageData = myLzwDecompressor.decompress(bais, size);
        } else {
            LZWMinimumCodeSize = is.read();
            if (this.debug) {
                System.out.println("LZWMinimumCodeSize: " + LZWMinimumCodeSize);
            }
            this.readGenericGIFBlock(is, -1);
        }
        ImageDescriptor result = new ImageDescriptor(blockCode, ImageLeftPosition, ImageTopPosition, imageWidth, imageHeight, PackedFields, LocalColorTableFlag, InterlaceFlag, SortFlag, SizeofLocalColorTable, LocalColorTable, imageData);
        return result;
    }

    private int simple_pow(int base, int power) {
        int result = 1;
        for (int i = 0; i < power; ++i) {
            result *= base;
        }
        return result;
    }

    private int convertColorTableSize(int ct_size) {
        return 3 * this.simple_pow(2, ct_size + 1);
    }

    private byte[] readColorTable(InputStream is, int ct_size, FormatCompliance formatCompliance) throws ImageReadException, IOException {
        int actual_size = this.convertColorTableSize(ct_size);
        byte[] bytes = this.readByteArray("block", actual_size, is, "GIF: corrupt Color Table");
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GIFHeaderInfo readHeader(ByteSource byteSource) throws ImageReadException, IOException {
        InputStream is = null;
        try {
            is = byteSource.getInputStream();
            GIFHeaderInfo gIFHeaderInfo = this.readHeader(is, FormatCompliance.getDefault());
            return gIFHeaderInfo;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e2) {
                Debug.debug(e2);
            }
        }
    }

    private GIFBlock findBlock(ArrayList v, int code) {
        for (int i = 0; i < v.size(); ++i) {
            GIFBlock gifBlock = (GIFBlock)v.get(i);
            if (gifBlock.blockCode != code) continue;
            return gifBlock;
        }
        return null;
    }

    private ImageContents readFile(ByteSource byteSource, boolean stopBeforeImageData) throws ImageReadException, IOException {
        return this.readFile(byteSource, stopBeforeImageData, FormatCompliance.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageContents readFile(ByteSource byteSource, boolean stopBeforeImageData, FormatCompliance formatCompliance) throws ImageReadException, IOException {
        InputStream is = null;
        try {
            ImageContents result;
            is = byteSource.getInputStream();
            GIFHeaderInfo ghi = this.readHeader(is, formatCompliance);
            byte[] globalColorTable = null;
            if (ghi.globalColorTableFlag) {
                globalColorTable = this.readColorTable(is, ghi.sizeOfGlobalColorTable, formatCompliance);
            }
            ArrayList blocks = this.readBlocks(ghi, is, stopBeforeImageData, formatCompliance);
            ImageContents imageContents = result = new ImageContents(ghi, globalColorTable, blocks);
            return imageContents;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e2) {
                Debug.debug(e2);
            }
        }
    }

    public byte[] getICCProfileBytes(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        return null;
    }

    public Dimension getImageSize(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        GIFHeaderInfo bhi = this.readHeader(byteSource);
        if (bhi == null) {
            throw new ImageReadException("GIF: Couldn't read Header");
        }
        return new Dimension(bhi.logicalScreenWidth, bhi.logicalScreenHeight);
    }

    public byte[] embedICCProfile(byte[] image, byte[] profile) {
        return null;
    }

    public boolean embedICCProfile(File src, File dst, byte[] profile) {
        return false;
    }

    public IImageMetadata getMetadata(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        return null;
    }

    private ArrayList getComments(ArrayList v) throws ImageReadException, IOException {
        ArrayList<String> result = new ArrayList<String>();
        int code = 8702;
        for (int i = 0; i < v.size(); ++i) {
            GIFBlock block = (GIFBlock)v.get(i);
            if (block.blockCode != code) continue;
            byte[] bytes = ((GenericGIFBlock)block).appendSubBlocks();
            result.add(new String(bytes));
        }
        return result;
    }

    public ImageInfo getImageInfo(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        ImageContents blocks = this.readFile(byteSource, false);
        if (blocks == null) {
            throw new ImageReadException("GIF: Couldn't read blocks");
        }
        GIFHeaderInfo bhi = blocks.gifHeaderInfo;
        if (bhi == null) {
            throw new ImageReadException("GIF: Couldn't read Header");
        }
        ImageDescriptor id = (ImageDescriptor)this.findBlock(blocks.blocks, 44);
        if (id == null) {
            throw new ImageReadException("GIF: Couldn't read ImageDescriptor");
        }
        GraphicControlExtension gce = (GraphicControlExtension)this.findBlock(blocks.blocks, 8697);
        int Height = bhi.logicalScreenHeight;
        int Width = bhi.logicalScreenWidth;
        ArrayList Comments = this.getComments(blocks.blocks);
        int BitsPerPixel = (bhi.colorResolution + 1) * 3;
        ImageFormat Format2 = ImageFormat.IMAGE_FORMAT_GIF;
        String FormatName = "GIF Graphics Interchange Format";
        String MimeType2 = "image/gif";
        int NumberOfImages = -1;
        boolean isProgressive = id.interlaceFlag;
        int PhysicalWidthDpi = 72;
        float PhysicalWidthInch = (float)((double)Width / (double)PhysicalWidthDpi);
        int PhysicalHeightDpi = 72;
        float PhysicalHeightInch = (float)((double)Height / (double)PhysicalHeightDpi);
        String FormatDetails = "Gif " + (char)blocks.gifHeaderInfo.version1 + (char)blocks.gifHeaderInfo.version2 + (char)blocks.gifHeaderInfo.version3;
        boolean isTransparent = false;
        if (gce != null && gce.transparency) {
            isTransparent = true;
        }
        boolean usesPalette = true;
        int colorType = 2;
        String compressionAlgorithm = "LZW";
        ImageInfo result = new ImageInfo(FormatDetails, BitsPerPixel, Comments, Format2, FormatName, Height, MimeType2, NumberOfImages, PhysicalHeightDpi, PhysicalHeightInch, PhysicalWidthDpi, PhysicalWidthInch, Width, isProgressive, isTransparent, usesPalette, colorType, compressionAlgorithm);
        return result;
    }

    public boolean dumpImageFile(PrintWriter pw, ByteSource byteSource) throws ImageReadException, IOException {
        pw.println("gif.dumpImageFile");
        ImageInfo imageData = this.getImageInfo(byteSource);
        if (imageData == null) {
            return false;
        }
        imageData.toString(pw, "");
        ImageContents blocks = this.readFile(byteSource, false);
        if (blocks == null) {
            return false;
        }
        pw.println("gif.blocks: " + blocks.blocks.size());
        for (int i = 0; i < blocks.blocks.size(); ++i) {
            GIFBlock gifBlock = (GIFBlock)blocks.blocks.get(i);
            this.debugNumber(pw, "\t" + i + " (" + gifBlock.getClass().getName() + ")", gifBlock.blockCode, 4);
        }
        pw.println("");
        return true;
    }

    private int[] getColorTable(byte[] bytes) throws ImageReadException, IOException {
        if (bytes.length % 3 != 0) {
            throw new ImageReadException("Bad Color Table Length: " + bytes.length);
        }
        int length = bytes.length / 3;
        int[] result = new int[length];
        for (int i = 0; i < length; ++i) {
            int rgb;
            int red = 0xFF & bytes[i * 3 + 0];
            int green = 0xFF & bytes[i * 3 + 1];
            int blue = 0xFF & bytes[i * 3 + 2];
            int alpha = 255;
            result[i] = rgb = alpha << 24 | red << 16 | green << 8 | blue << 0;
        }
        return result;
    }

    public FormatCompliance getFormatCompliance(ByteSource byteSource) throws ImageReadException, IOException {
        FormatCompliance result = new FormatCompliance(byteSource.getDescription());
        this.readFile(byteSource, false, result);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BufferedImage getBufferedImage(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        int[] colortable;
        ImageContents imageContents = this.readFile(byteSource, false);
        if (imageContents == null) {
            throw new ImageReadException("GIF: Couldn't read blocks");
        }
        GIFHeaderInfo ghi = imageContents.gifHeaderInfo;
        if (ghi == null) {
            throw new ImageReadException("GIF: Couldn't read Header");
        }
        ImageDescriptor id = (ImageDescriptor)this.findBlock(imageContents.blocks, 44);
        if (id == null) {
            throw new ImageReadException("GIF: Couldn't read Image Descriptor");
        }
        GraphicControlExtension gce = (GraphicControlExtension)this.findBlock(imageContents.blocks, 8697);
        int width = ghi.logicalScreenWidth;
        int height = ghi.logicalScreenHeight;
        boolean hasAlpha = false;
        if (gce != null && gce.transparency) {
            hasAlpha = true;
        }
        BufferedImage result = this.getBufferedImageFactory(params).getColorBufferedImage(width, height, hasAlpha);
        if (id.localColorTable != null) {
            colortable = this.getColorTable(id.localColorTable);
        } else {
            if (imageContents.globalColorTable == null) throw new ImageReadException("Gif: No Color Table");
            colortable = this.getColorTable(imageContents.globalColorTable);
        }
        int transparentIndex = -1;
        if (hasAlpha) {
            transparentIndex = gce.transparentColorIndex;
        }
        int counter = 0;
        int rows_in_pass_1 = (height + 7) / 8;
        int rows_in_pass_2 = (height + 3) / 8;
        int rows_in_pass_3 = (height + 1) / 4;
        int rows_in_pass_4 = height / 2;
        DataBuffer db = result.getRaster().getDataBuffer();
        for (int row = 0; row < height; ++row) {
            int y;
            if (id.interlaceFlag) {
                int the_row = row;
                if (the_row < rows_in_pass_1) {
                    y = the_row * 8;
                } else if ((the_row -= rows_in_pass_1) < rows_in_pass_2) {
                    y = 4 + the_row * 8;
                } else if ((the_row -= rows_in_pass_2) < rows_in_pass_3) {
                    y = 2 + the_row * 4;
                } else {
                    if ((the_row -= rows_in_pass_3) >= rows_in_pass_4) throw new ImageReadException("Gif: Strange Row");
                    y = 1 + the_row * 2;
                }
            } else {
                y = row;
            }
            for (int x = 0; x < width; ++x) {
                int index = 0xFF & id.imageData[counter++];
                int rgb = colortable[index];
                if (transparentIndex == index) {
                    rgb = 0;
                }
                db.setElem(y * width + x, rgb);
            }
        }
        return result;
    }

    private void writeAsSubBlocks(OutputStream os, byte[] bytes) throws IOException {
        int block_size;
        for (int index = 0; index < bytes.length; index += block_size) {
            block_size = Math.min(bytes.length - index, 255);
            os.write(block_size);
            os.write(bytes, index, block_size);
        }
        os.write(0);
    }

    public void writeImage(BufferedImage src, OutputStream os, Map params) throws ImageWriteException, IOException {
        params = new HashMap(params);
        boolean verbose = ParamMap.getParamBoolean(params, "VERBOSE", false);
        if (params.containsKey("FORMAT")) {
            params.remove("FORMAT");
        }
        if (params.containsKey("VERBOSE")) {
            params.remove("VERBOSE");
        }
        String xmpXml = null;
        if (params.containsKey("XMP_XML")) {
            xmpXml = (String)params.get("XMP_XML");
            params.remove("XMP_XML");
        }
        if (params.size() > 0) {
            Object firstKey = params.keySet().iterator().next();
            throw new ImageWriteException("Unknown parameter: " + firstKey);
        }
        int width = src.getWidth();
        int height = src.getHeight();
        boolean hasAlpha = new PaletteFactory().hasTransparency(src);
        int max_colors = hasAlpha ? 255 : 256;
        Palette palette2 = new PaletteFactory().makePaletteSimple(src, max_colors);
        if (palette2 == null) {
            palette2 = new PaletteFactory().makePaletteQuantized(src, max_colors);
            if (verbose) {
                System.out.println("quantizing");
            }
        } else if (verbose) {
            System.out.println("exact palette");
        }
        if (palette2 == null) {
            throw new ImageWriteException("Gif: can't write images with more than 256 colors");
        }
        int palette_size = palette2.length() + (hasAlpha ? 1 : 0);
        BinaryOutputStream bos = new BinaryOutputStream(os, 73);
        os.write(71);
        os.write(73);
        os.write(70);
        os.write(56);
        os.write(57);
        os.write(97);
        bos.write2Bytes(width);
        bos.write2Bytes(height);
        int colorTableScaleLessOne = palette_size > 128 ? 7 : (palette_size > 64 ? 6 : (palette_size > 32 ? 5 : (palette_size > 16 ? 4 : (palette_size > 8 ? 3 : (palette_size > 4 ? 2 : (palette_size > 2 ? 1 : 0))))));
        int colorTableSizeInFormat = 1 << colorTableScaleLessOne + 1;
        int actual_size = 3 * this.simple_pow(2, colorTableScaleLessOne + 1);
        byte colorResolution = (byte)colorTableScaleLessOne;
        boolean globalColorTableFlag = false;
        boolean sortFlag = false;
        int globalColorTableFlagMask = 128;
        int sortFlagMask = 8;
        int sizeOfGlobalColorTable = 0;
        int packedFields = (globalColorTableFlag ? globalColorTableFlagMask : 0) | (sortFlag ? sortFlagMask : 0) | (7 & colorResolution) << 4 | 7 & sizeOfGlobalColorTable;
        bos.write(packedFields);
        int BackgroundColorIndex = 0;
        bos.write(BackgroundColorIndex);
        int PixelAspectRatio = 0;
        bos.write(PixelAspectRatio);
        bos.write(33);
        bos.write(-7);
        bos.write(4);
        boolean packedFields2 = hasAlpha;
        bos.write((byte)(packedFields2 ? 1 : 0));
        bos.write(0);
        bos.write(0);
        bos.write((byte)(hasAlpha ? palette2.length() : 0));
        bos.write(0);
        if (null != xmpXml) {
            bos.write(33);
            bos.write(255);
            bos.write(XMP_APPLICATION_ID_AND_AUTH_CODE.length);
            bos.write(XMP_APPLICATION_ID_AND_AUTH_CODE);
            byte[] xmpXmlBytes = xmpXml.getBytes("utf-8");
            bos.write(xmpXmlBytes);
            for (int magic = 0; magic <= 255; ++magic) {
                bos.write(255 - magic);
            }
            bos.write(0);
        }
        bos.write(44);
        bos.write2Bytes(0);
        bos.write2Bytes(0);
        bos.write2Bytes(width);
        bos.write2Bytes(height);
        boolean LocalColorTableFlag = true;
        boolean InterlaceFlag = false;
        boolean SortFlag = false;
        int SizeOfLocalColorTable = colorTableScaleLessOne;
        int PackedFields = (LocalColorTableFlag ? 128 : 0) | (InterlaceFlag ? 64 : 0) | (SortFlag ? 32 : 0) | 7 & SizeOfLocalColorTable;
        bos.write(PackedFields);
        for (int i = 0; i < colorTableSizeInFormat; ++i) {
            if (i < palette2.length()) {
                int rgb = palette2.getEntry(i);
                int red = 0xFF & rgb >> 16;
                int green = 0xFF & rgb >> 8;
                int blue = 0xFF & rgb >> 0;
                bos.write(red);
                bos.write(green);
                bos.write(blue);
                continue;
            }
            bos.write(0);
            bos.write(0);
            bos.write(0);
        }
        int image_data_total = 0;
        int LZWMinimumCodeSize = colorTableScaleLessOne + 1;
        if (LZWMinimumCodeSize < 2) {
            LZWMinimumCodeSize = 2;
        }
        bos.write(LZWMinimumCodeSize);
        MyLZWCompressor compressor = new MyLZWCompressor(LZWMinimumCodeSize, 73, false);
        byte[] imagedata = new byte[width * height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int index;
                int argb = src.getRGB(x, y);
                int rgb = 0xFFFFFF & argb;
                if (hasAlpha) {
                    int alpha = 0xFF & argb >> 24;
                    int alphaThreshold = 255;
                    index = alpha < 255 ? palette2.length() : palette2.getPaletteIndex(rgb);
                } else {
                    index = palette2.getPaletteIndex(rgb);
                }
                imagedata[y * width + x] = (byte)index;
            }
        }
        byte[] compressed = compressor.compress(imagedata);
        this.writeAsSubBlocks(bos, compressed);
        image_data_total += compressed.length;
        bos.write(59);
        bos.close();
        os.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXmpXml(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        InputStream is = null;
        try {
            is = byteSource.getInputStream();
            FormatCompliance formatCompliance = null;
            GIFHeaderInfo ghi = this.readHeader(is, formatCompliance);
            byte[] globalColorTable = null;
            if (ghi.globalColorTableFlag) {
                globalColorTable = this.readColorTable(is, ghi.sizeOfGlobalColorTable, formatCompliance);
            }
            ArrayList blocks = this.readBlocks(ghi, is, true, formatCompliance);
            ArrayList<String> result = new ArrayList<String>();
            for (int i = 0; i < blocks.size(); ++i) {
                GenericGIFBlock genericBlock;
                byte[] blockBytes;
                GIFBlock block = (GIFBlock)blocks.get(i);
                if (block.blockCode != 8703 || (blockBytes = (genericBlock = (GenericGIFBlock)block).appendSubBlocks(true)).length < XMP_APPLICATION_ID_AND_AUTH_CODE.length || !this.compareByteArrays(blockBytes, 0, XMP_APPLICATION_ID_AND_AUTH_CODE, 0, XMP_APPLICATION_ID_AND_AUTH_CODE.length)) continue;
                byte[] GIF_MAGIC_TRAILER = new byte[256];
                for (int magic = 0; magic <= 255; ++magic) {
                    GIF_MAGIC_TRAILER[magic] = (byte)(255 - magic);
                }
                if (blockBytes.length < XMP_APPLICATION_ID_AND_AUTH_CODE.length + GIF_MAGIC_TRAILER.length) continue;
                if (!this.compareByteArrays(blockBytes, blockBytes.length - GIF_MAGIC_TRAILER.length, GIF_MAGIC_TRAILER, 0, GIF_MAGIC_TRAILER.length)) {
                    throw new ImageReadException("XMP block in GIF missing magic trailer.");
                }
                try {
                    String xml = new String(blockBytes, XMP_APPLICATION_ID_AND_AUTH_CODE.length, blockBytes.length - (XMP_APPLICATION_ID_AND_AUTH_CODE.length + GIF_MAGIC_TRAILER.length), "utf-8");
                    result.add(xml);
                    continue;
                }
                catch (UnsupportedEncodingException e2) {
                    throw new ImageReadException("Invalid XMP Block in GIF.");
                }
            }
            if (result.size() < 1) {
                String string = null;
                return string;
            }
            if (result.size() > 1) {
                throw new ImageReadException("More than one XMP Block in GIF.");
            }
            String string = (String)result.get(0);
            return string;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e3) {
                Debug.debug(e3);
            }
        }
    }
}

