/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.png.scanlinefilters;

import java.io.IOException;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.formats.png.scanlinefilters.ScanlineFilter;

public class ScanlineFilterPaeth
extends ScanlineFilter {
    private final int BytesPerPixel;

    public ScanlineFilterPaeth(int BytesPerPixel) {
        this.BytesPerPixel = BytesPerPixel;
    }

    private int PaethPredictor(int a2, int b2, int c2) {
        int p = a2 + b2 - c2;
        int pa = Math.abs(p - a2);
        int pb = Math.abs(p - b2);
        int pc = Math.abs(p - c2);
        if (pa <= pb && pa <= pc) {
            return a2;
        }
        if (pb <= pc) {
            return b2;
        }
        return c2;
    }

    public void unfilter(byte[] src, byte[] dst, byte[] up) throws ImageReadException, IOException {
        for (int i = 0; i < src.length; ++i) {
            byte left = 0;
            int prev_index = i - this.BytesPerPixel;
            if (prev_index >= 0) {
                left = dst[prev_index];
            }
            byte above = 0;
            if (up != null) {
                above = up[i];
            }
            byte upperleft = 0;
            if (prev_index >= 0 && up != null) {
                upperleft = up[prev_index];
            }
            int PaethPredictor = this.PaethPredictor(0xFF & left, 0xFF & above, 0xFF & upperleft);
            dst[i] = (byte)((src[i] + PaethPredictor) % 256);
        }
    }
}

