/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.pnm;

import java.io.IOException;
import java.io.InputStream;

class WhiteSpaceReader {
    private final InputStream is;
    int count = 0;

    public WhiteSpaceReader(InputStream is) {
        this.is = is;
    }

    private char read() throws IOException {
        int result = this.is.read();
        if (result < 0) {
            throw new IOException("PNM: Unexpected EOF");
        }
        return (char)result;
    }

    public char nextChar() throws IOException {
        char c2 = this.read();
        if (c2 == '#') {
            while (c2 != '\n' && c2 != '\r') {
                c2 = this.read();
            }
        }
        return c2;
    }

    public String readtoWhiteSpace() throws IOException {
        char c2 = this.nextChar();
        while (Character.isWhitespace(c2)) {
            c2 = this.nextChar();
        }
        StringBuffer buffer = new StringBuffer();
        while (!Character.isWhitespace(c2)) {
            buffer.append(c2);
            c2 = this.nextChar();
        }
        return buffer.toString();
    }
}

