/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.icc;

import java.awt.color.ICC_Profile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.sanselan.common.BinaryFileParser;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.common.byteSources.ByteSourceArray;
import org.apache.sanselan.common.byteSources.ByteSourceFile;
import org.apache.sanselan.icc.IccConstants;
import org.apache.sanselan.icc.IccProfileInfo;
import org.apache.sanselan.icc.IccTag;
import org.apache.sanselan.icc.IccTagType;
import org.apache.sanselan.util.CachingInputStream;
import org.apache.sanselan.util.Debug;

public class IccProfileParser
extends BinaryFileParser
implements IccConstants {
    public IccProfileParser() {
        this.setByteOrder(77);
    }

    public IccProfileInfo getICCProfileInfo(ICC_Profile icc_profile) {
        if (icc_profile == null) {
            return null;
        }
        return this.getICCProfileInfo(new ByteSourceArray(icc_profile.getData()));
    }

    public IccProfileInfo getICCProfileInfo(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return this.getICCProfileInfo(new ByteSourceArray(bytes));
    }

    public IccProfileInfo getICCProfileInfo(File file) {
        if (file == null) {
            return null;
        }
        return this.getICCProfileInfo(new ByteSourceFile(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IccProfileInfo getICCProfileInfo(ByteSource byteSource) {
        InputStream is = null;
        try {
            is = byteSource.getInputStream();
            IccProfileInfo result = this.readICCProfileInfo(is);
            if (result == null) {
                IccProfileInfo iccProfileInfo = null;
                return iccProfileInfo;
            }
            is.close();
            is = null;
            for (int i = 0; i < result.tags.length; ++i) {
                IccTag tag = result.tags[i];
                byte[] bytes = byteSource.getBlock(tag.offset, tag.length);
                tag.setData(bytes);
            }
            IccProfileInfo iccProfileInfo = result;
            return iccProfileInfo;
        }
        catch (Exception e2) {
            Debug.debug(e2);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e3) {
                Debug.debug(e3);
            }
        }
        if (this.debug) {
            Debug.debug();
        }
        return null;
    }

    private IccProfileInfo readICCProfileInfo(InputStream is) {
        CachingInputStream cis = new CachingInputStream(is);
        is = cis;
        if (this.debug) {
            Debug.debug();
        }
        try {
            int ProfileSize = this.read4Bytes("ProfileSize", is, "Not a Valid ICC Profile");
            int CMMTypeSignature = this.read4Bytes("Signature", is, "Not a Valid ICC Profile");
            if (this.debug) {
                this.printCharQuad("CMMTypeSignature", CMMTypeSignature);
            }
            int ProfileVersion = this.read4Bytes("ProfileVersion", is, "Not a Valid ICC Profile");
            int ProfileDeviceClassSignature = this.read4Bytes("ProfileDeviceClassSignature", is, "Not a Valid ICC Profile");
            if (this.debug) {
                this.printCharQuad("ProfileDeviceClassSignature", ProfileDeviceClassSignature);
            }
            int ColorSpace2 = this.read4Bytes("ColorSpace", is, "Not a Valid ICC Profile");
            if (this.debug) {
                this.printCharQuad("ColorSpace", ColorSpace2);
            }
            int ProfileConnectionSpace = this.read4Bytes("ProfileConnectionSpace", is, "Not a Valid ICC Profile");
            if (this.debug) {
                this.printCharQuad("ProfileConnectionSpace", ProfileConnectionSpace);
            }
            this.skipBytes(is, 12, "Not a Valid ICC Profile");
            int ProfileFileSignature = this.read4Bytes("ProfileFileSignature", is, "Not a Valid ICC Profile");
            if (this.debug) {
                this.printCharQuad("ProfileFileSignature", ProfileFileSignature);
            }
            int PrimaryPlatformSignature = this.read4Bytes("PrimaryPlatformSignature", is, "Not a Valid ICC Profile");
            if (this.debug) {
                this.printCharQuad("PrimaryPlatformSignature", PrimaryPlatformSignature);
            }
            int VariousFlags = this.read4Bytes("ProfileFileSignature", is, "Not a Valid ICC Profile");
            if (this.debug) {
                this.printCharQuad("ProfileFileSignature", ProfileFileSignature);
            }
            int DeviceManufacturer = this.read4Bytes("ProfileFileSignature", is, "Not a Valid ICC Profile");
            if (this.debug) {
                this.printCharQuad("DeviceManufacturer", DeviceManufacturer);
            }
            int DeviceModel = this.read4Bytes("DeviceModel", is, "Not a Valid ICC Profile");
            if (this.debug) {
                this.printCharQuad("DeviceModel", DeviceModel);
            }
            this.skipBytes(is, 8, "Not a Valid ICC Profile");
            int RenderingIntent = this.read4Bytes("RenderingIntent", is, "Not a Valid ICC Profile");
            if (this.debug) {
                this.printCharQuad("RenderingIntent", RenderingIntent);
            }
            this.skipBytes(is, 12, "Not a Valid ICC Profile");
            int ProfileCreatorSignature = this.read4Bytes("ProfileCreatorSignature", is, "Not a Valid ICC Profile");
            if (this.debug) {
                this.printCharQuad("ProfileCreatorSignature", ProfileCreatorSignature);
            }
            byte[] ProfileID = null;
            this.skipBytes(is, 16, "Not a Valid ICC Profile");
            this.skipBytes(is, 28, "Not a Valid ICC Profile");
            int TagCount = this.read4Bytes("TagCount", is, "Not a Valid ICC Profile");
            IccTag[] tags = new IccTag[TagCount];
            for (int i = 0; i < TagCount; ++i) {
                IccTag tag;
                int TagSignature = this.read4Bytes("TagSignature[" + i + "]", is, "Not a Valid ICC Profile");
                int OffsetToData = this.read4Bytes("OffsetToData[" + i + "]", is, "Not a Valid ICC Profile");
                int ElementSize = this.read4Bytes("ElementSize[" + i + "]", is, "Not a Valid ICC Profile");
                IccTagType fIccTagType = this.getIccTagType(TagSignature);
                tags[i] = tag = new IccTag(TagSignature, OffsetToData, ElementSize, fIccTagType);
            }
            while (is.read() >= 0) {
            }
            byte[] data = cis.getCache();
            if (data.length < ProfileSize) {
                throw new IOException("Couldn't read ICC Profile.");
            }
            IccProfileInfo result = new IccProfileInfo(data, ProfileSize, CMMTypeSignature, ProfileVersion, ProfileDeviceClassSignature, ColorSpace2, ProfileConnectionSpace, ProfileFileSignature, PrimaryPlatformSignature, VariousFlags, DeviceManufacturer, DeviceModel, RenderingIntent, ProfileCreatorSignature, ProfileID, tags);
            if (this.debug) {
                Debug.debug("issRGB: " + result.issRGB());
            }
            return result;
        }
        catch (Exception e2) {
            Debug.debug(e2);
            return null;
        }
    }

    private IccTagType getIccTagType(int quad) {
        for (int i = 0; i < TagTypes.length; ++i) {
            if (IccProfileParser.TagTypes[i].signature != quad) continue;
            return TagTypes[i];
        }
        return null;
    }

    public Boolean issRGB(ICC_Profile icc_profile) {
        if (icc_profile == null) {
            return null;
        }
        return this.issRGB(new ByteSourceArray(icc_profile.getData()));
    }

    public Boolean issRGB(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return this.issRGB(new ByteSourceArray(bytes));
    }

    public Boolean issRGB(File file) {
        if (file == null) {
            return null;
        }
        return this.issRGB(new ByteSourceFile(file));
    }

    public Boolean issRGB(ByteSource byteSource) {
        try {
            if (this.debug) {
                Debug.debug();
            }
            InputStream is = byteSource.getInputStream();
            int ProfileSize = this.read4Bytes("ProfileSize", is, "Not a Valid ICC Profile");
            this.skipBytes(is, 20);
            this.skipBytes(is, 12, "Not a Valid ICC Profile");
            this.skipBytes(is, 12);
            int DeviceManufacturer = this.read4Bytes("ProfileFileSignature", is, "Not a Valid ICC Profile");
            if (this.debug) {
                this.printCharQuad("DeviceManufacturer", DeviceManufacturer);
            }
            int DeviceModel = this.read4Bytes("DeviceModel", is, "Not a Valid ICC Profile");
            if (this.debug) {
                this.printCharQuad("DeviceModel", DeviceModel);
            }
            boolean result = DeviceManufacturer == 1229275936 && DeviceModel == 1934772034;
            return new Boolean(result);
        }
        catch (Exception e2) {
            Debug.debug(e2);
            return null;
        }
    }
}

