/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.palette;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.apache.sanselan.palette.ColorSpaceSubset;
import org.apache.sanselan.palette.Palette;
import org.apache.sanselan.palette.QuantizedPalette;
import org.apache.sanselan.palette.SimplePalette;

public class PaletteFactory {
    private static final boolean debug = false;
    public static final int components = 3;

    public void makePaletteFancy(BufferedImage src) {
        byte[] rgbmap = new byte[0x200000];
        for (int i = 0; i < rgbmap.length; ++i) {
            rgbmap[i] = 0;
        }
        int width = src.getWidth();
        int height = src.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int argb = src.getRGB(x, y);
                int rggbb = 0x1FFFFF & argb;
                int highred = 7 & argb >> 21;
                int mask = 1 << highred;
                int n = rggbb;
                rgbmap[n] = (byte)(rgbmap[n] | mask);
            }
        }
        int count = 0;
        for (int i = 0; i < rgbmap.length; ++i) {
            int eight = 0xFF & rgbmap[i];
            if (i < 3 || i - rgbmap.length > -3) {
                // empty if block
            }
            for (int j = 0; j < 8; ++j) {
                int mask = 1 << 7 - j;
                int bit = eight & mask;
                if (bit <= 0) continue;
                ++count;
            }
        }
        int[] colormap = new int[count];
        int mapsize = 0;
        for (int i = 0; i < rgbmap.length; ++i) {
            int eight = 0xFF & rgbmap[i];
            for (int j = 0; j < 8; ++j) {
                int mask = 1 << 7 - j;
                int bit = eight & mask;
                if (bit <= 0) continue;
                int rgb = i | 7 - j << 21;
                if (mapsize < colormap.length) {
                    colormap[mapsize] = rgb;
                }
                ++mapsize;
            }
        }
    }

    private int pixelToQuantizationTableIndex(int argb, int precision) {
        int result = 0;
        int precision_mask = (1 << precision) - 1;
        for (int i = 0; i < 3; ++i) {
            int sample = argb & 0xFF;
            argb >>= 8;
            result = result << precision | (sample >>= 8 - precision) & precision_mask;
        }
        return result;
    }

    private int getFrequencyTotal(int[] table, int[] mins, int[] maxs, int precision) {
        int sum = 0;
        for (int blue = mins[2]; blue <= maxs[2]; ++blue) {
            int b2 = blue << 2 * precision;
            for (int green = mins[1]; green <= maxs[1]; ++green) {
                int g2 = green << 1 * precision;
                for (int red = mins[0]; red <= maxs[0]; ++red) {
                    int index = b2 | g2 | red;
                    sum += table[index];
                }
            }
        }
        return sum;
    }

    private DivisionCandidate finishDivision(int[] table, ColorSpaceSubset subset, int component, int precision, int sum, int slice) {
        int total = subset.total;
        if (slice < subset.mins[component] || slice >= subset.maxs[component]) {
            return null;
        }
        if (sum < 1 || sum >= total) {
            return null;
        }
        int remainder = total - sum;
        if (remainder < 1 || remainder >= total) {
            return null;
        }
        int[] slice_mins = new int[subset.mins.length];
        System.arraycopy(subset.mins, 0, slice_mins, 0, subset.mins.length);
        int[] slice_maxs = new int[subset.maxs.length];
        System.arraycopy(subset.maxs, 0, slice_maxs, 0, subset.maxs.length);
        slice_maxs[component] = slice;
        slice_mins[component] = slice + 1;
        ColorSpaceSubset first = new ColorSpaceSubset(sum, precision, subset.mins, slice_maxs, table);
        ColorSpaceSubset second = new ColorSpaceSubset(total - sum, precision, slice_mins, subset.maxs, table);
        return new DivisionCandidate(subset, first, second);
    }

    private ArrayList divideSubset2(int[] table, ColorSpaceSubset subset, int component, int precision) {
        int total = subset.total;
        int[] slice_mins = new int[subset.mins.length];
        System.arraycopy(subset.mins, 0, slice_mins, 0, subset.mins.length);
        int[] slice_maxs = new int[subset.maxs.length];
        System.arraycopy(subset.maxs, 0, slice_maxs, 0, subset.maxs.length);
        int sum1 = 0;
        int last = 0;
        int slice1 = subset.mins[component];
        while (slice1 != subset.maxs[component] + 1) {
            slice_mins[component] = slice1;
            slice_maxs[component] = slice1++;
            last = this.getFrequencyTotal(table, slice_mins, slice_maxs, precision);
            if ((sum1 += last) >= total / 2) break;
        }
        int sum2 = sum1 - last;
        int slice2 = slice1 - 1;
        DivisionCandidate dc1 = this.finishDivision(table, subset, component, precision, sum1, slice1);
        DivisionCandidate dc2 = this.finishDivision(table, subset, component, precision, sum2, slice2);
        ArrayList<DivisionCandidate> result = new ArrayList<DivisionCandidate>();
        if (dc1 != null) {
            result.add(dc1);
        }
        if (dc2 != null) {
            result.add(dc2);
        }
        return result;
    }

    private DivisionCandidate divideSubset2(int[] table, ColorSpaceSubset subset, int precision) {
        ArrayList dcs = new ArrayList();
        dcs.addAll(this.divideSubset2(table, subset, 0, precision));
        dcs.addAll(this.divideSubset2(table, subset, 1, precision));
        dcs.addAll(this.divideSubset2(table, subset, 2, precision));
        DivisionCandidate best_v = null;
        double best_score = Double.MAX_VALUE;
        for (int i = 0; i < dcs.size(); ++i) {
            double split;
            DivisionCandidate dc = (DivisionCandidate)dcs.get(i);
            ColorSpaceSubset first = dc.dst_a;
            ColorSpaceSubset second = dc.dst_b;
            int area1 = first.total;
            int area2 = second.total;
            int diff = Math.abs(area1 - area2);
            double score = split = (double)diff / (double)Math.max(area1, area2);
            if (best_v == null) {
                best_v = dc;
                best_score = score;
                continue;
            }
            if (!(score < best_score)) continue;
            best_v = dc;
            best_score = score;
        }
        return best_v;
    }

    private ArrayList divide(ArrayList v, int desired_count, int[] table, int precision) {
        ArrayList<ColorSpaceSubset> ignore = new ArrayList<ColorSpaceSubset>();
        int count = 0;
        do {
            ++count;
            int max_area = -1;
            ColorSpaceSubset max_subset = null;
            for (int i = 0; i < v.size(); ++i) {
                ColorSpaceSubset subset = (ColorSpaceSubset)v.get(i);
                if (ignore.contains(subset)) continue;
                int area = subset.total;
                if (max_subset == null) {
                    max_subset = subset;
                    max_area = area;
                    continue;
                }
                if (area <= max_area) continue;
                max_subset = subset;
                max_area = area;
            }
            if (max_subset == null) {
                return v;
            }
            DivisionCandidate dc = this.divideSubset2(table, max_subset, precision);
            if (dc != null) {
                v.remove(max_subset);
                v.add(dc.dst_a);
                v.add(dc.dst_b);
                continue;
            }
            ignore.add(max_subset);
        } while (v.size() != desired_count);
        return v;
    }

    public Palette makePaletteQuantized(BufferedImage src, int max) {
        int precision = 6;
        int table_scale = precision * 3;
        int table_size = 1 << table_scale;
        int[] table = new int[table_size];
        int width = src.getWidth();
        int height = src.getHeight();
        ArrayList subsets = new ArrayList();
        ColorSpaceSubset all = new ColorSpaceSubset(width * height, precision);
        subsets.add(all);
        int pre_total = this.getFrequencyTotal(table, all.mins, all.maxs, precision);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int index;
                int argb = src.getRGB(x, y);
                int n = index = this.pixelToQuantizationTableIndex(argb, precision);
                table[n] = table[n] + 1;
            }
        }
        int all_total = this.getFrequencyTotal(table, all.mins, all.maxs, precision);
        subsets = this.divide(subsets, 256, table, precision);
        for (int i = 0; i < subsets.size(); ++i) {
            ColorSpaceSubset subset = (ColorSpaceSubset)subsets.get(i);
            subset.setAverageRGB(table);
        }
        Collections.sort(subsets);
        return new QuantizedPalette(subsets, precision);
    }

    public SimplePalette makePaletteSimple(BufferedImage src, int max) {
        HashMap<String, String> map = new HashMap<String, String>();
        int[] rgbs = new int[max];
        int rgb_count = 0;
        int width = src.getWidth();
        int height = src.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int argb = src.getRGB(x, y);
                int rgb = 0xFFFFFF & argb;
                String key = "" + rgb;
                if (null != map.get(key)) continue;
                if (rgb_count == max) {
                    return null;
                }
                rgbs[rgb_count] = rgb;
                map.put(key, key);
                ++rgb_count;
            }
        }
        int[] result = new int[rgb_count];
        System.arraycopy(rgbs, 0, result, 0, rgb_count);
        Arrays.sort(result);
        return new SimplePalette(result);
    }

    public boolean isGrayscale(BufferedImage src) {
        int width = src.getWidth();
        int height = src.getHeight();
        if (6 == src.getColorModel().getColorSpace().getType()) {
            return true;
        }
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int argb = src.getRGB(x, y);
                int red = 0xFF & argb >> 16;
                int green = 0xFF & argb >> 8;
                int blue = 0xFF & argb >> 0;
                if (red == green && red == blue) continue;
                return false;
            }
        }
        return true;
    }

    public boolean hasTransparency(BufferedImage src) {
        return this.hasTransparency(src, 255);
    }

    public boolean hasTransparency(BufferedImage src, int threshold) {
        int width = src.getWidth();
        int height = src.getHeight();
        if (!src.getColorModel().hasAlpha()) {
            return false;
        }
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int argb = src.getRGB(x, y);
                int alpha = 0xFF & argb >> 24;
                if (alpha >= threshold) continue;
                return true;
            }
        }
        return false;
    }

    public int countTrasparentColors(int[] rgbs) {
        int first = -1;
        for (int i = 0; i < rgbs.length; ++i) {
            int rgb = rgbs[i];
            int alpha = 0xFF & rgb >> 24;
            if (alpha >= 255) continue;
            if (first < 0) {
                first = rgb;
                continue;
            }
            if (rgb == first) continue;
            return 2;
        }
        if (first < 0) {
            return 0;
        }
        return 1;
    }

    public int countTransparentColors(BufferedImage src) {
        ColorModel cm = src.getColorModel();
        if (!cm.hasAlpha()) {
            return 0;
        }
        int width = src.getWidth();
        int height = src.getHeight();
        int first = -1;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int rgb = src.getRGB(x, y);
                int alpha = 0xFF & rgb >> 24;
                if (alpha >= 255) continue;
                if (first < 0) {
                    first = rgb;
                    continue;
                }
                if (rgb == first) continue;
                return 2;
            }
        }
        if (first < 0) {
            return 0;
        }
        return 1;
    }

    private static class DivisionCandidate {
        private final ColorSpaceSubset dst_a;
        private final ColorSpaceSubset dst_b;

        public DivisionCandidate(ColorSpaceSubset src, ColorSpaceSubset dst_a, ColorSpaceSubset dst_b) {
            this.dst_a = dst_a;
            this.dst_b = dst_b;
        }
    }
}

