/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.util;

import java.io.IOException;
import java.io.OutputStream;

public class DebugOutputStream
extends OutputStream {
    private final OutputStream os;
    private long count = 0L;

    public DebugOutputStream(OutputStream os) {
        this.os = os;
    }

    public void write(int b2) throws IOException {
        this.os.write(b2);
        ++this.count;
    }

    public void write(byte[] b2) throws IOException {
        this.os.write(b2);
        this.count += (long)b2.length;
    }

    public void write(byte[] b2, int off, int len) throws IOException {
        this.os.write(b2, off, len);
        this.count += (long)len;
    }

    public void flush() throws IOException {
        this.os.flush();
    }

    public void close() throws IOException {
        this.os.close();
    }

    public long count() {
        return this.count;
    }
}

