/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingbinding;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.ObjectProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.beansbinding.PropertyStateEvent;
import org.jdesktop.beansbinding.PropertyStateListener;
import org.jdesktop.swingbinding.ElementsProperty;
import org.jdesktop.swingbinding.impl.AbstractColumnBinding;
import org.jdesktop.swingbinding.impl.ListBindingManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JListBinding<E, SS, TS>
extends AutoBinding<SS, List<E>, TS, List> {
    private Property<TS, ? extends JList> listP;
    private ElementsProperty<TS> elementsP;
    private Handler handler = new Handler();
    private JList list;
    private BindingListModel model;
    private DetailBinding detailBinding;
    private final Property DETAIL_PROPERTY = new Property(){

        public Class<Object> getWriteType(Object source) {
            return Object.class;
        }

        public Object getValue(Object source) {
            throw new UnsupportedOperationException();
        }

        public void setValue(Object source, Object value) {
            throw new UnsupportedOperationException();
        }

        public boolean isReadable(Object source) {
            throw new UnsupportedOperationException();
        }

        public boolean isWriteable(Object source) {
            return true;
        }

        public void addPropertyStateListener(Object source, PropertyStateListener listener) {
            throw new UnsupportedOperationException();
        }

        public void removePropertyStateListener(Object source, PropertyStateListener listener) {
            throw new UnsupportedOperationException();
        }

        public PropertyStateListener[] getPropertyStateListeners(Object source) {
            throw new UnsupportedOperationException();
        }
    };

    protected JListBinding(AutoBinding.UpdateStrategy strategy, SS sourceObject, Property<SS, List<E>> sourceListProperty, TS targetObject, Property<TS, ? extends JList> targetJListProperty, String name) {
        super(strategy == AutoBinding.UpdateStrategy.READ_WRITE ? AutoBinding.UpdateStrategy.READ : strategy, sourceObject, sourceListProperty, targetObject, new ElementsProperty(), name);
        if (targetJListProperty == null) {
            throw new IllegalArgumentException("target JList property can't be null");
        }
        this.listP = targetJListProperty;
        this.elementsP = (ElementsProperty)this.getTargetProperty();
        this.setDetailBinding(null);
    }

    @Override
    protected void bindImpl() {
        this.elementsP.setAccessible(this.isListAccessible());
        this.listP.addPropertyStateListener(this.getTargetObject(), this.handler);
        this.elementsP.addPropertyStateListener(null, this.handler);
        super.bindImpl();
    }

    @Override
    protected void unbindImpl() {
        this.elementsP.removePropertyStateListener(null, this.handler);
        this.listP.removePropertyStateListener(this.getTargetObject(), this.handler);
        this.elementsP.setAccessible(false);
        this.cleanupForLast();
        super.unbindImpl();
    }

    private boolean isListAccessible() {
        return this.listP.isReadable(this.getTargetObject()) && this.listP.getValue(this.getTargetObject()) != null;
    }

    private boolean isListAccessible(Object value) {
        return value != null && value != PropertyStateEvent.UNREADABLE;
    }

    private void cleanupForLast() {
        if (this.list == null) {
            return;
        }
        this.resetListSelection();
        this.list.setModel(new DefaultListModel());
        this.list = null;
        this.model.setElements(null, true);
        this.model = null;
    }

    public DetailBinding setDetailBinding(Property<E, ?> detailProperty) {
        return this.setDetailBinding(detailProperty, null);
    }

    public DetailBinding setDetailBinding(Property<E, ?> detailProperty, String name) {
        this.throwIfBound();
        if (name == null && this.getName() != null) {
            name = this.getName() + ".DETAIL_BINDING";
        }
        this.detailBinding = detailProperty == null ? new DetailBinding(ObjectProperty.create(), name) : new DetailBinding(detailProperty, name);
        return this.detailBinding;
    }

    public DetailBinding getDetailBinding() {
        return this.detailBinding;
    }

    private void resetListSelection() {
        ListSelectionModel selectionModel = this.list.getSelectionModel();
        selectionModel.setValueIsAdjusting(true);
        selectionModel.clearSelection();
        selectionModel.setAnchorSelectionIndex(-1);
        selectionModel.setLeadSelectionIndex(-1);
        selectionModel.setValueIsAdjusting(false);
    }

    private final class BindingListModel
    extends ListBindingManager
    implements ListModel {
        private final List<ListDataListener> listeners = new CopyOnWriteArrayList<ListDataListener>();

        protected AbstractColumnBinding[] getColBindings() {
            return new AbstractColumnBinding[]{JListBinding.this.getDetailBinding()};
        }

        protected void allChanged() {
            this.contentsChanged(0, this.size());
        }

        protected void valueChanged(int row, int column) {
            this.contentsChanged(row, row);
        }

        protected void added(int index, int length) {
            assert (length > 0);
            ListDataEvent e2 = new ListDataEvent(this, 1, index, index + length - 1);
            for (ListDataListener listener : this.listeners) {
                listener.intervalAdded(e2);
            }
        }

        protected void removed(int index, int length) {
            assert (length > 0);
            ListDataEvent e2 = new ListDataEvent(this, 2, index, index + length - 1);
            for (ListDataListener listener : this.listeners) {
                listener.intervalRemoved(e2);
            }
        }

        protected void changed(int row) {
            this.contentsChanged(row, row);
        }

        private void contentsChanged(int row0, int row1) {
            ListDataEvent e2 = new ListDataEvent(this, 0, row0, row1);
            for (ListDataListener listener : this.listeners) {
                listener.contentsChanged(e2);
            }
        }

        public Object getElementAt(int index) {
            return this.valueAt(index, 0);
        }

        public void addListDataListener(ListDataListener l) {
            this.listeners.add(l);
        }

        public void removeListDataListener(ListDataListener l) {
            this.listeners.remove(l);
        }

        public int getSize() {
            return this.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class DetailBinding
    extends AbstractColumnBinding {
        private DetailBinding(Property<E, ?> detailProperty, String name) {
            super(0, detailProperty, JListBinding.this.DETAIL_PROPERTY, name);
        }
    }

    private class Handler
    implements PropertyStateListener {
        private Handler() {
        }

        public void propertyStateChanged(PropertyStateEvent pse) {
            if (!pse.getValueChanged()) {
                return;
            }
            if (pse.getSourceProperty() == JListBinding.this.listP) {
                JListBinding.this.cleanupForLast();
                boolean wasAccessible = JListBinding.this.isListAccessible(pse.getOldValue());
                boolean isAccessible = JListBinding.this.isListAccessible(pse.getNewValue());
                if (wasAccessible != isAccessible) {
                    JListBinding.this.elementsP.setAccessible(isAccessible);
                } else if (JListBinding.this.elementsP.isAccessible()) {
                    JListBinding.this.elementsP.setValueAndIgnore(null, null);
                }
            } else {
                if (((ElementsProperty.ElementsPropertyStateEvent)pse).shouldIgnore()) {
                    return;
                }
                if (JListBinding.this.list == null) {
                    JListBinding.this.list = (JList)JListBinding.this.listP.getValue(JListBinding.this.getTargetObject());
                    JListBinding.this.resetListSelection();
                    JListBinding.this.model = new BindingListModel();
                    JListBinding.this.list.setModel(JListBinding.this.model);
                } else {
                    JListBinding.this.resetListSelection();
                }
                JListBinding.this.model.setElements((List)pse.getNewValue(), true);
            }
        }
    }
}

