/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingbinding.adapters;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import org.jdesktop.beansbinding.ext.BeanAdapterProvider;
import org.jdesktop.swingbinding.adapters.BeanAdapterBase;
import org.jdesktop.swingbinding.impl.ListBindingManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JTableAdapterProvider
implements BeanAdapterProvider {
    private static final String SELECTED_ELEMENT_P = "selectedElement";
    private static final String SELECTED_ELEMENTS_P = "selectedElements";
    private static final String SELECTED_ELEMENT_IA_P = "selectedElement_IGNORE_ADJUSTING";
    private static final String SELECTED_ELEMENTS_IA_P = "selectedElements_IGNORE_ADJUSTING";
    private static boolean IS_JAVA_15 = System.getProperty("java.version").startsWith("1.5");

    private static int viewToModel(JTable table, int index) {
        if (!IS_JAVA_15) {
            try {
                Method m = table.getClass().getMethod("convertRowIndexToModel", Integer.TYPE);
                index = (Integer)m.invoke((Object)table, index);
            }
            catch (NoSuchMethodException nsme) {
                throw new AssertionError((Object)nsme);
            }
            catch (IllegalAccessException iae) {
                throw new AssertionError((Object)iae);
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getCause();
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new RuntimeException(cause);
            }
        }
        return index;
    }

    private static int modelToView(JTable table, int index) {
        if (!IS_JAVA_15) {
            try {
                Method m = table.getClass().getMethod("convertRowIndexToView", Integer.TYPE);
                index = (Integer)m.invoke((Object)table, index);
            }
            catch (NoSuchMethodException nsme) {
                throw new AssertionError((Object)nsme);
            }
            catch (IllegalAccessException iae) {
                throw new AssertionError((Object)iae);
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getCause();
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new RuntimeException(cause);
            }
        }
        return index;
    }

    private static List<Object> getSelectedElements(JTable table) {
        assert (table != null);
        ListSelectionModel selectionModel = table.getSelectionModel();
        int min = selectionModel.getMinSelectionIndex();
        int max = selectionModel.getMaxSelectionIndex();
        if (min < 0 || max < 0) {
            return new ArrayList<Object>(0);
        }
        ArrayList<Object> elements = new ArrayList<Object>(max - min + 1);
        for (int i = min; i <= max; ++i) {
            if (!selectionModel.isSelectedIndex(i)) continue;
            elements.add(JTableAdapterProvider.getElement(table, i));
        }
        return elements;
    }

    private static Object getSelectedElement(JTable table) {
        assert (table != null);
        int index = table.getSelectionModel().getLeadSelectionIndex();
        int n = index = table.getSelectionModel().isSelectedIndex(index) ? index : table.getSelectionModel().getMinSelectionIndex();
        if (index == -1) {
            return null;
        }
        return JTableAdapterProvider.getElement(table, index);
    }

    private static Object getElement(JTable table, int index) {
        index = JTableAdapterProvider.viewToModel(table, index);
        TableModel model = table.getModel();
        if (model instanceof ListBindingManager) {
            return ((ListBindingManager)((Object)model)).getElement(index);
        }
        int columnCount = model.getColumnCount();
        HashMap<String, Object> map = new HashMap<String, Object>(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            map.put("column" + i, model.getValueAt(index, i));
        }
        return map;
    }

    @Override
    public boolean providesAdapter(Class<?> type, String property) {
        if (!JTable.class.isAssignableFrom(type)) {
            return false;
        }
        return (property = property.intern()) == SELECTED_ELEMENT_P || property == SELECTED_ELEMENT_IA_P || property == SELECTED_ELEMENTS_P || property == SELECTED_ELEMENTS_IA_P;
    }

    @Override
    public Object createAdapter(Object source, String property) {
        if (!this.providesAdapter(source.getClass(), property)) {
            throw new IllegalArgumentException();
        }
        return new Adapter((JTable)source, property);
    }

    @Override
    public Class<?> getAdapterClass(Class<?> type) {
        return JTable.class.isAssignableFrom(type) ? Adapter.class : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class Adapter
    extends BeanAdapterBase {
        private JTable table;
        private Handler handler;
        private Object cachedElementOrElements;

        private Adapter(JTable table, String property) {
            super(property);
            this.table = table;
        }

        private boolean isPlural() {
            return this.property == JTableAdapterProvider.SELECTED_ELEMENTS_P || this.property == JTableAdapterProvider.SELECTED_ELEMENTS_IA_P;
        }

        public Object getSelectedElement() {
            return JTableAdapterProvider.getSelectedElement(this.table);
        }

        public Object getSelectedElement_IGNORE_ADJUSTING() {
            return this.getSelectedElement();
        }

        public List<Object> getSelectedElements() {
            return JTableAdapterProvider.getSelectedElements(this.table);
        }

        public List<Object> getSelectedElements_IGNORE_ADJUSTING() {
            return this.getSelectedElements();
        }

        @Override
        protected void listeningStarted() {
            this.handler = new Handler();
            this.cachedElementOrElements = this.isPlural() ? this.getSelectedElements() : JTableAdapterProvider.getSelectedElement(this.table);
            this.table.addPropertyChangeListener("selectionModel", this.handler);
            this.table.getSelectionModel().addListSelectionListener(this.handler);
        }

        @Override
        protected void listeningStopped() {
            this.table.getSelectionModel().removeListSelectionListener(this.handler);
            this.table.removePropertyChangeListener("selectionModel", this.handler);
            this.cachedElementOrElements = null;
            this.handler = null;
        }

        private class Handler
        implements ListSelectionListener,
        PropertyChangeListener {
            private Handler() {
            }

            private void tableSelectionChanged() {
                Object oldElementOrElements = Adapter.this.cachedElementOrElements;
                Adapter.this.cachedElementOrElements = Adapter.this.getSelectedElements();
                Adapter.this.firePropertyChange(oldElementOrElements, Adapter.this.cachedElementOrElements);
            }

            public void valueChanged(ListSelectionEvent e2) {
                if ((Adapter.this.property == JTableAdapterProvider.SELECTED_ELEMENT_IA_P || Adapter.this.property == JTableAdapterProvider.SELECTED_ELEMENTS_IA_P) && e2.getValueIsAdjusting()) {
                    return;
                }
                this.tableSelectionChanged();
            }

            public void propertyChange(PropertyChangeEvent pce) {
                ((ListSelectionModel)pce.getOldValue()).removeListSelectionListener(Adapter.this.handler);
                ((ListSelectionModel)pce.getNewValue()).addListSelectionListener(Adapter.this.handler);
                this.tableSelectionChanged();
            }
        }
    }
}

