/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import toxi.geom.Ray3D;
import toxi.geom.ReadonlyVec3D;
import toxi.geom.Shape3D;
import toxi.geom.Sphere;
import toxi.geom.Triangle3D;
import toxi.geom.Vec3D;
import toxi.geom.mesh.Mesh3D;
import toxi.geom.mesh.TriangleMesh;
import toxi.math.MathUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class AABB
extends Vec3D
implements Shape3D {
    @XmlElement(required=true)
    protected Vec3D extent;
    @XmlTransient
    protected Vec3D min;
    @XmlTransient
    protected Vec3D max;

    public static final AABB fromMinMax(Vec3D vec3D, Vec3D vec3D2) {
        Vec3D vec3D3 = Vec3D.min(vec3D, vec3D2);
        Vec3D vec3D4 = Vec3D.max(vec3D, vec3D2);
        return new AABB((ReadonlyVec3D)vec3D3.interpolateTo(vec3D4, 0.5f), vec3D4.sub(vec3D3).scaleSelf(0.5f));
    }

    public AABB() {
        this.setExtent(new Vec3D());
    }

    public AABB(AABB aABB) {
        this((ReadonlyVec3D)aABB, aABB.getExtent());
    }

    public AABB(float f2) {
        this((ReadonlyVec3D)new Vec3D(), f2);
    }

    public AABB(ReadonlyVec3D readonlyVec3D, float f2) {
        super(readonlyVec3D);
        this.setExtent(new Vec3D(f2, f2, f2));
    }

    public AABB(ReadonlyVec3D readonlyVec3D, ReadonlyVec3D readonlyVec3D2) {
        super(readonlyVec3D);
        this.setExtent(readonlyVec3D2);
    }

    public boolean containsPoint(ReadonlyVec3D readonlyVec3D) {
        return readonlyVec3D.isInAABB(this);
    }

    public AABB copy() {
        return new AABB(this);
    }

    public final Vec3D getExtent() {
        return this.extent.copy();
    }

    public final Vec3D getMax() {
        return this.max.copy();
    }

    public final Vec3D getMin() {
        return this.min.copy();
    }

    public Vec3D getNormalForPoint(ReadonlyVec3D readonlyVec3D) {
        readonlyVec3D = readonlyVec3D.sub(this);
        Vec3D vec3D = this.extent.sub(readonlyVec3D.getAbs());
        Vec3D vec3D2 = readonlyVec3D.getSignum();
        Vec3D vec3D3 = Vec3D.X_AXIS.scale(vec3D2.x);
        float f2 = vec3D.x;
        if (vec3D.y < f2) {
            f2 = vec3D.y;
            vec3D3 = Vec3D.Y_AXIS.scale(vec3D2.y);
        }
        if (vec3D.z < f2) {
            vec3D3 = Vec3D.Z_AXIS.scale(vec3D2.z);
        }
        return vec3D3;
    }

    public AABB includePoint(ReadonlyVec3D readonlyVec3D) {
        this.min.minSelf(readonlyVec3D);
        this.max.maxSelf(readonlyVec3D);
        this.set(this.min.interpolateTo(this.max, 0.5f));
        this.extent.set(this.max.sub(this.min).scaleSelf(0.5f));
        return this;
    }

    public boolean intersectsBox(AABB aABB) {
        Vec3D vec3D = aABB.sub(this);
        return MathUtils.abs(vec3D.x) <= this.extent.x + aABB.extent.x && MathUtils.abs(vec3D.y) <= this.extent.y + aABB.extent.y && MathUtils.abs(vec3D.z) <= this.extent.z + aABB.extent.z;
    }

    public Vec3D intersectsRay(Ray3D ray3D, float f2, float f3) {
        Vec3D vec3D = ray3D.getDirection().reciprocal();
        boolean bl = vec3D.x < 0.0f;
        boolean bl2 = vec3D.y < 0.0f;
        boolean bl3 = vec3D.z < 0.0f;
        Vec3D vec3D2 = bl ? this.max : this.min;
        float f4 = (vec3D2.x - ray3D.x) * vec3D.x;
        vec3D2 = bl ? this.min : this.max;
        float f5 = (vec3D2.x - ray3D.x) * vec3D.x;
        vec3D2 = bl2 ? this.max : this.min;
        float f6 = (vec3D2.y - ray3D.y) * vec3D.y;
        vec3D2 = bl2 ? this.min : this.max;
        float f7 = (vec3D2.y - ray3D.y) * vec3D.y;
        if (f4 > f7 || f6 > f5) {
            return null;
        }
        if (f6 > f4) {
            f4 = f6;
        }
        if (f7 < f5) {
            f5 = f7;
        }
        vec3D2 = bl3 ? this.max : this.min;
        float f8 = (vec3D2.z - ray3D.z) * vec3D.z;
        vec3D2 = bl3 ? this.min : this.max;
        float f9 = (vec3D2.z - ray3D.z) * vec3D.z;
        if (f4 > f9 || f8 > f5) {
            return null;
        }
        if (f8 > f4) {
            f4 = f8;
        }
        if (f9 < f5) {
            f5 = f9;
        }
        if (f4 < f3 && f5 > f2) {
            return ray3D.getPointAtDistance(f4);
        }
        return null;
    }

    public boolean intersectsSphere(Sphere sphere) {
        return this.intersectsSphere(sphere, sphere.radius);
    }

    public boolean intersectsSphere(Vec3D vec3D, float f2) {
        float f3;
        float f4 = 0.0f;
        if (vec3D.x < this.min.x) {
            f3 = vec3D.x - this.min.x;
            f4 = f3 * f3;
        } else if (vec3D.x > this.max.x) {
            f3 = vec3D.x - this.max.x;
            f4 += f3 * f3;
        }
        if (vec3D.y < this.min.y) {
            f3 = vec3D.y - this.min.y;
            f4 += f3 * f3;
        } else if (vec3D.y > this.max.y) {
            f3 = vec3D.y - this.max.y;
            f4 += f3 * f3;
        }
        if (vec3D.z < this.min.z) {
            f3 = vec3D.z - this.min.z;
            f4 += f3 * f3;
        } else if (vec3D.z > this.max.z) {
            f3 = vec3D.z - this.max.z;
            f4 += f3 * f3;
        }
        return f4 <= f2 * f2;
    }

    public boolean intersectsTriangle(Triangle3D triangle3D) {
        float f2;
        Vec3D vec3D = triangle3D.a.sub(this);
        Vec3D vec3D2 = triangle3D.b.sub(this);
        Vec3D vec3D3 = triangle3D.c.sub(this);
        Vec3D vec3D4 = vec3D2.sub(vec3D);
        Vec3D vec3D5 = vec3D3.sub(vec3D2);
        Vec3D vec3D6 = vec3D.sub(vec3D3);
        Vec3D vec3D7 = vec3D4.getAbs();
        if (this.testAxis(vec3D4.z, -vec3D4.y, vec3D7.z, vec3D7.y, vec3D.y, vec3D.z, vec3D3.y, vec3D3.z, this.extent.y, this.extent.z)) {
            return false;
        }
        if (this.testAxis(-vec3D4.z, vec3D4.x, vec3D7.z, vec3D7.x, vec3D.x, vec3D.z, vec3D3.x, vec3D3.z, this.extent.x, this.extent.z)) {
            return false;
        }
        if (this.testAxis(vec3D4.y, -vec3D4.x, vec3D7.y, vec3D7.x, vec3D2.x, vec3D2.y, vec3D3.x, vec3D3.y, this.extent.x, this.extent.y)) {
            return false;
        }
        vec3D7 = vec3D5.getAbs();
        if (this.testAxis(vec3D5.z, -vec3D5.y, vec3D7.z, vec3D7.y, vec3D.y, vec3D.z, vec3D3.y, vec3D3.z, this.extent.y, this.extent.z)) {
            return false;
        }
        if (this.testAxis(-vec3D5.z, vec3D5.x, vec3D7.z, vec3D7.x, vec3D.x, vec3D.z, vec3D3.x, vec3D3.z, this.extent.x, this.extent.z)) {
            return false;
        }
        if (this.testAxis(vec3D5.y, -vec3D5.x, vec3D7.y, vec3D7.x, vec3D.x, vec3D.y, vec3D2.x, vec3D2.y, this.extent.x, this.extent.y)) {
            return false;
        }
        vec3D7 = vec3D6.getAbs();
        if (this.testAxis(vec3D6.z, -vec3D6.y, vec3D7.z, vec3D7.y, vec3D.y, vec3D.z, vec3D2.y, vec3D2.z, this.extent.y, this.extent.z)) {
            return false;
        }
        if (this.testAxis(-vec3D6.z, vec3D6.x, vec3D7.z, vec3D7.x, vec3D.x, vec3D.z, vec3D2.x, vec3D2.z, this.extent.x, this.extent.z)) {
            return false;
        }
        if (this.testAxis(vec3D6.y, -vec3D6.x, vec3D7.y, vec3D7.x, vec3D2.x, vec3D2.y, vec3D3.x, vec3D3.y, this.extent.x, this.extent.y)) {
            return false;
        }
        if (MathUtils.min(vec3D.x, vec3D2.x, vec3D3.x) > this.extent.x || MathUtils.max(vec3D.x, vec3D2.x, vec3D3.x) < -this.extent.x) {
            return false;
        }
        if (MathUtils.min(vec3D.y, vec3D2.y, vec3D3.y) > this.extent.y || MathUtils.max(vec3D.y, vec3D2.y, vec3D3.y) < -this.extent.y) {
            return false;
        }
        if (MathUtils.min(vec3D.z, vec3D2.z, vec3D3.z) > this.extent.z || MathUtils.max(vec3D.z, vec3D2.z, vec3D3.z) < -this.extent.z) {
            return false;
        }
        Vec3D vec3D8 = vec3D4.cross(vec3D5);
        return this.planeBoxOverlap(vec3D8, f2 = -vec3D8.dot(vec3D), this.extent);
    }

    private boolean planeBoxOverlap(Vec3D vec3D, float f2, Vec3D vec3D2) {
        Vec3D vec3D3 = new Vec3D();
        Vec3D vec3D4 = new Vec3D();
        if (vec3D.x > 0.0f) {
            vec3D3.x = -vec3D2.x;
            vec3D4.x = vec3D2.x;
        } else {
            vec3D3.x = vec3D2.x;
            vec3D4.x = -vec3D2.x;
        }
        if (vec3D.y > 0.0f) {
            vec3D3.y = -vec3D2.y;
            vec3D4.y = vec3D2.y;
        } else {
            vec3D3.y = vec3D2.y;
            vec3D4.y = -vec3D2.y;
        }
        if (vec3D.z > 0.0f) {
            vec3D3.z = -vec3D2.z;
            vec3D4.z = vec3D2.z;
        } else {
            vec3D3.z = vec3D2.z;
            vec3D4.z = -vec3D2.z;
        }
        if (vec3D.dot(vec3D3) + f2 > 0.0f) {
            return false;
        }
        return vec3D.dot(vec3D4) + f2 >= 0.0f;
    }

    public AABB set(AABB aABB) {
        this.extent.set(aABB.extent);
        return this.set((ReadonlyVec3D)aABB);
    }

    public Vec3D set(float f2, float f3, float f4) {
        this.x = f2;
        this.y = f3;
        this.z = f4;
        this.updateBounds();
        return this;
    }

    public AABB set(ReadonlyVec3D readonlyVec3D) {
        this.x = readonlyVec3D.x();
        this.y = readonlyVec3D.y();
        this.z = readonlyVec3D.z();
        this.updateBounds();
        return this;
    }

    public AABB setExtent(ReadonlyVec3D readonlyVec3D) {
        this.extent = readonlyVec3D.copy();
        return this.updateBounds();
    }

    private boolean testAxis(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11) {
        float f12;
        float f13;
        float f14 = f2 * f6 + f3 * f7;
        float f15 = f2 * f8 + f3 * f9;
        if (f14 < f15) {
            f13 = f14;
            f12 = f15;
        } else {
            f13 = f15;
            f12 = f14;
        }
        float f16 = f4 * f10 + f5 * f11;
        return f13 > f16 || f12 < -f16;
    }

    public Mesh3D toMesh() {
        return this.toMesh(null);
    }

    public Mesh3D toMesh(Mesh3D mesh3D) {
        if (mesh3D == null) {
            mesh3D = new TriangleMesh("aabb", 8, 12);
        }
        Vec3D vec3D = new Vec3D(this.min.x, this.max.y, this.max.z);
        Vec3D vec3D2 = new Vec3D(this.max.x, this.max.y, this.max.z);
        Vec3D vec3D3 = new Vec3D(this.max.x, this.min.y, this.max.z);
        Vec3D vec3D4 = new Vec3D(this.min.x, this.min.y, this.max.z);
        Vec3D vec3D5 = new Vec3D(this.min.x, this.max.y, this.min.z);
        Vec3D vec3D6 = new Vec3D(this.max.x, this.max.y, this.min.z);
        Vec3D vec3D7 = new Vec3D(this.max.x, this.min.y, this.min.z);
        Vec3D vec3D8 = new Vec3D(this.min.x, this.min.y, this.min.z);
        mesh3D.addFace(vec3D, vec3D2, vec3D4, null, null, null, null);
        mesh3D.addFace(vec3D2, vec3D3, vec3D4, null, null, null, null);
        mesh3D.addFace(vec3D6, vec3D5, vec3D7, null, null, null, null);
        mesh3D.addFace(vec3D5, vec3D8, vec3D7, null, null, null, null);
        mesh3D.addFace(vec3D5, vec3D6, vec3D, null, null, null, null);
        mesh3D.addFace(vec3D6, vec3D2, vec3D, null, null, null, null);
        mesh3D.addFace(vec3D7, vec3D8, vec3D4, null, null, null, null);
        mesh3D.addFace(vec3D7, vec3D4, vec3D3, null, null, null, null);
        mesh3D.addFace(vec3D5, vec3D, vec3D8, null, null, null, null);
        mesh3D.addFace(vec3D, vec3D4, vec3D8, null, null, null, null);
        mesh3D.addFace(vec3D2, vec3D6, vec3D7, null, null, null, null);
        mesh3D.addFace(vec3D2, vec3D7, vec3D3, null, null, null, null);
        return mesh3D;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<aabb> pos: ").append(super.toString()).append(" ext: ").append(this.extent);
        return stringBuffer.toString();
    }

    public final AABB updateBounds() {
        if (this.extent != null) {
            this.min = this.sub(this.extent);
            this.max = this.add(this.extent);
        }
        return this;
    }
}

