/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom;

import toxi.geom.Cone;
import toxi.geom.ReadonlyVec3D;
import toxi.geom.Shape3D;
import toxi.geom.Vec3D;
import toxi.geom.mesh.Mesh3D;

public abstract class AxisAlignedCylinder
implements Shape3D {
    protected Vec3D pos;
    protected float radius;
    protected float radiusSquared;
    protected float length;

    protected AxisAlignedCylinder(ReadonlyVec3D readonlyVec3D, float f2, float f3) {
        this.pos = readonlyVec3D.copy();
        this.setRadius(f2);
        this.setLength(f3);
    }

    public abstract boolean containsPoint(ReadonlyVec3D var1);

    public float getLength() {
        return this.length;
    }

    public abstract Vec3D.Axis getMajorAxis();

    public Vec3D getPosition() {
        return this.pos.copy();
    }

    public float getRadius() {
        return this.radius;
    }

    public void setLength(float f2) {
        this.length = f2;
    }

    public void setPosition(Vec3D vec3D) {
        this.pos.set(vec3D);
    }

    public void setRadius(float f2) {
        this.radius = f2;
        this.radiusSquared = f2 * f2;
    }

    public Mesh3D toMesh() {
        return this.toMesh(12, 0.0f);
    }

    public Mesh3D toMesh(int n, float f2) {
        return this.toMesh(null, n, f2);
    }

    public Mesh3D toMesh(Mesh3D mesh3D, int n, float f2) {
        return new Cone(this.pos, this.getMajorAxis().getVector(), this.radius, this.radius, this.length).toMesh(mesh3D, n, f2, true, true);
    }
}

