/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom;

public class BernsteinPolynomial {
    public float[] b0;
    public float[] b1;
    public float[] b2;
    public float[] b3;
    public int resolution;

    public BernsteinPolynomial(int n) {
        this.resolution = n;
        this.b0 = new float[n];
        this.b1 = new float[n];
        this.b2 = new float[n];
        this.b3 = new float[n];
        float f2 = 0.0f;
        float f3 = 1.0f / (float)(this.resolution - 1);
        for (int i = 0; i < this.resolution; ++i) {
            float f4 = 1.0f - f2;
            float f5 = f4 * f4;
            float f6 = f2 * f2;
            this.b0[i] = f4 * f5;
            this.b1[i] = 3.0f * f2 * f5;
            this.b2[i] = 3.0f * f6 * f4;
            this.b3[i] = f2 * f6;
            f2 += f3;
        }
    }
}

