/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom;

import toxi.geom.ReadonlyVec3D;
import toxi.geom.Vec3D;
import toxi.geom.mesh.Mesh3D;
import toxi.geom.mesh.TriangleMesh;

public class Cone
extends Vec3D {
    public Vec3D dir;
    public float radiusSouth;
    public float radiusNorth;
    public float length;

    public Cone(ReadonlyVec3D readonlyVec3D, ReadonlyVec3D readonlyVec3D2, float f2, float f3, float f4) {
        super(readonlyVec3D);
        this.dir = readonlyVec3D2.getNormalized();
        this.radiusNorth = f2;
        this.radiusSouth = f3;
        this.length = f4;
    }

    public Mesh3D toMesh(int n) {
        return this.toMesh(n, 0.0f);
    }

    public Mesh3D toMesh(int n, float f2) {
        return this.toMesh(null, n, f2, true, true);
    }

    public Mesh3D toMesh(Mesh3D mesh3D, int n, float f2, boolean bl, boolean bl2) {
        int n2;
        Vec3D vec3D = this.add(0.01f, 0.01f, 0.01f);
        Vec3D vec3D2 = vec3D.cross((ReadonlyVec3D)this.dir.getNormalized()).normalize();
        Vec3D vec3D3 = this.dir.scale(this.length * 0.5f);
        Vec3D vec3D4 = this.sub(vec3D3);
        Vec3D vec3D5 = this.add(vec3D3);
        Vec3D[] vec3DArray = new Vec3D[n];
        Vec3D[] vec3DArray2 = new Vec3D[n];
        float f3 = (float)Math.PI * 2 / (float)n;
        for (n2 = 0; n2 < n; ++n2) {
            float f4 = (float)n2 * f3 + f2;
            Vec3D vec3D6 = vec3D2.getRotatedAroundAxis(this.dir, f4);
            vec3DArray[n2] = vec3D6.scale(this.radiusSouth).addSelf(vec3D4);
            vec3DArray2[n2] = vec3D6.scale(this.radiusNorth).addSelf(vec3D5);
        }
        n2 = n * 2 + 2;
        int n3 = n * 2 + (bl ? n : 0) + (bl2 ? n : 0);
        if (mesh3D == null) {
            mesh3D = new TriangleMesh("cone", n2, n3);
        }
        int n4 = 0;
        int n5 = 1;
        while (n4 < n) {
            if (n5 == n) {
                n5 = 0;
            }
            mesh3D.addFace(vec3DArray[n4], vec3DArray2[n4], vec3DArray[n5], null, null, null, null);
            mesh3D.addFace(vec3DArray[n5], vec3DArray2[n4], vec3DArray2[n5], null, null, null, null);
            if (bl2) {
                mesh3D.addFace(vec3D4, vec3DArray[n4], vec3DArray[n5], null, null, null, null);
            }
            if (bl) {
                mesh3D.addFace(vec3DArray2[n4], vec3D5, vec3DArray2[n5], null, null, null, null);
            }
            ++n4;
            ++n5;
        }
        return mesh3D;
    }
}

