/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom;

import toxi.geom.Polygon2D;
import toxi.geom.ReadonlyVec2D;
import toxi.geom.ReadonlyVec3D;
import toxi.geom.Shape2D;
import toxi.geom.Vec2D;
import toxi.math.MathUtils;

public class Ellipse
extends Vec2D
implements Shape2D {
    protected Vec2D radius = new Vec2D();
    protected float focus;

    public Ellipse() {
        this(0.0f, 0.0f, 1.0f);
    }

    public Ellipse(float f2, float f3) {
        this(0.0f, 0.0f, f2, f3);
    }

    public Ellipse(float f2, float f3, float f4) {
        this(f2, f3, f4, f4);
    }

    public Ellipse(float f2, float f3, float f4, float f5) {
        super(f2, f3);
        this.setRadii(f4, f5);
    }

    public Ellipse(ReadonlyVec2D readonlyVec2D, float f2) {
        this(readonlyVec2D.x(), readonlyVec2D.y(), f2, f2);
    }

    public Ellipse(ReadonlyVec2D readonlyVec2D, ReadonlyVec2D readonlyVec2D2) {
        this(readonlyVec2D.x(), readonlyVec2D.y(), readonlyVec2D2.x(), readonlyVec2D2.y());
    }

    public boolean containsPoint(ReadonlyVec2D readonlyVec2D) {
        Vec2D[] vec2DArray = this.getFoci();
        return readonlyVec2D.distanceTo(vec2DArray[0]) + readonlyVec2D.distanceTo(vec2DArray[1]) < 2.0f * MathUtils.max(this.radius.x, this.radius.y);
    }

    public float getArea() {
        return (float)Math.PI * this.radius.x * this.radius.y;
    }

    public float getCircumference() {
        return (float)Math.sqrt(0.5 * (double)this.radius.magSquared()) * ((float)Math.PI * 2);
    }

    public Vec2D[] getFoci() {
        Vec2D[] vec2DArray = new Vec2D[2];
        if (this.radius.x > this.radius.y) {
            vec2DArray[0] = this.sub(this.focus, 0.0f);
            vec2DArray[1] = this.add(this.focus, 0.0f);
        } else {
            vec2DArray[0] = this.sub(0.0f, this.focus);
            vec2DArray[1] = this.add(0.0f, this.focus);
        }
        return vec2DArray;
    }

    public Vec2D getRadii() {
        return this.radius.copy();
    }

    public Ellipse setRadii(float f2, float f3) {
        this.radius.set(f2, f3);
        this.focus = this.radius.magnitude();
        return this;
    }

    public Ellipse setRadii(ReadonlyVec3D readonlyVec3D) {
        return this.setRadii(readonlyVec3D.x(), readonlyVec3D.y());
    }

    public Polygon2D toPolygon2D(int n) {
        Polygon2D polygon2D = new Polygon2D();
        float f2 = (float)Math.PI * 2 / (float)n;
        for (int i = 0; i < n; ++i) {
            polygon2D.add(Vec2D.fromTheta((float)i * f2).scaleSelf(this.radius).addSelf(this));
        }
        return polygon2D;
    }
}

