/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom;

import java.util.ArrayList;
import java.util.List;
import toxi.geom.Ray2D;
import toxi.geom.ReadonlyVec2D;
import toxi.geom.Vec2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Line2D {
    public Vec2D a;
    public Vec2D b;

    public static final List<Vec2D> splitIntoSegments(Vec2D vec2D, Vec2D vec2D2, float f2, List<Vec2D> list, boolean bl) {
        float f3;
        if (list == null) {
            list = new ArrayList<Vec2D>();
        }
        if (bl) {
            list.add(vec2D.copy());
        }
        if ((f3 = vec2D.distanceTo(vec2D2)) > f2) {
            Vec2D vec2D3 = vec2D.copy();
            Vec2D vec2D4 = vec2D2.sub(vec2D).limit(f2);
            while (f3 > f2) {
                vec2D3.addSelf(vec2D4);
                list.add(vec2D3.copy());
                f3 -= f2;
            }
        }
        list.add(vec2D2.copy());
        return list;
    }

    public Line2D(ReadonlyVec2D readonlyVec2D, ReadonlyVec2D readonlyVec2D2) {
        this.a = readonlyVec2D.copy();
        this.b = readonlyVec2D2.copy();
    }

    public Line2D(Vec2D vec2D, Vec2D vec2D2) {
        this.a = vec2D;
        this.b = vec2D2;
    }

    public Vec2D closestPointTo(ReadonlyVec2D readonlyVec2D) {
        Vec2D vec2D = this.b.sub(this.a);
        float f2 = readonlyVec2D.sub(this.a).dot(vec2D) / vec2D.magSquared();
        if (f2 < 0.0f) {
            return this.a.copy();
        }
        if (f2 > 1.0f) {
            return this.b.copy();
        }
        return this.a.add(vec2D.scaleSelf(f2));
    }

    public Line2D copy() {
        return new Line2D(this.a.copy(), this.b.copy());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Line2D)) {
            return false;
        }
        Line2D line2D = (Line2D)object;
        return !(!this.a.equals(line2D.a) && !this.a.equals(line2D.b) || !this.b.equals(line2D.b) && !this.b.equals(line2D.a));
    }

    public Vec2D getDirection() {
        return this.b.sub(this.a).normalize();
    }

    public float getLength() {
        return this.a.distanceTo(this.b);
    }

    public float getLengthSquared() {
        return this.a.distanceToSquared(this.b);
    }

    public Vec2D getMidPoint() {
        return this.a.add(this.b).scaleSelf(0.5f);
    }

    public Vec2D getNormal() {
        return this.b.sub(this.a).perpendicular();
    }

    public float getTheta() {
        return this.a.angleBetween(this.b, true);
    }

    public boolean hasEndPoint(Vec2D vec2D) {
        return this.a.equals(vec2D) || this.b.equals(vec2D);
    }

    public int hashCode() {
        return this.a.hashCode() + this.b.hashCode();
    }

    public LineIntersection intersectLine(Line2D line2D) {
        LineIntersection lineIntersection = null;
        float f2 = (line2D.b.y - line2D.a.y) * (this.b.x - this.a.x) - (line2D.b.x - line2D.a.x) * (this.b.y - this.a.y);
        float f3 = (line2D.b.x - line2D.a.x) * (this.a.y - line2D.a.y) - (line2D.b.y - line2D.a.y) * (this.a.x - line2D.a.x);
        float f4 = (this.b.x - this.a.x) * (this.a.y - line2D.a.y) - (this.b.y - this.a.y) * (this.a.x - line2D.a.x);
        if ((double)f2 != 0.0) {
            float f5 = f3 / f2;
            float f6 = f4 / f2;
            lineIntersection = f5 >= 0.0f && (double)f5 <= 1.0 && (double)f6 >= 0.0 && (double)f6 <= 1.0 ? new LineIntersection(LineIntersection.Type.INTERSECTING, this.a.interpolateTo(this.b, f5)) : new LineIntersection(LineIntersection.Type.NON_INTERSECTING, null);
        } else {
            lineIntersection = (double)f3 == 0.0 && (double)f4 == 0.0 ? new LineIntersection(LineIntersection.Type.COINCIDENT, null) : new LineIntersection(LineIntersection.Type.COINCIDENT, null);
        }
        return lineIntersection;
    }

    public Line2D offsetAndGrowBy(float f2, float f3, Vec2D vec2D) {
        Vec2D vec2D2 = this.getMidPoint();
        Vec2D vec2D3 = this.getDirection();
        Vec2D vec2D4 = vec2D3.getPerpendicular();
        if (vec2D != null && vec2D2.sub(vec2D).dot(vec2D4) < 0.0f) {
            vec2D4.invert();
        }
        vec2D4.normalizeTo(f2);
        this.a.addSelf(vec2D4);
        this.b.addSelf(vec2D4);
        vec2D3.scaleSelf(f3);
        this.a.subSelf(vec2D3);
        this.b.addSelf(vec2D3);
        return this;
    }

    public Line2D scale(float f2) {
        float f3 = (1.0f - f2) * 0.5f;
        Vec2D vec2D = this.a.interpolateTo(this.b, f3);
        this.b.interpolateToSelf(this.a, f3);
        this.a.set(vec2D);
        return this;
    }

    public Line2D set(Vec2D vec2D, Vec2D vec2D2) {
        this.a = vec2D;
        this.b = vec2D2;
        return this;
    }

    public List<Vec2D> splitIntoSegments(List<Vec2D> list, float f2, boolean bl) {
        return Line2D.splitIntoSegments(this.a, this.b, f2, list, bl);
    }

    public Ray2D toRay2D() {
        return new Ray2D(this.a.copy(), this.b.sub(this.a).normalize());
    }

    public static class LineIntersection {
        private final Type type;
        private final ReadonlyVec2D pos;

        public LineIntersection(Type type, ReadonlyVec2D readonlyVec2D) {
            this.type = type;
            this.pos = readonlyVec2D;
        }

        public Vec2D getPos() {
            return this.pos.copy();
        }

        public Type getType() {
            return this.type;
        }

        public String toString() {
            return "type: " + (Object)((Object)this.type) + " pos: " + this.pos;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            COINCIDENT,
            PARALLEL,
            NON_INTERSECTING,
            INTERSECTING;

        }
    }
}

