/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom;

import java.util.ArrayList;
import java.util.List;
import toxi.geom.Ray3D;
import toxi.geom.ReadonlyVec3D;
import toxi.geom.Vec3D;
import toxi.math.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Line3D {
    public Vec3D a;
    public Vec3D b;

    public static final List<Vec3D> splitIntoSegments(Vec3D vec3D, Vec3D vec3D2, float f2, List<Vec3D> list, boolean bl) {
        float f3;
        if (list == null) {
            list = new ArrayList<Vec3D>();
        }
        if (bl) {
            list.add(vec3D.copy());
        }
        if ((f3 = vec3D.distanceTo(vec3D2)) > f2) {
            Vec3D vec3D3 = vec3D.copy();
            Vec3D vec3D4 = vec3D2.sub(vec3D).limit(f2);
            while (f3 > f2) {
                vec3D3.addSelf(vec3D4);
                list.add(vec3D3.copy());
                f3 -= f2;
            }
        }
        list.add(vec3D2.copy());
        return list;
    }

    public Line3D(ReadonlyVec3D readonlyVec3D, ReadonlyVec3D readonlyVec3D2) {
        this.a = readonlyVec3D.copy();
        this.b = readonlyVec3D2.copy();
    }

    public Line3D(Vec3D vec3D, Vec3D vec3D2) {
        this.a = vec3D;
        this.b = vec3D2;
    }

    public LineIntersection closestLineTo(Line3D line3D) {
        Vec3D vec3D = line3D.a.sub(line3D.b);
        if (vec3D.isZeroVector()) {
            return new LineIntersection(LineIntersection.Type.NON_INTERSECTING);
        }
        Vec3D vec3D2 = this.b.sub(this.a);
        if (vec3D2.isZeroVector()) {
            return new LineIntersection(LineIntersection.Type.NON_INTERSECTING);
        }
        Vec3D vec3D3 = this.a.sub(line3D.a);
        float f2 = vec3D3.x * vec3D.x + vec3D3.y * vec3D.y + vec3D3.z * vec3D.z;
        float f3 = vec3D.x * vec3D2.x + vec3D.y * vec3D2.y + vec3D.z * vec3D2.z;
        float f4 = vec3D3.x * vec3D2.x + vec3D3.y * vec3D2.y + vec3D3.z * vec3D2.z;
        float f5 = vec3D2.x * vec3D2.x + vec3D2.y * vec3D2.y + vec3D2.z * vec3D2.z;
        float f6 = vec3D.x * vec3D.x + vec3D.y * vec3D.y + vec3D.z * vec3D.z;
        float f7 = f5 * f6 - f3 * f3;
        if (MathUtils.abs(f7) < 1.1920929E-7f) {
            return new LineIntersection(LineIntersection.Type.NON_INTERSECTING);
        }
        float f8 = f2 * f3 - f4 * f6;
        float f9 = f8 / f7;
        float f10 = (f2 + f3 * f9) / f6;
        Vec3D vec3D4 = this.a.add(vec3D2.scaleSelf(f9));
        Vec3D vec3D5 = line3D.a.add(vec3D.scaleSelf(f10));
        return new LineIntersection(LineIntersection.Type.INTERSECTING, new Line3D(vec3D4, vec3D5), f9, f10);
    }

    public Vec3D closestPointTo(ReadonlyVec3D readonlyVec3D) {
        Vec3D vec3D = this.b.sub(this.a);
        float f2 = readonlyVec3D.sub(this.a).dot(vec3D) / vec3D.magSquared();
        if (f2 < 0.0f) {
            return this.a.copy();
        }
        if (f2 > 1.0f) {
            return this.b.copy();
        }
        return this.a.add(vec3D.scaleSelf(f2));
    }

    public Line3D copy() {
        return new Line3D(this.a.copy(), this.b.copy());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Line3D)) {
            return false;
        }
        Line3D line3D = (Line3D)object;
        return !(!this.a.equals(line3D.a) && !this.a.equals(line3D.b) || !this.b.equals(line3D.b) && !this.b.equals(line3D.a));
    }

    public Vec3D getDirection() {
        return this.b.sub(this.a).normalize();
    }

    public float getLength() {
        return this.a.distanceTo(this.b);
    }

    public float getLengthSquared() {
        return this.a.distanceToSquared(this.b);
    }

    public Vec3D getMidPoint() {
        return this.a.add(this.b).scaleSelf(0.5f);
    }

    public Vec3D getNormal() {
        return this.b.cross(this.a);
    }

    public boolean hasEndPoint(Vec3D vec3D) {
        return this.a.equals(vec3D) || this.b.equals(vec3D);
    }

    public int hashCode() {
        return this.a.hashCode() + this.b.hashCode();
    }

    public Line3D offsetAndGrowBy(float f2, float f3, Vec3D vec3D) {
        Vec3D vec3D2 = this.getMidPoint();
        Vec3D vec3D3 = this.getDirection();
        Vec3D vec3D4 = this.a.cross(vec3D3).normalize();
        if (vec3D != null && vec3D2.sub(vec3D).dot(vec3D4) < 0.0f) {
            vec3D4.invert();
        }
        vec3D4.normalizeTo(f2);
        this.a.addSelf(vec3D4);
        this.b.addSelf(vec3D4);
        vec3D3.scaleSelf(f3);
        this.a.subSelf(vec3D3);
        this.b.addSelf(vec3D3);
        return this;
    }

    public Line3D set(ReadonlyVec3D readonlyVec3D, ReadonlyVec3D readonlyVec3D2) {
        this.a = readonlyVec3D.copy();
        this.b = readonlyVec3D2.copy();
        return this;
    }

    public Line3D set(Vec3D vec3D, Vec3D vec3D2) {
        this.a = vec3D;
        this.b = vec3D2;
        return this;
    }

    public List<Vec3D> splitIntoSegments(List<Vec3D> list, float f2, boolean bl) {
        return Line3D.splitIntoSegments(this.a, this.b, f2, list, bl);
    }

    public Ray3D toRay3D() {
        return new Ray3D(this.a.copy(), this.b.sub(this.a).normalize());
    }

    public String toString() {
        return this.a.toString() + " -> " + this.b.toString();
    }

    public static class LineIntersection {
        private final Type type;
        private final Line3D line;
        private float[] coeff;

        private LineIntersection(Type type) {
            this(type, null, 0.0f, 0.0f);
        }

        private LineIntersection(Type type, Line3D line3D, float f2, float f3) {
            this.type = type;
            this.line = line3D;
            this.coeff = new float[]{f2, f3};
        }

        public float[] getCoefficients() {
            return this.coeff;
        }

        public float getLength() {
            return this.line.getLength();
        }

        public Line3D getLine() {
            return this.line.copy();
        }

        public Type getType() {
            return this.type;
        }

        public boolean isIntersectionInside() {
            return this.type == Type.INTERSECTING && this.coeff[0] >= 0.0f && this.coeff[0] <= 1.0f && this.coeff[1] >= 0.0f && this.coeff[1] <= 1.0f;
        }

        public String toString() {
            return "type: " + (Object)((Object)this.type) + " line: " + this.line;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            NON_INTERSECTING,
            INTERSECTING;

        }
    }
}

