/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom;

import toxi.geom.ReadonlyVec3D;
import toxi.geom.Vec3D;

public class Matrix4x4 {
    private static final Matrix4x4 TEMP = new Matrix4x4();
    public double[][] matrix;
    protected double[] temp = new double[4];

    public Matrix4x4() {
        this.init();
        this.matrix[0][0] = 1.0;
        this.matrix[1][1] = 1.0;
        this.matrix[2][2] = 1.0;
        this.matrix[3][3] = 1.0;
    }

    public Matrix4x4(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16, double d17) {
        this.init();
        double[] dArray = this.matrix[0];
        dArray[0] = d2;
        dArray[1] = d3;
        dArray[2] = d4;
        dArray[3] = d5;
        dArray = this.matrix[1];
        dArray[0] = d6;
        dArray[1] = d7;
        dArray[2] = d8;
        dArray[3] = d9;
        dArray = this.matrix[2];
        dArray[0] = d10;
        dArray[1] = d11;
        dArray[2] = d12;
        dArray[3] = d13;
        dArray = this.matrix[3];
        dArray[0] = d14;
        dArray[1] = d15;
        dArray[2] = d16;
        dArray[3] = d17;
    }

    public Matrix4x4(double[] dArray) {
        if (dArray.length != 9 && dArray.length != 16) {
            throw new RuntimeException("Array.length must == 9 or 16");
        }
        this.init();
        if (dArray.length == 16) {
            this.matrix[0][0] = dArray[0];
            this.matrix[0][1] = dArray[1];
            this.matrix[0][2] = dArray[2];
            this.matrix[0][3] = dArray[3];
            this.matrix[1][0] = dArray[4];
            this.matrix[1][1] = dArray[5];
            this.matrix[1][2] = dArray[6];
            this.matrix[1][3] = dArray[7];
            this.matrix[2][0] = dArray[8];
            this.matrix[2][1] = dArray[9];
            this.matrix[2][2] = dArray[10];
            this.matrix[2][3] = dArray[11];
            this.matrix[3][0] = dArray[12];
            this.matrix[3][1] = dArray[13];
            this.matrix[3][2] = dArray[14];
            this.matrix[3][3] = dArray[15];
        } else {
            this.matrix[0][0] = dArray[0];
            this.matrix[0][1] = dArray[1];
            this.matrix[0][2] = dArray[2];
            this.matrix[1][0] = dArray[3];
            this.matrix[1][1] = dArray[4];
            this.matrix[1][2] = dArray[5];
            this.matrix[2][0] = dArray[6];
            this.matrix[2][1] = dArray[7];
            this.matrix[2][2] = dArray[8];
            this.matrix[3][0] = dArray[9];
            this.matrix[3][1] = dArray[10];
            this.matrix[3][2] = dArray[11];
            this.matrix[3][3] = 1.0;
        }
    }

    public Matrix4x4(Matrix4x4 matrix4x4) {
        this.init();
        for (int i = 0; i < 4; ++i) {
            double[] dArray = this.matrix[i];
            double[] dArray2 = matrix4x4.matrix[i];
            dArray[0] = dArray2[0];
            dArray[1] = dArray2[1];
            dArray[2] = dArray2[2];
            dArray[3] = dArray2[3];
        }
    }

    public Matrix4x4 add(Matrix4x4 matrix4x4) {
        Matrix4x4 matrix4x42 = new Matrix4x4(this);
        return matrix4x42.addSelf(matrix4x4);
    }

    public Matrix4x4 addSelf(Matrix4x4 matrix4x4) {
        for (int i = 0; i < 4; ++i) {
            double[] dArray = this.matrix[i];
            double[] dArray2 = matrix4x4.matrix[i];
            dArray[0] = dArray[0] + dArray2[0];
            dArray[1] = dArray[1] + dArray2[1];
            dArray[2] = dArray[2] + dArray2[2];
            dArray[3] = dArray[3] + dArray2[3];
        }
        return this;
    }

    public Vec3D applyTo(ReadonlyVec3D readonlyVec3D) {
        return this.applyToSelf(new Vec3D(readonlyVec3D));
    }

    public Vec3D applyToSelf(Vec3D vec3D) {
        for (int i = 0; i < 4; ++i) {
            double[] dArray = this.matrix[i];
            this.temp[i] = (double)vec3D.x * dArray[0] + (double)vec3D.y * dArray[1] + (double)vec3D.z * dArray[2] + dArray[3];
        }
        vec3D.set((float)this.temp[0], (float)this.temp[1], (float)this.temp[2]).scaleSelf((float)(1.0 / this.temp[3]));
        return vec3D;
    }

    public Matrix4x4 copy() {
        return new Matrix4x4(this);
    }

    public Matrix4x4 getInverted() {
        return new Matrix4x4(this).invert();
    }

    public Matrix4x4 getRotatedAroundAxis(ReadonlyVec3D readonlyVec3D, double d2) {
        return new Matrix4x4(this).rotateAroundAxis(readonlyVec3D, d2);
    }

    public Matrix4x4 getRotatedX(double d2) {
        return new Matrix4x4(this).rotateX(d2);
    }

    public Matrix4x4 getRotatedY(double d2) {
        return new Matrix4x4(this).rotateY(d2);
    }

    public Matrix4x4 getRotatedZ(double d2) {
        return new Matrix4x4(this).rotateZ(d2);
    }

    public Matrix4x4 getTransposed() {
        return new Matrix4x4(this).transpose();
    }

    public Matrix4x4 identity() {
        double[] dArray = this.matrix[0];
        dArray[3] = 0.0;
        dArray[2] = 0.0;
        dArray[1] = 0.0;
        dArray = this.matrix[1];
        dArray[3] = 0.0;
        dArray[2] = 0.0;
        dArray[0] = 0.0;
        dArray = this.matrix[2];
        dArray[3] = 0.0;
        dArray[1] = 0.0;
        dArray[0] = 0.0;
        dArray = this.matrix[3];
        dArray[2] = 0.0;
        dArray[1] = 0.0;
        dArray[0] = 0.0;
        this.matrix[0][0] = 1.0;
        this.matrix[1][1] = 1.0;
        this.matrix[2][2] = 1.0;
        this.matrix[3][3] = 1.0;
        return this;
    }

    private final void init() {
        this.matrix = new double[][]{new double[4], new double[4], new double[4], new double[4]};
    }

    public Matrix4x4 invert() {
        double[] dArray = new double[12];
        double[] dArray2 = new double[16];
        double[] dArray3 = new double[16];
        double[] dArray4 = this.toArray(null);
        for (int i = 0; i < 4; ++i) {
            int n = i << 2;
            dArray2[i] = dArray4[n];
            dArray2[i + 4] = dArray4[n + 1];
            dArray2[i + 8] = dArray4[n + 2];
            dArray2[i + 12] = dArray4[n + 3];
        }
        dArray[0] = dArray2[10] * dArray2[15];
        dArray[1] = dArray2[11] * dArray2[14];
        dArray[2] = dArray2[9] * dArray2[15];
        dArray[3] = dArray2[11] * dArray2[13];
        dArray[4] = dArray2[9] * dArray2[14];
        dArray[5] = dArray2[10] * dArray2[13];
        dArray[6] = dArray2[8] * dArray2[15];
        dArray[7] = dArray2[11] * dArray2[12];
        dArray[8] = dArray2[8] * dArray2[14];
        dArray[9] = dArray2[10] * dArray2[12];
        dArray[10] = dArray2[8] * dArray2[13];
        dArray[11] = dArray2[9] * dArray2[12];
        double d2 = dArray2[0];
        double d3 = dArray2[1];
        double d4 = dArray2[2];
        double d5 = dArray2[3];
        double d6 = dArray2[4];
        double d7 = dArray2[5];
        double d8 = dArray2[6];
        double d9 = dArray2[7];
        dArray3[0] = dArray[0] * d7 + dArray[3] * d8 + dArray[4] * d9;
        dArray3[0] = dArray3[0] - (dArray[1] * d7 + dArray[2] * d8 + dArray[5] * d9);
        dArray3[1] = dArray[1] * d6 + dArray[6] * d8 + dArray[9] * d9;
        dArray3[1] = dArray3[1] - (dArray[0] * d6 + dArray[7] * d8 + dArray[8] * d9);
        dArray3[2] = dArray[2] * d6 + dArray[7] * d7 + dArray[10] * d9;
        dArray3[2] = dArray3[2] - (dArray[3] * d6 + dArray[6] * d7 + dArray[11] * d9);
        dArray3[3] = dArray[5] * d6 + dArray[8] * d7 + dArray[11] * d8;
        dArray3[3] = dArray3[3] - (dArray[4] * d6 + dArray[9] * d7 + dArray[10] * d8);
        dArray3[4] = dArray[1] * d3 + dArray[2] * d4 + dArray[5] * d5;
        dArray3[4] = dArray3[4] - (dArray[0] * d3 + dArray[3] * d4 + dArray[4] * d5);
        dArray3[5] = dArray[0] * d2 + dArray[7] * d4 + dArray[8] * d5;
        dArray3[5] = dArray3[5] - (dArray[1] * d2 + dArray[6] * d4 + dArray[9] * d5);
        dArray3[6] = dArray[3] * d2 + dArray[6] * d3 + dArray[11] * d5;
        dArray3[6] = dArray3[6] - (dArray[2] * d2 + dArray[7] * d3 + dArray[10] * d5);
        dArray3[7] = dArray[4] * d2 + dArray[9] * d3 + dArray[10] * d4;
        dArray3[7] = dArray3[7] - (dArray[5] * d2 + dArray[8] * d3 + dArray[11] * d4);
        dArray[0] = d4 * d9;
        dArray[1] = d5 * d8;
        dArray[2] = d3 * d9;
        dArray[3] = d5 * d7;
        dArray[4] = d3 * d8;
        dArray[5] = d4 * d7;
        dArray[6] = d2 * d9;
        dArray[7] = d5 * d6;
        dArray[8] = d2 * d8;
        dArray[9] = d4 * d6;
        dArray[10] = d2 * d7;
        dArray[11] = d3 * d6;
        d2 = dArray2[8];
        d3 = dArray2[9];
        d4 = dArray2[10];
        d5 = dArray2[11];
        d6 = dArray2[12];
        d7 = dArray2[13];
        d8 = dArray2[14];
        d9 = dArray2[15];
        dArray3[8] = dArray[0] * d7 + dArray[3] * d8 + dArray[4] * d9;
        dArray3[8] = dArray3[8] - (dArray[1] * d7 + dArray[2] * d8 + dArray[5] * d9);
        dArray3[9] = dArray[1] * d6 + dArray[6] * d8 + dArray[9] * d9;
        dArray3[9] = dArray3[9] - (dArray[0] * d6 + dArray[7] * d8 + dArray[8] * d9);
        dArray3[10] = dArray[2] * d6 + dArray[7] * d7 + dArray[10] * d9;
        dArray3[10] = dArray3[10] - (dArray[3] * d6 + dArray[6] * d7 + dArray[11] * d9);
        dArray3[11] = dArray[5] * d6 + dArray[8] * d7 + dArray[11] * d8;
        dArray3[11] = dArray3[11] - (dArray[4] * d6 + dArray[9] * d7 + dArray[10] * d8);
        dArray3[12] = dArray[2] * d4 + dArray[5] * d5 + dArray[1] * d3;
        dArray3[12] = dArray3[12] - (dArray[4] * d5 + dArray[0] * d3 + dArray[3] * d4);
        dArray3[13] = dArray[8] * d5 + dArray[0] * d2 + dArray[7] * d4;
        dArray3[13] = dArray3[13] - (dArray[6] * d4 + dArray[9] * d5 + dArray[1] * d2);
        dArray3[14] = dArray[6] * d3 + dArray[11] * d5 + dArray[3] * d2;
        dArray3[14] = dArray3[14] - (dArray[10] * d5 + dArray[2] * d2 + dArray[7] * d3);
        dArray3[15] = dArray[10] * d4 + dArray[4] * d2 + dArray[9] * d3;
        dArray3[15] = dArray3[15] - (dArray[8] * d3 + dArray[11] * d4 + dArray[5] * d2);
        double d10 = 1.0 / (dArray2[0] * dArray3[0] + dArray2[1] * dArray3[1] + dArray2[2] * dArray3[2] + dArray2[3] * dArray3[3]);
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            double[] dArray5 = this.matrix[i];
            for (int j = 0; j < 4; ++j) {
                dArray5[j] = dArray3[n++] * d10;
            }
        }
        return this;
    }

    public Matrix4x4 multiply(double d2) {
        return new Matrix4x4(this).multiply(d2);
    }

    public Matrix4x4 multiply(Matrix4x4 matrix4x4) {
        return new Matrix4x4(this).multiplySelf(matrix4x4);
    }

    public Matrix4x4 multiplySelf(double d2) {
        for (int i = 0; i < 4; ++i) {
            double[] dArray = this.matrix[i];
            dArray[0] = dArray[0] * d2;
            dArray[1] = dArray[1] * d2;
            dArray[2] = dArray[2] * d2;
            dArray[3] = dArray[3] * d2;
        }
        return this;
    }

    public Matrix4x4 multiplySelf(Matrix4x4 matrix4x4) {
        double[] dArray = matrix4x4.matrix[0];
        double[] dArray2 = matrix4x4.matrix[1];
        double[] dArray3 = matrix4x4.matrix[2];
        double[] dArray4 = matrix4x4.matrix[3];
        for (int i = 0; i < 4; ++i) {
            double[] dArray5 = this.matrix[i];
            for (int j = 0; j < 4; ++j) {
                this.temp[j] = dArray5[0] * dArray[j] + dArray5[1] * dArray2[j] + dArray5[2] * dArray3[j] + dArray5[3] * dArray4[j];
            }
            dArray5[0] = this.temp[0];
            dArray5[1] = this.temp[1];
            dArray5[2] = this.temp[2];
            dArray5[3] = this.temp[3];
        }
        return this;
    }

    public Matrix4x4 rotateAroundAxis(ReadonlyVec3D readonlyVec3D, double d2) {
        double d3 = readonlyVec3D.x();
        double d4 = readonlyVec3D.y();
        double d5 = readonlyVec3D.z();
        double d6 = Math.sin(d2);
        double d7 = Math.cos(d2);
        double d8 = 1.0 - d7;
        double d9 = d8 * d3;
        double d10 = d8 * d4;
        TEMP.set(d9 * d3 + d7, d9 * d4 + d6 * d5, d9 * d5 - d6 * d4, 0.0, d9 * d4 - d6 * d5, d10 * d4 + d7, d10 * d5 + d6 * d3, 0.0, d9 * d5 + d6 * d4, d10 * d5 - d6 * d3, d8 * d5 * d5 + d7, 0.0, 0.0, 0.0, 0.0, 1.0);
        return this.multiplySelf(TEMP);
    }

    public Matrix4x4 rotateX(double d2) {
        TEMP.identity();
        double d3 = Math.cos(d2);
        Matrix4x4.TEMP.matrix[2][2] = d3;
        Matrix4x4.TEMP.matrix[1][1] = d3;
        Matrix4x4.TEMP.matrix[2][1] = Math.sin(d2);
        Matrix4x4.TEMP.matrix[1][2] = -Matrix4x4.TEMP.matrix[2][1];
        return this.multiplySelf(TEMP);
    }

    public Matrix4x4 rotateY(double d2) {
        TEMP.identity();
        double d3 = Math.cos(d2);
        Matrix4x4.TEMP.matrix[2][2] = d3;
        Matrix4x4.TEMP.matrix[0][0] = d3;
        Matrix4x4.TEMP.matrix[0][2] = Math.sin(d2);
        Matrix4x4.TEMP.matrix[2][0] = -Matrix4x4.TEMP.matrix[0][2];
        return this.multiplySelf(TEMP);
    }

    public Matrix4x4 rotateZ(double d2) {
        TEMP.identity();
        double d3 = Math.cos(d2);
        Matrix4x4.TEMP.matrix[1][1] = d3;
        Matrix4x4.TEMP.matrix[0][0] = d3;
        Matrix4x4.TEMP.matrix[1][0] = Math.sin(d2);
        Matrix4x4.TEMP.matrix[0][1] = -Matrix4x4.TEMP.matrix[1][0];
        return this.multiplySelf(TEMP);
    }

    public Matrix4x4 scale(double d2) {
        return new Matrix4x4(this).scaleSelf(d2);
    }

    public Matrix4x4 scale(double d2, double d3, double d4) {
        return new Matrix4x4(this).scaleSelf(d2, d3, d4);
    }

    public Matrix4x4 scale(ReadonlyVec3D readonlyVec3D) {
        return new Matrix4x4(this).scaleSelf(readonlyVec3D.x(), readonlyVec3D.y(), readonlyVec3D.z());
    }

    public Matrix4x4 scaleSelf(double d2) {
        return this.scaleSelf(d2, d2, d2);
    }

    public Matrix4x4 scaleSelf(double d2, double d3, double d4) {
        TEMP.identity();
        Matrix4x4.TEMP.matrix[0][0] = d2;
        Matrix4x4.TEMP.matrix[1][1] = d3;
        Matrix4x4.TEMP.matrix[2][2] = d4;
        return this.multiplySelf(TEMP);
    }

    public Matrix4x4 scaleSelf(ReadonlyVec3D readonlyVec3D) {
        return this.scaleSelf(readonlyVec3D.x(), readonlyVec3D.y(), readonlyVec3D.z());
    }

    public Matrix4x4 set(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16, double d17) {
        double[] dArray = this.matrix[0];
        dArray[0] = d2;
        dArray[1] = d3;
        dArray[2] = d4;
        dArray[3] = d5;
        dArray = this.matrix[1];
        dArray[0] = d6;
        dArray[1] = d7;
        dArray[2] = d8;
        dArray[3] = d9;
        dArray = this.matrix[2];
        dArray[0] = d10;
        dArray[1] = d11;
        dArray[2] = d12;
        dArray[3] = d13;
        dArray = this.matrix[3];
        dArray[0] = d14;
        dArray[1] = d15;
        dArray[2] = d16;
        dArray[3] = d17;
        return this;
    }

    public Matrix4x4 set(Matrix4x4 matrix4x4) {
        for (int i = 0; i < 4; ++i) {
            double[] dArray = this.matrix[i];
            double[] dArray2 = matrix4x4.matrix[i];
            dArray[0] = dArray2[0];
            dArray[1] = dArray2[1];
            dArray[2] = dArray2[2];
            dArray[3] = dArray2[3];
        }
        return this;
    }

    public Matrix4x4 sub(Matrix4x4 matrix4x4) {
        return new Matrix4x4(this).subSelf(matrix4x4);
    }

    public Matrix4x4 subSelf(Matrix4x4 matrix4x4) {
        for (int i = 0; i < 4; ++i) {
            double[] dArray = this.matrix[i];
            double[] dArray2 = matrix4x4.matrix[i];
            dArray[0] = dArray[0] - dArray2[0];
            dArray[1] = dArray[1] - dArray2[1];
            dArray[2] = dArray[2] - dArray2[2];
            dArray[3] = dArray[3] - dArray2[3];
        }
        return this;
    }

    public double[] toArray(double[] dArray) {
        if (dArray == null) {
            dArray = new double[16];
        }
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            double[] dArray2 = this.matrix[i];
            for (int j = 0; j < 4; ++j) {
                dArray[n++] = dArray2[j];
            }
        }
        return dArray;
    }

    public float[] toFloatArray(float[] fArray) {
        if (fArray == null) {
            fArray = new float[16];
        }
        double[] dArray = this.toArray(null);
        for (int i = 0; i < 16; ++i) {
            fArray[i] = (float)dArray[i];
        }
        return fArray;
    }

    public String toString() {
        return "| " + this.matrix[0][0] + " " + this.matrix[0][1] + " " + this.matrix[0][2] + " " + this.matrix[0][3] + " |\n" + "| " + this.matrix[1][0] + " " + this.matrix[1][1] + " " + this.matrix[1][2] + " " + this.matrix[1][3] + " |\n" + "| " + this.matrix[2][0] + " " + this.matrix[2][1] + " " + this.matrix[2][2] + " " + this.matrix[2][3] + " |\n" + "| " + this.matrix[3][0] + " " + this.matrix[3][1] + " " + this.matrix[3][2] + " " + this.matrix[3][3] + " |";
    }

    public float[] toTransposedFloatArray(float[] fArray) {
        if (fArray == null) {
            fArray = new float[16];
        }
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                fArray[n++] = (float)this.matrix[j][i];
            }
        }
        return fArray;
    }

    public Matrix4x4 translate(double d2, double d3, double d4) {
        return new Matrix4x4(this).translateSelf(d2, d3, d4);
    }

    public Matrix4x4 translate(ReadonlyVec3D readonlyVec3D) {
        return new Matrix4x4(this).translateSelf(readonlyVec3D.x(), readonlyVec3D.y(), readonlyVec3D.z());
    }

    public Matrix4x4 translateSelf(double d2, double d3, double d4) {
        TEMP.identity();
        Matrix4x4.TEMP.matrix[0][3] = d2;
        Matrix4x4.TEMP.matrix[1][3] = d3;
        Matrix4x4.TEMP.matrix[2][3] = d4;
        return this.multiplySelf(TEMP);
    }

    public Matrix4x4 translateSelf(ReadonlyVec3D readonlyVec3D) {
        return this.translateSelf(readonlyVec3D.x(), readonlyVec3D.y(), readonlyVec3D.z());
    }

    public Matrix4x4 transpose() {
        return this.set(this.matrix[0][0], this.matrix[1][0], this.matrix[2][0], this.matrix[3][0], this.matrix[0][1], this.matrix[1][1], this.matrix[2][1], this.matrix[3][1], this.matrix[0][2], this.matrix[1][2], this.matrix[2][2], this.matrix[3][2], this.matrix[0][3], this.matrix[1][3], this.matrix[2][3], this.matrix[3][3]);
    }
}

