/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import toxi.geom.Ray3D;
import toxi.geom.ReadonlyVec3D;
import toxi.geom.Shape3D;
import toxi.geom.Triangle3D;
import toxi.geom.Vec3D;
import toxi.geom.mesh.Mesh3D;
import toxi.geom.mesh.TriangleMesh;
import toxi.math.MathUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Plane
extends Vec3D
implements Shape3D {
    public static final Plane XY = new Plane(new Vec3D(), Vec3D.Z_AXIS);
    public static final Plane XZ = new Plane(new Vec3D(), Vec3D.Y_AXIS);
    public static final Plane YZ = new Plane(new Vec3D(), Vec3D.X_AXIS);
    @XmlElement(required=true)
    public Vec3D normal;

    public Plane() {
        this.normal = Vec3D.Y_AXIS.copy();
    }

    public Plane(Triangle3D triangle3D) {
        this(triangle3D.computeCentroid(), triangle3D.computeNormal());
    }

    public Plane(Vec3D vec3D, ReadonlyVec3D readonlyVec3D) {
        super(vec3D);
        this.normal = readonlyVec3D.getNormalized();
    }

    public Classifier classifyPoint(ReadonlyVec3D readonlyVec3D, float f2) {
        float f3 = this.sub(readonlyVec3D).normalize().dot(this.normal);
        if (f3 < -f2) {
            return Classifier.FRONT;
        }
        if (f3 > f2) {
            return Classifier.BACK;
        }
        return Classifier.ON_PLANE;
    }

    public boolean containsPoint(ReadonlyVec3D readonlyVec3D) {
        return this.classifyPoint(readonlyVec3D, 1.1920929E-7f) == Classifier.ON_PLANE;
    }

    public float getDistanceToPoint(Vec3D vec3D) {
        float f2 = -this.normal.dot(vec3D.sub(this));
        float f3 = this.normal.magSquared();
        Vec3D vec3D2 = vec3D.add(this.normal.scale(f2 / f3));
        return vec3D2.distanceTo(vec3D);
    }

    public ReadonlyVec3D getIntersectionWithRay(Ray3D ray3D) {
        float f2 = this.normal.dot(ray3D.getDirection());
        if (f2 > 1.1920929E-7f) {
            float f3 = this.normal.dot(this.sub(ray3D)) / f2;
            return ray3D.getPointAtDistance(f3);
        }
        return null;
    }

    public Vec3D getProjectedPoint(Vec3D vec3D) {
        Vec3D vec3D2 = this.normal.dot(this.sub(vec3D)) < 0.0f ? this.normal.getInverted() : this.normal;
        Vec3D vec3D3 = new Ray3D(vec3D, vec3D2).getPointAtDistance(this.getDistanceToPoint(vec3D));
        return vec3D3;
    }

    public float intersectRayDistance(Ray3D ray3D) {
        float f2 = -this.normal.dot(this);
        float f3 = this.normal.dot(ray3D) + f2;
        float f4 = this.normal.dot(ray3D.dir);
        if (MathUtils.abs(f4) < 1.1920929E-7f) {
            return -1.0f;
        }
        return -(f3 / f4);
    }

    public Mesh3D toMesh(float f2) {
        return this.toMesh(null, f2);
    }

    public Mesh3D toMesh(Mesh3D mesh3D, float f2) {
        if (mesh3D == null) {
            mesh3D = new TriangleMesh("plane", 4, 2);
        }
        Plane plane = this.equalsWithTolerance(Vec3D.ZERO, 0.01f) ? this.add(0.01f, 0.01f, 0.01f) : this;
        Vec3D vec3D = plane.cross((ReadonlyVec3D)this.normal).normalizeTo(f2 *= 0.5f);
        Vec3D vec3D2 = vec3D.cross(this.normal).normalizeTo(f2);
        Vec3D vec3D3 = this.add(vec3D).addSelf(vec3D2);
        Vec3D vec3D4 = this.add(vec3D).subSelf(vec3D2);
        Vec3D vec3D5 = this.sub(vec3D).subSelf(vec3D2);
        Vec3D vec3D6 = this.sub(vec3D).addSelf(vec3D2);
        mesh3D.addFace(vec3D3, vec3D6, vec3D4, null, null, null, null);
        mesh3D.addFace(vec3D4, vec3D6, vec3D5, null, null, null, null);
        return mesh3D;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("origin: ").append(super.toString()).append(" norm: ").append(this.normal.toString());
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Classifier {
        FRONT,
        BACK,
        ON_PLANE;

    }
}

