/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import toxi.geom.AABB;
import toxi.geom.Matrix4x4;
import toxi.geom.ReadonlyVec3D;
import toxi.geom.Sphere;
import toxi.geom.Vec3D;
import toxi.math.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointCloud
implements Iterable<Vec3D> {
    protected List<Vec3D> points;
    protected Vec3D min;
    protected Vec3D max;
    protected Vec3D centroid;
    protected float radiusSquared;

    public PointCloud() {
        this(100);
    }

    public PointCloud(int n) {
        this.points = new ArrayList<Vec3D>(n);
        this.clear();
    }

    public PointCloud addAll(List<? extends Vec3D> list) {
        for (Vec3D vec3D : list) {
            this.addPoint(vec3D);
        }
        return this;
    }

    public PointCloud addPoint(Vec3D vec3D) {
        this.points.add(vec3D);
        this.min.minSelf(vec3D);
        this.max.maxSelf(vec3D);
        this.centroid.set(this.min.add(this.max).scaleSelf(0.5f));
        this.radiusSquared = MathUtils.max(this.radiusSquared, vec3D.distanceToSquared(this.centroid));
        return this;
    }

    public PointCloud applyMatrix(Matrix4x4 matrix4x4) {
        for (Vec3D vec3D : this.points) {
            vec3D.set(matrix4x4.applyTo(vec3D));
        }
        this.updateBounds();
        return this;
    }

    public PointCloud center() {
        return this.center(null);
    }

    public PointCloud center(ReadonlyVec3D readonlyVec3D) {
        this.getCentroid();
        Vec3D vec3D = readonlyVec3D != null ? readonlyVec3D.sub(this.centroid) : this.centroid.getInverted();
        for (Vec3D vec3D2 : this.points) {
            vec3D2.addSelf(vec3D);
        }
        this.min.addSelf(vec3D);
        this.max.addSelf(vec3D);
        this.centroid.addSelf(vec3D);
        return this;
    }

    public PointCloud clear() {
        this.points.clear();
        this.min = Vec3D.MAX_VALUE.copy();
        this.max = Vec3D.MIN_VALUE.copy();
        this.centroid = new Vec3D();
        return this;
    }

    public PointCloud copy() {
        PointCloud pointCloud = new PointCloud(this.points.size());
        for (Vec3D vec3D : this.points) {
            pointCloud.addPoint(vec3D.copy());
        }
        return pointCloud;
    }

    public AABB getBoundingBox() {
        return AABB.fromMinMax(this.min, this.max);
    }

    public Sphere getBoundingSphere() {
        return new Sphere(this.getCentroid(), (float)Math.sqrt(this.radiusSquared));
    }

    public Vec3D getCentroid() {
        return this.centroid;
    }

    @Override
    public Iterator<Vec3D> iterator() {
        return this.points.iterator();
    }

    public boolean removePoint(ReadonlyVec3D readonlyVec3D) {
        return this.points.remove(readonlyVec3D);
    }

    public int size() {
        return this.points.size();
    }

    public PointCloud updateBounds() {
        this.min = Vec3D.MAX_VALUE.copy();
        this.max = Vec3D.MIN_VALUE.copy();
        for (Vec3D vec3D : this.points) {
            this.min.minSelf(vec3D);
            this.max.maxSelf(vec3D);
        }
        this.centroid.set(this.min.add(this.max).scaleSelf(0.5f));
        this.radiusSquared = 0.0f;
        for (Vec3D vec3D : this.points) {
            this.radiusSquared = MathUtils.max(this.radiusSquared, vec3D.distanceToSquared(this.centroid));
        }
        return this;
    }
}

