/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import toxi.geom.AABB;
import toxi.geom.ReadonlyVec3D;
import toxi.geom.Shape3D;
import toxi.geom.Sphere;
import toxi.geom.Vec3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointOctree
extends AABB
implements Shape3D {
    protected float minNodeSize = 4.0f;
    protected PointOctree parent;
    protected PointOctree[] children;
    protected byte numChildren;
    protected ArrayList<Vec3D> points;
    protected float size;
    protected float halfSize;
    protected Vec3D offset;
    private int depth = 0;
    private boolean isAutoReducing = false;

    private PointOctree(PointOctree pointOctree, Vec3D vec3D, float f2) {
        super((ReadonlyVec3D)vec3D.add(f2, f2, f2), new Vec3D(f2, f2, f2));
        this.parent = pointOctree;
        this.halfSize = f2;
        this.size = f2 * 2.0f;
        this.offset = vec3D;
        this.numChildren = 0;
        if (this.parent != null) {
            this.depth = this.parent.depth + 1;
            this.minNodeSize = this.parent.minNodeSize;
        }
    }

    public PointOctree(Vec3D vec3D, float f2) {
        this(null, vec3D, f2 / 2.0f);
    }

    public boolean addAll(Collection<Vec3D> collection) {
        boolean bl = true;
        for (Vec3D vec3D : collection) {
            bl &= this.addPoint(vec3D);
        }
        return bl;
    }

    public boolean addPoint(Vec3D vec3D) {
        if (this.containsPoint(vec3D)) {
            int n;
            if (this.halfSize <= this.minNodeSize) {
                if (this.points == null) {
                    this.points = new ArrayList();
                }
                this.points.add(vec3D);
                return true;
            }
            Vec3D vec3D2 = vec3D.sub(this.offset);
            if (this.children == null) {
                this.children = new PointOctree[8];
            }
            if (this.children[n = this.getOctantID(vec3D2)] == null) {
                Vec3D vec3D3 = this.offset.add(new Vec3D((n & 1) != 0 ? this.halfSize : 0.0f, (n & 2) != 0 ? this.halfSize : 0.0f, (n & 4) != 0 ? this.halfSize : 0.0f));
                this.children[n] = new PointOctree(this, vec3D3, this.halfSize * 0.5f);
                this.numChildren = (byte)(this.numChildren + 1);
            }
            return this.children[n].addPoint(vec3D);
        }
        return false;
    }

    @Override
    public boolean containsPoint(ReadonlyVec3D readonlyVec3D) {
        return readonlyVec3D.isInAABB(this);
    }

    public void empty() {
        this.numChildren = 0;
        this.children = null;
        this.points = null;
    }

    public PointOctree[] getChildren() {
        PointOctree[] pointOctreeArray = new PointOctree[8];
        System.arraycopy(this.children, 0, pointOctreeArray, 0, 8);
        return pointOctreeArray;
    }

    public int getDepth() {
        return this.depth;
    }

    public PointOctree getLeafForPoint(ReadonlyVec3D readonlyVec3D) {
        if (readonlyVec3D.isInAABB(this)) {
            if (this.numChildren > 0) {
                int n = this.getOctantID(readonlyVec3D.sub(this.offset));
                if (this.children[n] != null) {
                    return this.children[n].getLeafForPoint(readonlyVec3D);
                }
            } else if (this.points != null) {
                return this;
            }
        }
        return null;
    }

    public float getMinNodeSize() {
        return this.minNodeSize;
    }

    public float getNodeSize() {
        return this.size;
    }

    public int getNumChildren() {
        return this.numChildren;
    }

    protected final int getOctantID(Vec3D vec3D) {
        return (vec3D.x >= this.halfSize ? 1 : 0) + (vec3D.y >= this.halfSize ? 2 : 0) + (vec3D.z >= this.halfSize ? 4 : 0);
    }

    public ReadonlyVec3D getOffset() {
        return this.offset;
    }

    public PointOctree getParent() {
        return this.parent;
    }

    public List<Vec3D> getPoints() {
        ArrayList<Vec3D> arrayList = null;
        if (this.points != null) {
            arrayList = new ArrayList<Vec3D>(this.points);
        } else if (this.numChildren > 0) {
            for (int i = 0; i < 8; ++i) {
                List<Vec3D> list;
                if (this.children[i] == null || (list = this.children[i].getPoints()) == null) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.addAll(list);
            }
        }
        return arrayList;
    }

    public ArrayList<Vec3D> getPointsWithinBox(AABB aABB) {
        ArrayList<Vec3D> arrayList;
        block4: {
            block5: {
                arrayList = null;
                if (!this.intersectsBox(aABB)) break block4;
                if (this.points == null) break block5;
                for (Vec3D vec3D : this.points) {
                    if (!vec3D.isInAABB(aABB)) continue;
                    if (arrayList == null) {
                        arrayList = new ArrayList<Vec3D>();
                    }
                    arrayList.add(vec3D);
                }
                break block4;
            }
            if (this.numChildren <= 0) break block4;
            for (int i = 0; i < 8; ++i) {
                ArrayList<Vec3D> arrayList2;
                if (this.children[i] == null || (arrayList2 = this.children[i].getPointsWithinBox(aABB)) == null) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.addAll(arrayList2);
            }
        }
        return arrayList;
    }

    public ArrayList<Vec3D> getPointsWithinSphere(Sphere sphere) {
        ArrayList<Vec3D> arrayList;
        block4: {
            block5: {
                arrayList = null;
                if (!this.intersectsSphere(sphere)) break block4;
                if (this.points == null) break block5;
                for (Vec3D vec3D : this.points) {
                    if (!sphere.containsPoint(vec3D)) continue;
                    if (arrayList == null) {
                        arrayList = new ArrayList<Vec3D>();
                    }
                    arrayList.add(vec3D);
                }
                break block4;
            }
            if (this.numChildren <= 0) break block4;
            for (int i = 0; i < 8; ++i) {
                ArrayList<Vec3D> arrayList2;
                if (this.children[i] == null || (arrayList2 = this.children[i].getPointsWithinSphere(sphere)) == null) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.addAll(arrayList2);
            }
        }
        return arrayList;
    }

    public ArrayList<Vec3D> getPointsWithinSphere(Vec3D vec3D, float f2) {
        return this.getPointsWithinSphere(new Sphere(vec3D, f2));
    }

    public float getSize() {
        return this.size;
    }

    private void reduceBranch() {
        if (this.points != null && this.points.size() == 0) {
            this.points = null;
        }
        if (this.numChildren > 0) {
            for (int i = 0; i < 8; ++i) {
                if (this.children[i] == null || this.children[i].points != null) continue;
                this.children[i] = null;
            }
        }
        if (this.parent != null) {
            this.parent.reduceBranch();
        }
    }

    public boolean remove(ReadonlyVec3D readonlyVec3D) {
        boolean bl = false;
        PointOctree pointOctree = this.getLeafForPoint(readonlyVec3D);
        if (pointOctree != null && pointOctree.points.remove(readonlyVec3D)) {
            bl = true;
            if (this.isAutoReducing && pointOctree.points.size() == 0) {
                pointOctree.reduceBranch();
            }
        }
        return bl;
    }

    public void removeAll(Collection<Vec3D> collection) {
        for (Vec3D vec3D : collection) {
            this.remove(vec3D);
        }
    }

    public void setMinNodeSize(float f2) {
        this.minNodeSize = f2 * 0.5f;
    }

    public void setTreeAutoReduction(boolean bl) {
        this.isAutoReducing = bl;
    }

    @Override
    public String toString() {
        return "<octree> offset: " + super.toString() + " size: " + this.size;
    }
}

