/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import toxi.geom.ReadonlyVec2D;
import toxi.geom.Rect;
import toxi.geom.Shape2D;
import toxi.geom.Vec2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointQuadtree
extends Rect
implements Shape2D {
    protected float minNodeSize = 4.0f;
    protected PointQuadtree parent;
    protected PointQuadtree[] children;
    protected ArrayList<Vec2D> points;
    protected final int depth;
    protected int numChildren;
    protected float size;
    protected float halfSize;
    protected Vec2D offset;
    protected boolean isAutoReducing = false;

    private PointQuadtree(PointQuadtree pointQuadtree, Vec2D vec2D, float f2) {
        super(vec2D.x, vec2D.y, f2, f2);
        this.parent = pointQuadtree;
        this.size = f2;
        this.halfSize = f2 / 2.0f;
        this.offset = vec2D;
        this.numChildren = 0;
        if (this.parent != null) {
            this.depth = this.parent.depth + 1;
            this.minNodeSize = this.parent.minNodeSize;
        } else {
            this.depth = 0;
        }
    }

    public PointQuadtree(Vec2D vec2D, float f2) {
        this(null, vec2D, f2);
    }

    public boolean addAll(Collection<Vec2D> collection) {
        boolean bl = true;
        for (Vec2D vec2D : collection) {
            bl &= this.addPoint(vec2D);
        }
        return bl;
    }

    public boolean addPoint(Vec2D vec2D) {
        if (this.containsPoint(vec2D)) {
            int n;
            if (this.halfSize <= this.minNodeSize) {
                if (this.points == null) {
                    this.points = new ArrayList();
                }
                this.points.add(vec2D);
                return true;
            }
            Vec2D vec2D2 = vec2D.sub(this.offset);
            if (this.children == null) {
                this.children = new PointQuadtree[4];
            }
            if (this.children[n = this.getQuadrantID(vec2D2)] == null) {
                Vec2D vec2D3 = this.offset.add(new Vec2D((n & 1) != 0 ? this.halfSize : 0.0f, (n & 2) != 0 ? this.halfSize : 0.0f));
                this.children[n] = new PointQuadtree(this, vec2D3, this.halfSize);
                ++this.numChildren;
            }
            return this.children[n].addPoint(vec2D);
        }
        return false;
    }

    @Override
    public boolean containsPoint(ReadonlyVec2D readonlyVec2D) {
        return readonlyVec2D.isInRectangle(this);
    }

    public void empty() {
        this.numChildren = 0;
        this.children = null;
        this.points = null;
    }

    public PointQuadtree[] getChildren() {
        PointQuadtree[] pointQuadtreeArray = new PointQuadtree[4];
        System.arraycopy(this.children, 0, pointQuadtreeArray, 0, 4);
        return pointQuadtreeArray;
    }

    public int getDepth() {
        return this.depth;
    }

    public PointQuadtree getLeafForPoint(ReadonlyVec2D readonlyVec2D) {
        if (readonlyVec2D.isInRectangle(this)) {
            if (this.numChildren > 0) {
                int n = this.getQuadrantID(readonlyVec2D.sub(this.offset));
                if (this.children[n] != null) {
                    return this.children[n].getLeafForPoint(readonlyVec2D);
                }
            } else if (this.points != null) {
                return this;
            }
        }
        return null;
    }

    public float getMinNodeSize() {
        return this.minNodeSize;
    }

    public float getNodeSize() {
        return this.size;
    }

    public int getNumChildren() {
        return this.numChildren;
    }

    public ReadonlyVec2D getOffset() {
        return this.offset;
    }

    public PointQuadtree getParent() {
        return this.parent;
    }

    public List<Vec2D> getPoints() {
        ArrayList<Vec2D> arrayList = null;
        if (this.points != null) {
            arrayList = new ArrayList<Vec2D>(this.points);
        } else if (this.numChildren > 0) {
            for (int i = 0; i < 8; ++i) {
                List<Vec2D> list;
                if (this.children[i] == null || (list = this.children[i].getPoints()) == null) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.addAll(list);
            }
        }
        return arrayList;
    }

    public ArrayList<Vec2D> getPointsWithinRect(Rect rect) {
        ArrayList<Vec2D> arrayList;
        block4: {
            block5: {
                arrayList = null;
                if (!this.intersectsRect(rect)) break block4;
                if (this.points == null) break block5;
                for (Vec2D vec2D : this.points) {
                    if (!vec2D.isInRectangle(rect)) continue;
                    if (arrayList == null) {
                        arrayList = new ArrayList<Vec2D>();
                    }
                    arrayList.add(vec2D);
                }
                break block4;
            }
            if (this.numChildren <= 0) break block4;
            for (int i = 0; i < this.children.length; ++i) {
                ArrayList<Vec2D> arrayList2;
                if (this.children[i] == null || (arrayList2 = this.children[i].getPointsWithinRect(rect)) == null) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.addAll(arrayList2);
            }
        }
        return arrayList;
    }

    protected final int getQuadrantID(Vec2D vec2D) {
        return (vec2D.x > this.halfSize ? 1 : 0) + (vec2D.y > this.halfSize ? 2 : 0);
    }

    public float getSize() {
        return this.size;
    }

    private void reduceBranch() {
        if (this.points != null && this.points.size() == 0) {
            this.points = null;
        }
        if (this.numChildren > 0) {
            for (int i = 0; i < this.children.length; ++i) {
                if (this.children[i] == null || this.children[i].points != null) continue;
                this.children[i] = null;
            }
        }
        if (this.parent != null) {
            this.parent.reduceBranch();
        }
    }

    public boolean remove(ReadonlyVec2D readonlyVec2D) {
        boolean bl = false;
        PointQuadtree pointQuadtree = this.getLeafForPoint(readonlyVec2D);
        if (pointQuadtree != null && pointQuadtree.points.remove(readonlyVec2D)) {
            bl = true;
            if (this.isAutoReducing && pointQuadtree.points.size() == 0) {
                pointQuadtree.reduceBranch();
            }
        }
        return bl;
    }

    public void removeAll(Collection<Vec2D> collection) {
        for (Vec2D vec2D : collection) {
            this.remove(vec2D);
        }
    }

    public void setMinNodeSize(float f2) {
        this.minNodeSize = f2 * 0.5f;
    }

    public void setTreeAutoReduction(boolean bl) {
        this.isAutoReducing = bl;
    }

    @Override
    public String toString() {
        return "<quadtree> offset: " + super.toString() + " size: " + this.size;
    }
}

