/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import toxi.geom.Matrix4x4;
import toxi.geom.ReadonlyVec3D;
import toxi.geom.Vec3D;
import toxi.math.InterpolateStrategy;
import toxi.math.MathUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Quaternion {
    public static final float DOT_THRESHOLD = 0.9995f;
    @XmlAttribute(required=true)
    public float x;
    @XmlAttribute(required=true)
    public float y;
    @XmlAttribute(required=true)
    public float z;
    @XmlAttribute(required=true)
    public float w;

    public static Quaternion createFromAxisAngle(ReadonlyVec3D readonlyVec3D, float f2) {
        f2 = (float)((double)f2 * 0.5);
        float f3 = MathUtils.sin(f2);
        float f4 = MathUtils.cos(f2);
        Quaternion quaternion = new Quaternion(f4, readonlyVec3D.getNormalizedTo(f3));
        return quaternion;
    }

    public static Quaternion createFromEuler(float f2, float f3, float f4) {
        f2 = (float)((double)f2 * 0.5);
        f3 = (float)((double)f3 * 0.5);
        f4 = (float)((double)f4 * 0.5);
        float f5 = MathUtils.sin(f2);
        float f6 = MathUtils.cos(f2);
        float f7 = MathUtils.sin(f3);
        float f8 = MathUtils.cos(f3);
        float f9 = MathUtils.sin(f4);
        float f10 = MathUtils.cos(f4);
        float f11 = f6 * f8;
        float f12 = f5 * f7;
        Quaternion quaternion = new Quaternion();
        quaternion.x = f9 * f11 - f10 * f12;
        quaternion.y = f10 * f5 * f8 + f9 * f6 * f7;
        quaternion.z = f10 * f6 * f7 - f9 * f5 * f8;
        quaternion.w = f10 * f11 + f9 * f12;
        return quaternion;
    }

    public static Quaternion createFromMatrix(Matrix4x4 matrix4x4) {
        double d2 = 0.0;
        double[] dArray = new double[4];
        double d3 = matrix4x4.matrix[0][0] + matrix4x4.matrix[1][1] + matrix4x4.matrix[2][2];
        if (d3 > 0.0) {
            d2 = Math.sqrt(d3 + 1.0);
            dArray[3] = d2 * 0.5;
            d2 = 0.5 / d2;
            dArray[0] = (matrix4x4.matrix[1][2] - matrix4x4.matrix[2][1]) * d2;
            dArray[1] = (matrix4x4.matrix[2][0] - matrix4x4.matrix[0][2]) * d2;
            dArray[2] = (matrix4x4.matrix[0][1] - matrix4x4.matrix[1][0]) * d2;
        } else {
            int[] nArray = new int[]{1, 2, 0};
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            if (matrix4x4.matrix[1][1] > matrix4x4.matrix[0][0]) {
                n = 1;
            }
            if (matrix4x4.matrix[2][2] > matrix4x4.matrix[n][n]) {
                n = 2;
            }
            n2 = nArray[n];
            n3 = nArray[n2];
            d2 = Math.sqrt(matrix4x4.matrix[n][n] - (matrix4x4.matrix[n2][n2] + matrix4x4.matrix[n3][n3]) + 1.0);
            dArray[n] = d2 * 0.5;
            d2 = 0.5 / d2;
            dArray[3] = (matrix4x4.matrix[n2][n3] - matrix4x4.matrix[n3][n2]) * d2;
            dArray[n2] = (matrix4x4.matrix[n][n2] + matrix4x4.matrix[n2][n]) * d2;
            dArray[n3] = (matrix4x4.matrix[n][n3] + matrix4x4.matrix[n3][n]) * d2;
        }
        return new Quaternion((float)dArray[3], (float)dArray[0], (float)dArray[1], (float)dArray[2]);
    }

    public static Quaternion getAlignmentQuat(ReadonlyVec3D readonlyVec3D, ReadonlyVec3D readonlyVec3D2) {
        Vec3D vec3D = readonlyVec3D.getNormalized();
        Vec3D vec3D2 = readonlyVec3D2.cross(vec3D);
        float f2 = vec3D2.magnitude() + 1.0E-4f;
        float f3 = (float)Math.atan2(f2, readonlyVec3D2.dot(vec3D));
        return Quaternion.createFromAxisAngle(vec3D2, f3);
    }

    public Quaternion() {
        this.identity();
    }

    public Quaternion(float f2, float f3, float f4, float f5) {
        this.w = f2;
        this.x = f3;
        this.y = f4;
        this.z = f5;
    }

    public Quaternion(float f2, ReadonlyVec3D readonlyVec3D) {
        this.x = readonlyVec3D.x();
        this.y = readonlyVec3D.y();
        this.z = readonlyVec3D.z();
        this.w = f2;
    }

    public Quaternion(Quaternion quaternion) {
        this.w = quaternion.w;
        this.x = quaternion.x;
        this.y = quaternion.y;
        this.z = quaternion.z;
    }

    public Quaternion add(Quaternion quaternion) {
        return new Quaternion(this.x + quaternion.x, this.y + quaternion.y, this.z + quaternion.z, this.w + quaternion.w);
    }

    public Quaternion addSelf(Quaternion quaternion) {
        this.x += quaternion.x;
        this.y += quaternion.y;
        this.z += quaternion.z;
        this.w += quaternion.w;
        return this;
    }

    public Quaternion copy() {
        return new Quaternion(this.w, this.x, this.y, this.z);
    }

    public float dot(Quaternion quaternion) {
        return this.x * quaternion.x + this.y * quaternion.y + this.z * quaternion.z + this.w * quaternion.w;
    }

    public Quaternion getConjugate() {
        Quaternion quaternion = new Quaternion();
        quaternion.x = -this.x;
        quaternion.y = -this.y;
        quaternion.z = -this.z;
        quaternion.w = this.w;
        return quaternion;
    }

    @Deprecated
    public Matrix4x4 getMatrix() {
        return this.toMatrix4x4();
    }

    public Quaternion getNormalized() {
        return new Quaternion(this).normalize();
    }

    public Quaternion identity() {
        this.w = 1.0f;
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        return this;
    }

    public Quaternion interpolateTo(Quaternion quaternion, float f2) {
        return this.copy().interpolateToSelf(quaternion, f2);
    }

    public Quaternion interpolateTo(Quaternion quaternion, float f2, InterpolateStrategy interpolateStrategy) {
        return this.copy().interpolateToSelf(quaternion, interpolateStrategy.interpolate(0.0f, 1.0f, f2));
    }

    public Quaternion interpolateToSelf(Quaternion quaternion, float f2) {
        float f3;
        float f4;
        float f5 = MathUtils.clip(this.dot(quaternion), -1.0f, 1.0f);
        if (1.0 - (double)f5 >= 1.1920928955078125E-7) {
            double d2 = Math.acos(f5);
            double d3 = 1.0 / Math.sin(d2);
            f4 = (float)(Math.sin(d2 * (1.0 - (double)f2)) * d3);
            f3 = (float)(Math.sin(d2 * (double)f2) * d3);
        } else {
            f4 = 1.0f - f2;
            f3 = f2;
        }
        if ((double)f5 < 0.0) {
            this.w = f4 * this.w - f3 * quaternion.w;
            this.x = f4 * this.x - f3 * quaternion.x;
            this.y = f4 * this.y - f3 * quaternion.y;
            this.z = f4 * this.z - f3 * quaternion.z;
        } else {
            this.w = f4 * this.w + f3 * quaternion.w;
            this.x = f4 * this.x + f3 * quaternion.x;
            this.y = f4 * this.y + f3 * quaternion.y;
            this.z = f4 * this.z + f3 * quaternion.z;
        }
        return this;
    }

    public Quaternion interpolateToSelf(Quaternion quaternion, float f2, InterpolateStrategy interpolateStrategy) {
        return this.interpolateToSelf(quaternion, interpolateStrategy.interpolate(0.0f, 1.0f, f2));
    }

    public float magnitude() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
    }

    public Quaternion multiply(Quaternion quaternion) {
        Quaternion quaternion2 = new Quaternion();
        quaternion2.w = this.w * quaternion.w - this.x * quaternion.x - this.y * quaternion.y - this.z * quaternion.z;
        quaternion2.x = this.w * quaternion.x + this.x * quaternion.w + this.y * quaternion.z - this.z * quaternion.y;
        quaternion2.y = this.w * quaternion.y + this.y * quaternion.w + this.z * quaternion.x - this.x * quaternion.z;
        quaternion2.z = this.w * quaternion.z + this.z * quaternion.w + this.x * quaternion.y - this.y * quaternion.x;
        return quaternion2;
    }

    public Quaternion normalize() {
        float f2 = (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
        if (f2 > 1.1920929E-7f) {
            f2 = 1.0f / f2;
            this.x *= f2;
            this.y *= f2;
            this.z *= f2;
            this.w *= f2;
        }
        return this;
    }

    public Quaternion scale(float f2) {
        return new Quaternion(this.x * f2, this.y * f2, this.z * f2, this.w * f2);
    }

    public Quaternion scaleSelf(float f2) {
        this.x *= f2;
        this.y *= f2;
        this.z *= f2;
        this.w *= f2;
        return this;
    }

    public Quaternion set(float f2, float f3, float f4, float f5) {
        this.w = f2;
        this.x = f3;
        this.y = f4;
        this.z = f5;
        return this;
    }

    public Quaternion set(float f2, Vec3D vec3D) {
        this.w = f2;
        this.x = vec3D.x;
        this.y = vec3D.y;
        this.z = vec3D.z;
        return this;
    }

    public Quaternion set(Quaternion quaternion) {
        this.w = quaternion.w;
        this.x = quaternion.x;
        this.y = quaternion.y;
        this.z = quaternion.z;
        return this;
    }

    public Quaternion sub(Quaternion quaternion) {
        return new Quaternion(this.x - quaternion.x, this.y - quaternion.y, this.z - quaternion.z, this.w - quaternion.w);
    }

    public Quaternion subSelf(Quaternion quaternion) {
        this.x -= quaternion.x;
        this.y -= quaternion.y;
        this.z -= quaternion.z;
        this.w -= quaternion.w;
        return this;
    }

    public float[] toArray() {
        return new float[]{this.w, this.x, this.y, this.z};
    }

    public float[] toAxisAngle() {
        float[] fArray = new float[4];
        float f2 = (float)Math.sqrt(1.0f - this.w * this.w);
        f2 = f2 < 1.1920929E-7f ? 1.0f : 1.0f / f2;
        fArray[0] = (float)Math.acos(this.w) * 2.0f;
        fArray[1] = this.x * f2;
        fArray[2] = this.y * f2;
        fArray[3] = this.z * f2;
        return fArray;
    }

    public Matrix4x4 toMatrix4x4() {
        return this.toMatrix4x4(new Matrix4x4());
    }

    public Matrix4x4 toMatrix4x4(Matrix4x4 matrix4x4) {
        float f2 = this.x + this.x;
        float f3 = this.y + this.y;
        float f4 = this.z + this.z;
        float f5 = this.x * f2;
        float f6 = this.x * f3;
        float f7 = this.x * f4;
        float f8 = this.y * f3;
        float f9 = this.y * f4;
        float f10 = this.z * f4;
        float f11 = this.w * f2;
        float f12 = this.w * f3;
        float f13 = this.w * f4;
        return matrix4x4.set(1.0f - (f8 + f10), f6 - f13, f7 + f12, 0.0, f6 + f13, 1.0f - (f5 + f10), f9 - f11, 0.0, f7 - f12, f9 + f11, 1.0f - (f5 + f8), 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(48);
        stringBuffer.append("{axis: [").append(this.x).append(",").append(this.y).append(",").append(this.z).append("], w: ").append(this.w).append("}");
        return stringBuffer.toString();
    }
}

