/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import toxi.geom.Line3D;
import toxi.geom.ReadonlyVec3D;
import toxi.geom.Vec3D;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Ray3D
extends Vec3D {
    @XmlElement(required=true)
    protected Vec3D dir;

    public Ray3D() {
        this.dir = Vec3D.Y_AXIS.copy();
    }

    public Ray3D(float f2, float f3, float f4, ReadonlyVec3D readonlyVec3D) {
        super(f2, f3, f4);
        this.dir = readonlyVec3D.getNormalized();
    }

    public Ray3D(ReadonlyVec3D readonlyVec3D, ReadonlyVec3D readonlyVec3D2) {
        this(readonlyVec3D.x(), readonlyVec3D.y(), readonlyVec3D.z(), readonlyVec3D2);
    }

    public Vec3D getDirection() {
        return this.dir.copy();
    }

    public float getDistanceToPoint(Vec3D vec3D) {
        Vec3D vec3D2 = vec3D.sub(this);
        return vec3D2.distanceTo(this.dir.scale(vec3D2.dot(this.dir)));
    }

    public Vec3D getPointAtDistance(float f2) {
        return this.add(this.dir.scale(f2));
    }

    public Ray3D setDirection(ReadonlyVec3D readonlyVec3D) {
        this.dir.set(readonlyVec3D).normalize();
        return this;
    }

    public Line3D toLine3DWithPointAtDistance(float f2) {
        return new Line3D(this, this.getPointAtDistance(f2));
    }

    public String toString() {
        return "origin: " + super.toString() + " dir: " + this.dir;
    }
}

