/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom;

import toxi.geom.Intersector3D;
import toxi.geom.IsectData3D;
import toxi.geom.Ray3D;
import toxi.geom.ReadonlyVec3D;
import toxi.geom.Reflector3D;
import toxi.geom.Sphere;
import toxi.geom.Vec3D;

public class SphereIntersectorReflector
implements Intersector3D,
Reflector3D {
    protected Sphere sphere;
    protected IsectData3D isectData;
    protected ReadonlyVec3D reflectedDir;
    protected ReadonlyVec3D reflectedPos;
    protected float reflectTheta;

    public SphereIntersectorReflector(Sphere sphere) {
        this.sphere = sphere;
        this.isectData = new IsectData3D();
    }

    public SphereIntersectorReflector(Vec3D vec3D, float f2) {
        this(new Sphere(vec3D, f2));
    }

    public IsectData3D getIntersectionData() {
        return this.isectData;
    }

    public ReadonlyVec3D getReflectedRayPointAtDistance(float f2) {
        if (this.reflectedDir != null) {
            return this.isectData.pos.add(this.reflectedDir.scale(f2));
        }
        return null;
    }

    public float getReflectionAngle() {
        return this.reflectTheta;
    }

    public Sphere getSphere() {
        return this.sphere;
    }

    public float intersectRayDistance(Ray3D ray3D) {
        float f2;
        Vec3D vec3D = this.sphere.sub(ray3D);
        float f3 = vec3D.magSquared();
        float f4 = this.sphere.radius * this.sphere.radius - (f3 - (f2 = vec3D.dot((ReadonlyVec3D)ray3D.dir)) * f2);
        if ((double)f4 < 0.0) {
            return -1.0f;
        }
        return f2 - (float)Math.sqrt(f4);
    }

    public boolean intersectsRay(Ray3D ray3D) {
        this.isectData.dist = this.intersectRayDistance(ray3D);
        boolean bl = this.isectData.isIntersection = this.isectData.dist >= 0.0f;
        if (this.isectData.isIntersection) {
            this.isectData.pos = ray3D.add(ray3D.getDirection().scale(this.isectData.dist));
            this.isectData.dir = this.isectData.pos.sub(ray3D);
            this.isectData.normal = this.sphere.tangentPlaneNormalAt(this.isectData.pos);
        }
        return this.isectData.isIntersection;
    }

    public Ray3D reflectRay(Ray3D ray3D) {
        if (this.intersectsRay(ray3D)) {
            this.reflectTheta = this.isectData.dir.angleBetween(this.isectData.normal, true) * 2.0f + (float)Math.PI;
            Vec3D vec3D = this.isectData.dir.getNormalized().cross(this.isectData.normal).normalize();
            this.reflectedDir = !vec3D.isZeroVector() ? this.isectData.dir.getNormalized().rotateAroundAxis(vec3D, this.reflectTheta) : this.isectData.dir.getInverted();
            return new Ray3D(this.isectData.pos, this.reflectedDir);
        }
        return null;
    }

    public void setSphere(Sphere sphere) {
        this.sphere = sphere;
    }
}

