/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom;

import java.util.ArrayList;
import toxi.geom.Polygon2D;
import toxi.geom.PolygonClipper2D;
import toxi.geom.Rect;
import toxi.geom.Vec2D;

public class SutherlandHodgemanClipper
implements PolygonClipper2D {
    protected Rect bounds;

    public SutherlandHodgemanClipper(Rect rect) {
        this.bounds = rect;
    }

    public Polygon2D clipPolygon(Polygon2D polygon2D) {
        ArrayList<Vec2D> arrayList = new ArrayList<Vec2D>(polygon2D.vertices);
        ArrayList<Object> arrayList2 = new ArrayList();
        arrayList.add((Vec2D)arrayList.get(0));
        for (int i = 0; i < 4; ++i) {
            arrayList2.clear();
            int n = arrayList.size() - 1;
            for (int j = 0; j < n; ++j) {
                Vec2D vec2D = (Vec2D)arrayList.get(j);
                Vec2D vec2D2 = (Vec2D)arrayList.get(j + 1);
                if (this.isInsideEdge(vec2D, i)) {
                    if (this.isInsideEdge(vec2D2, i)) {
                        arrayList2.add(vec2D2.copy());
                        continue;
                    }
                    arrayList2.add(this.getClippedPosOnEdge(i, vec2D, vec2D2));
                    continue;
                }
                if (!this.isInsideEdge(vec2D2, i)) continue;
                arrayList2.add(this.getClippedPosOnEdge(i, vec2D, vec2D2));
                arrayList2.add(vec2D2.copy());
            }
            if (arrayList2.size() > 0 && arrayList2.get(0) != arrayList2.get(arrayList2.size() - 1)) {
                arrayList2.add(arrayList2.get(0));
            }
            ArrayList<Vec2D> arrayList3 = arrayList;
            arrayList = arrayList2;
            arrayList2 = arrayList3;
            arrayList2.clear();
        }
        return new Polygon2D(arrayList);
    }

    public Rect getBounds() {
        return this.bounds;
    }

    private final Vec2D getClippedPosOnEdge(int n, Vec2D vec2D, Vec2D vec2D2) {
        switch (n) {
            case 0: {
                return new Vec2D(vec2D.x + (this.bounds.y - vec2D.y) * (vec2D2.x - vec2D.x) / (vec2D2.y - vec2D.y), this.bounds.y);
            }
            case 2: {
                float f2 = this.bounds.y + this.bounds.height;
                return new Vec2D(vec2D.x + (f2 - vec2D.y) * (vec2D2.x - vec2D.x) / (vec2D2.y - vec2D.y), f2);
            }
            case 1: {
                float f3 = this.bounds.x + this.bounds.width;
                return new Vec2D(f3, vec2D.y + (f3 - vec2D.x) * (vec2D2.y - vec2D.y) / (vec2D2.x - vec2D.x));
            }
            case 3: {
                return new Vec2D(this.bounds.x, vec2D.y + (this.bounds.x - vec2D.x) * (vec2D2.y - vec2D.y) / (vec2D2.x - vec2D.x));
            }
        }
        return null;
    }

    private final boolean isInsideEdge(Vec2D vec2D, int n) {
        switch (n) {
            case 0: {
                return vec2D.y >= this.bounds.y;
            }
            case 2: {
                return vec2D.y < this.bounds.y + this.bounds.height;
            }
            case 3: {
                return vec2D.x >= this.bounds.x;
            }
            case 1: {
                return vec2D.x < this.bounds.x + this.bounds.width;
            }
        }
        return false;
    }

    public void setBounds(Rect rect) {
        this.bounds = rect;
    }
}

