/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom.mesh;

import toxi.geom.Sphere;
import toxi.geom.Vec3D;
import toxi.geom.mesh.SurfaceFunction;
import toxi.math.MathUtils;

public class SphereFunction
implements SurfaceFunction {
    public Sphere sphere;
    protected float phiRange = (float)Math.PI;
    protected float thetaRange = (float)Math.PI * 2;

    public SphereFunction() {
        this(1.0f);
    }

    public SphereFunction(float f2) {
        this(new Sphere(new Vec3D(), f2));
    }

    public SphereFunction(Sphere sphere) {
        this.sphere = sphere;
    }

    public Vec3D computeVertexFor(Vec3D vec3D, float f2, float f3) {
        float f4 = MathUtils.cos(f2 -= 1.5707964f);
        float f5 = MathUtils.cos(f3);
        float f6 = MathUtils.sin(f2);
        float f7 = MathUtils.sin(f3);
        float f8 = (float)MathUtils.sign(f4) * MathUtils.abs(f4);
        vec3D.x = f8 * (float)MathUtils.sign(f5) * MathUtils.abs(f5);
        vec3D.y = (float)MathUtils.sign(f6) * MathUtils.abs(f6);
        vec3D.z = f8 * (float)MathUtils.sign(f7) * MathUtils.abs(f7);
        return vec3D.scaleSelf(this.sphere.radius).addSelf(this.sphere);
    }

    public float getPhiRange() {
        return this.phiRange;
    }

    public int getPhiResolutionLimit(int n) {
        return n;
    }

    public float getThetaRange() {
        return this.thetaRange;
    }

    public int getThetaResolutionLimit(int n) {
        return n;
    }

    public void setMaxPhi(float f2) {
        this.phiRange = MathUtils.min(f2 / 2.0f, (float)Math.PI);
    }

    public void setMaxTheta(float f2) {
        this.thetaRange = MathUtils.min(f2, (float)Math.PI * 2);
    }
}

