/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom.mesh;

import toxi.geom.Vec3D;
import toxi.geom.mesh.SurfaceFunction;
import toxi.math.MathUtils;

public class SphericalHarmonics
implements SurfaceFunction {
    float[] m;

    public SphericalHarmonics(float[] fArray) {
        this.m = fArray;
    }

    public Vec3D computeVertexFor(Vec3D vec3D, float f2, float f3) {
        float f4 = 0.0f;
        f4 = (float)((double)f4 + Math.pow(MathUtils.sin(this.m[0] * f3), this.m[1]));
        f4 = (float)((double)f4 + Math.pow(MathUtils.cos(this.m[2] * f3), this.m[3]));
        f4 = (float)((double)f4 + Math.pow(MathUtils.sin(this.m[4] * f2), this.m[5]));
        f4 = (float)((double)f4 + Math.pow(MathUtils.cos(this.m[6] * f2), this.m[7]));
        float f5 = MathUtils.sin(f3);
        vec3D.x = f4 * f5 * MathUtils.cos(f2);
        vec3D.y = f4 * MathUtils.cos(f3);
        vec3D.z = f4 * f5 * MathUtils.sin(f2);
        return vec3D;
    }

    public float getPhiRange() {
        return (float)Math.PI * 2;
    }

    public int getPhiResolutionLimit(int n) {
        return n;
    }

    public float getThetaRange() {
        return (float)Math.PI;
    }

    public int getThetaResolutionLimit(int n) {
        return n;
    }
}

