/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom.mesh;

import toxi.geom.Vec3D;
import toxi.geom.mesh.Mesh3D;
import toxi.geom.mesh.SurfaceFunction;
import toxi.geom.mesh.TriangleMesh;

public class SurfaceMeshBuilder {
    protected SurfaceFunction function;

    public SurfaceMeshBuilder(SurfaceFunction surfaceFunction) {
        this.function = surfaceFunction;
    }

    public Mesh3D createMesh(int n) {
        return this.createMesh(null, n, 1.0f);
    }

    public Mesh3D createMesh(Mesh3D mesh3D, int n, float f2) {
        return this.createMesh(mesh3D, n, f2, true);
    }

    public Mesh3D createMesh(Mesh3D mesh3D, int n, float f2, boolean bl) {
        if (mesh3D == null) {
            mesh3D = new TriangleMesh();
        }
        Vec3D vec3D = new Vec3D();
        Vec3D vec3D2 = new Vec3D();
        Vec3D vec3D3 = new Vec3D();
        Vec3D vec3D4 = new Vec3D();
        Vec3D vec3D5 = new Vec3D();
        Vec3D vec3D6 = new Vec3D();
        int n2 = this.function.getPhiResolutionLimit(n);
        float f3 = this.function.getPhiRange();
        int n3 = this.function.getThetaResolutionLimit(n);
        float f4 = this.function.getThetaRange();
        float f5 = 1.0f / (float)(1 == n % 2 ? n - 0 : n);
        for (int i = 0; i < n2; ++i) {
            float f6 = (float)i * f3 * f5;
            float f7 = (float)(i + 1) * f3 * f5;
            for (int j = 0; j <= n3; ++j) {
                float f8 = (float)j * f4 / (float)n;
                vec3D = this.function.computeVertexFor(vec3D, f7, f8).scaleSelf(f2);
                if ((double)(vec3D2 = this.function.computeVertexFor(vec3D2, f6, f8).scaleSelf(f2)).distanceTo(vec3D) < 1.0E-4) {
                    vec3D2.set(vec3D);
                }
                if (j > 0) {
                    if (j == n3 && bl) {
                        vec3D.set(vec3D5);
                        vec3D2.set(vec3D6);
                    }
                    mesh3D.addFace(vec3D3, vec3D4, vec3D);
                    mesh3D.addFace(vec3D4, vec3D2, vec3D);
                } else {
                    vec3D5.set(vec3D);
                    vec3D6.set(vec3D2);
                }
                vec3D3.set(vec3D);
                vec3D4.set(vec3D2);
            }
        }
        return mesh3D;
    }

    public SurfaceFunction getFunction() {
        return this.function;
    }

    public void setFunction(SurfaceFunction surfaceFunction) {
        this.function = surfaceFunction;
    }
}

