/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom.mesh;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import toxi.geom.AABB;
import toxi.geom.Line3D;
import toxi.geom.Matrix4x4;
import toxi.geom.Quaternion;
import toxi.geom.ReadonlyVec3D;
import toxi.geom.Vec2D;
import toxi.geom.Vec3D;
import toxi.geom.mesh.Face;
import toxi.geom.mesh.Mesh3D;
import toxi.geom.mesh.TriangleMesh;
import toxi.geom.mesh.Vertex;
import toxi.geom.mesh.WEFace;
import toxi.geom.mesh.WEVertex;
import toxi.geom.mesh.WingedEdge;
import toxi.geom.mesh.subdiv.MidpointSubdivision;
import toxi.geom.mesh.subdiv.SubdivisionStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WETriangleMesh
extends TriangleMesh {
    public LinkedHashMap<Line3D, WingedEdge> edges;
    private final Line3D edgeCheck = new Line3D(new Vec3D(), new Vec3D());
    private int uniqueEdgeID;

    public WETriangleMesh() {
        this("untitled");
    }

    public WETriangleMesh(String string) {
        this(string, 1000, 3000);
    }

    public WETriangleMesh(String string, int n, int n2) {
        super(string, n, n2);
    }

    @Override
    public WETriangleMesh addFace(Vec3D vec3D, Vec3D vec3D2, Vec3D vec3D3) {
        return this.addFace(vec3D, vec3D2, vec3D3, null, null, null, null);
    }

    @Override
    public WETriangleMesh addFace(Vec3D vec3D, Vec3D vec3D2, Vec3D vec3D3, Vec2D vec2D, Vec2D vec2D2, Vec2D vec2D3) {
        return this.addFace(vec3D, vec3D2, vec3D3, null, vec2D, vec2D2, vec2D3);
    }

    @Override
    public WETriangleMesh addFace(Vec3D vec3D, Vec3D vec3D2, Vec3D vec3D3, Vec3D vec3D4) {
        return this.addFace(vec3D, vec3D2, vec3D3, vec3D4, null, null, null);
    }

    @Override
    public WETriangleMesh addFace(Vec3D vec3D, Vec3D vec3D2, Vec3D vec3D3, Vec3D vec3D4, Vec2D vec2D, Vec2D vec2D2, Vec2D vec2D3) {
        WEVertex wEVertex = this.checkVertex(vec3D);
        WEVertex wEVertex2 = this.checkVertex(vec3D2);
        WEVertex wEVertex3 = this.checkVertex(vec3D3);
        if (wEVertex.id == wEVertex2.id || wEVertex.id == wEVertex3.id || wEVertex2.id == wEVertex3.id) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("ignorning invalid face: " + vec3D + "," + vec3D2 + "," + vec3D3);
            }
        } else {
            Object object;
            if (vec3D4 != null && vec3D4.dot((Vec3D)(object = wEVertex.sub(wEVertex3).crossSelf(wEVertex.sub(wEVertex2)))) < 0.0f) {
                WEVertex wEVertex4 = wEVertex;
                wEVertex = wEVertex2;
                wEVertex2 = wEVertex4;
            }
            object = new WEFace(wEVertex, wEVertex2, wEVertex3, vec2D, vec2D2, vec2D3);
            this.faces.add(object);
            ++this.numFaces;
            this.updateEdge(wEVertex, wEVertex2, (WEFace)object);
            this.updateEdge(wEVertex2, wEVertex3, (WEFace)object);
            this.updateEdge(wEVertex3, wEVertex, (WEFace)object);
        }
        return this;
    }

    @Override
    public WETriangleMesh addMesh(Mesh3D mesh3D) {
        super.addMesh(mesh3D);
        return this;
    }

    @Override
    public AABB center(ReadonlyVec3D readonlyVec3D) {
        super.center(readonlyVec3D);
        this.rebuildIndex();
        return this.bounds;
    }

    private final WEVertex checkVertex(Vec3D vec3D) {
        WEVertex wEVertex = (WEVertex)this.vertices.get(vec3D);
        if (wEVertex == null) {
            wEVertex = this.createVertex(vec3D, this.uniqueVertexID++);
            this.vertices.put(wEVertex, wEVertex);
            ++this.numVertices;
        }
        return wEVertex;
    }

    @Override
    public WETriangleMesh clear() {
        super.clear();
        this.edges.clear();
        return this;
    }

    @Override
    public WETriangleMesh copy() {
        WETriangleMesh wETriangleMesh = new WETriangleMesh(this.name + "-copy", this.numVertices, this.numFaces);
        for (Face face : this.faces) {
            wETriangleMesh.addFace(face.a, face.b, face.c, face.normal, face.uvA, face.uvB, face.uvC);
        }
        return wETriangleMesh;
    }

    @Override
    protected WEVertex createVertex(Vec3D vec3D, int n) {
        return new WEVertex(vec3D, n);
    }

    @Override
    public WETriangleMesh flipVertexOrder() {
        super.flipVertexOrder();
        return this;
    }

    @Override
    public WETriangleMesh flipYAxis() {
        super.flipYAxis();
        return this;
    }

    @Override
    public WEVertex getClosestVertexToPoint(ReadonlyVec3D readonlyVec3D) {
        return (WEVertex)super.getClosestVertexToPoint(readonlyVec3D);
    }

    private int getNumEdges() {
        return this.edges.size();
    }

    @Override
    public WETriangleMesh getRotatedAroundAxis(Vec3D vec3D, float f2) {
        return this.copy().rotateAroundAxis(vec3D, f2);
    }

    @Override
    public WETriangleMesh getRotatedX(float f2) {
        return this.copy().rotateX(f2);
    }

    @Override
    public WETriangleMesh getRotatedY(float f2) {
        return this.copy().rotateY(f2);
    }

    @Override
    public WETriangleMesh getRotatedZ(float f2) {
        return this.copy().rotateZ(f2);
    }

    @Override
    public WETriangleMesh getScaled(float f2) {
        return this.copy().scale(f2);
    }

    @Override
    public WETriangleMesh getScaled(Vec3D vec3D) {
        return this.copy().scale(vec3D);
    }

    @Override
    public WETriangleMesh getTranslated(Vec3D vec3D) {
        return this.copy().translate(vec3D);
    }

    @Override
    public WEVertex getVertexAtPoint(Vec3D vec3D) {
        return (WEVertex)this.vertices.get(vec3D);
    }

    @Override
    public WEVertex getVertexForID(int n) {
        return (WEVertex)super.getVertexForID(n);
    }

    @Override
    public WETriangleMesh init(String string, int n, int n2) {
        super.init(string, n, n2);
        this.edges = new LinkedHashMap(n, 1.5f, false);
        return this;
    }

    @Override
    public WETriangleMesh pointTowards(ReadonlyVec3D readonlyVec3D) {
        return this.transform(Quaternion.getAlignmentQuat(readonlyVec3D, Vec3D.Z_AXIS).toMatrix4x4(this.matrix), true);
    }

    @Override
    public WETriangleMesh pointTowards(ReadonlyVec3D readonlyVec3D, ReadonlyVec3D readonlyVec3D2) {
        return this.transform(Quaternion.getAlignmentQuat(readonlyVec3D, readonlyVec3D2).toMatrix4x4(this.matrix), true);
    }

    public void rebuildIndex() {
        LinkedHashMap<Vertex, Vertex> linkedHashMap = new LinkedHashMap<Vertex, Vertex>(this.vertices.size());
        for (Object object : this.vertices.values()) {
            linkedHashMap.put((Vertex)object, (Vertex)object);
        }
        this.vertices = linkedHashMap;
        LinkedHashMap linkedHashMap2 = new LinkedHashMap(this.edges.size());
        for (WingedEdge wingedEdge : this.edges.values()) {
            linkedHashMap2.put(wingedEdge, wingedEdge);
        }
        this.edges = linkedHashMap2;
    }

    protected void removeEdge(WingedEdge wingedEdge) {
        wingedEdge.remove();
        WEVertex wEVertex = (WEVertex)wingedEdge.a;
        if (wEVertex.edges.size() == 0) {
            this.vertices.remove(wEVertex);
        }
        wEVertex = (WEVertex)wingedEdge.b;
        if (wEVertex.edges.size() == 0) {
            this.vertices.remove(wEVertex);
        }
        for (WEFace wEFace : wingedEdge.faces) {
            this.removeFace(wEFace);
        }
        WingedEdge wingedEdge2 = (WingedEdge)this.edges.remove(this.edgeCheck.set(wingedEdge.a, wingedEdge.b));
        if (wingedEdge2 != wingedEdge) {
            throw new IllegalStateException("can't remove edge");
        }
    }

    @Override
    public void removeFace(Face face) {
        this.faces.remove(face);
        for (WingedEdge wingedEdge : ((WEFace)face).edges) {
            wingedEdge.faces.remove(face);
            if (wingedEdge.faces.size() != 0) continue;
            this.removeEdge(wingedEdge);
        }
    }

    public void removeUnusedVertices() {
        Iterator iterator = this.vertices.values().iterator();
        while (iterator.hasNext()) {
            Vertex vertex = (Vertex)iterator.next();
            boolean bl = false;
            for (Face face : this.faces) {
                if (face.a != vertex && face.b != vertex && face.c != vertex) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            logger.info("removing vertex: " + vertex);
            iterator.remove();
        }
    }

    public void removeVertices(Collection<Vertex> collection) {
        for (Vertex vertex : collection) {
            WEVertex wEVertex = (WEVertex)vertex;
            for (WingedEdge wingedEdge : new ArrayList<WingedEdge>(wEVertex.edges)) {
                for (Face face : new ArrayList<WEFace>(wingedEdge.faces)) {
                    this.removeFace(face);
                }
            }
        }
    }

    @Override
    public WETriangleMesh rotateAroundAxis(Vec3D vec3D, float f2) {
        return this.transform(this.matrix.identity().rotateAroundAxis(vec3D, f2));
    }

    @Override
    public WETriangleMesh rotateX(float f2) {
        return this.transform(this.matrix.identity().rotateX(f2));
    }

    @Override
    public WETriangleMesh rotateY(float f2) {
        return this.transform(this.matrix.identity().rotateY(f2));
    }

    @Override
    public WETriangleMesh rotateZ(float f2) {
        return this.transform(this.matrix.identity().rotateZ(f2));
    }

    @Override
    public WETriangleMesh scale(float f2) {
        return this.transform(this.matrix.identity().scaleSelf(f2));
    }

    @Override
    public WETriangleMesh scale(Vec3D vec3D) {
        return this.transform(this.matrix.identity().scaleSelf(vec3D));
    }

    public void splitEdge(ReadonlyVec3D readonlyVec3D, ReadonlyVec3D readonlyVec3D2, SubdivisionStrategy subdivisionStrategy) {
        WingedEdge wingedEdge = this.edges.get(this.edgeCheck.set(readonlyVec3D, readonlyVec3D2));
        if (wingedEdge != null) {
            this.splitEdge(wingedEdge, subdivisionStrategy);
        }
    }

    public void splitEdge(WingedEdge wingedEdge, SubdivisionStrategy subdivisionStrategy) {
        List<Vec3D> list = subdivisionStrategy.computeSplitPoints(wingedEdge);
        this.splitFace(wingedEdge.faces.get(0), wingedEdge, list);
        if (wingedEdge.faces.size() > 1) {
            this.splitFace(wingedEdge.faces.get(1), wingedEdge, list);
        }
        this.removeEdge(wingedEdge);
    }

    protected void splitFace(WEFace wEFace, WingedEdge wingedEdge, List<Vec3D> list) {
        Vec3D vec3D = null;
        for (int i = 0; i < 3; ++i) {
            WingedEdge wingedEdge2 = wEFace.edges.get(i);
            if (wingedEdge2.equals(wingedEdge)) continue;
            if (wingedEdge2.a.equals(wingedEdge.a) || wingedEdge2.a.equals(wingedEdge.b)) {
                vec3D = wingedEdge2.b;
                break;
            }
            vec3D = wingedEdge2.a;
            break;
        }
        Vec3D vec3D2 = null;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Vec3D vec3D3 = list.get(i);
            if (i == 0) {
                this.addFace(vec3D, wingedEdge.a, vec3D3, wEFace.normal);
            } else {
                this.addFace(vec3D, vec3D2, vec3D3, wEFace.normal);
            }
            if (i == n - 1) {
                this.addFace(vec3D, vec3D3, wingedEdge.b, wEFace.normal);
            }
            vec3D2 = vec3D3;
        }
    }

    public void subdivide() {
        this.subdivide(0.0f);
    }

    public void subdivide(float f2) {
        this.subdivide(new MidpointSubdivision(), f2);
    }

    public void subdivide(SubdivisionStrategy subdivisionStrategy) {
        this.subdivide(subdivisionStrategy, 0.0f);
    }

    public void subdivide(SubdivisionStrategy subdivisionStrategy, float f2) {
        this.subdivideEdges(new ArrayList<WingedEdge>(this.edges.values()), subdivisionStrategy, f2);
    }

    protected void subdivideEdges(List<WingedEdge> list, SubdivisionStrategy subdivisionStrategy, float f2) {
        Collections.sort(list, subdivisionStrategy.getEdgeOrdering());
        f2 *= f2;
        for (WingedEdge wingedEdge : list) {
            if (!this.edges.containsKey(wingedEdge) || !(wingedEdge.getLengthSquared() >= f2)) continue;
            this.splitEdge(wingedEdge, subdivisionStrategy);
        }
    }

    public void subdivideFaceEdges(List<WEFace> list, SubdivisionStrategy subdivisionStrategy, float f2) {
        ArrayList<WingedEdge> arrayList = new ArrayList<WingedEdge>();
        for (WEFace wEFace : list) {
            for (WingedEdge wingedEdge : wEFace.edges) {
                if (arrayList.contains(wingedEdge)) continue;
                arrayList.add(wingedEdge);
            }
        }
        this.subdivideEdges(arrayList, subdivisionStrategy, f2);
    }

    @Override
    public String toString() {
        return "WETriangleMesh: " + this.name + " vertices: " + this.getNumVertices() + " faces: " + this.getNumFaces() + " edges:" + this.getNumEdges();
    }

    @Override
    public WETriangleMesh transform(Matrix4x4 matrix4x4) {
        return this.transform(matrix4x4, true);
    }

    @Override
    public WETriangleMesh transform(Matrix4x4 matrix4x4, boolean bl) {
        for (Vertex vertex : this.vertices.values()) {
            matrix4x4.applyToSelf(vertex);
        }
        this.rebuildIndex();
        if (bl) {
            this.computeFaceNormals();
        }
        return this;
    }

    @Override
    public WETriangleMesh translate(Vec3D vec3D) {
        return this.transform(this.matrix.identity().translateSelf(vec3D));
    }

    protected void updateEdge(WEVertex wEVertex, WEVertex wEVertex2, WEFace wEFace) {
        this.edgeCheck.set(wEVertex, wEVertex2);
        WingedEdge wingedEdge = this.edges.get(this.edgeCheck);
        if (wingedEdge != null) {
            wingedEdge.addFace(wEFace);
        } else {
            wingedEdge = new WingedEdge(wEVertex, wEVertex2, wEFace, this.uniqueEdgeID++);
            this.edges.put(wingedEdge, wingedEdge);
            wEVertex.addEdge(wingedEdge);
            wEVertex2.addEdge(wingedEdge);
        }
        wEFace.addEdge(wingedEdge);
    }
}

