/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom.mesh;

import java.util.ArrayList;
import java.util.List;
import toxi.geom.ReadonlyVec3D;
import toxi.geom.Vec3D;
import toxi.geom.mesh.Vertex;
import toxi.geom.mesh.WingedEdge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WEVertex
extends Vertex {
    public List<WingedEdge> edges = new ArrayList<WingedEdge>(4);

    public WEVertex(Vec3D vec3D, int n) {
        super(vec3D, n);
    }

    public void addEdge(WingedEdge wingedEdge) {
        this.edges.add(wingedEdge);
    }

    public WEVertex getNeighborInDirection(ReadonlyVec3D readonlyVec3D, float f2) {
        WEVertex wEVertex = null;
        float f3 = 1.0f - f2;
        for (WEVertex wEVertex2 : this.getNeighbors()) {
            float f4 = wEVertex2.sub(this).normalize().dot(readonlyVec3D);
            if (!(f4 > f3)) continue;
            wEVertex = wEVertex2;
            f3 = f4;
        }
        return wEVertex;
    }

    public List<WEVertex> getNeighbors() {
        ArrayList<WEVertex> arrayList = new ArrayList<WEVertex>(this.edges.size());
        for (WingedEdge wingedEdge : this.edges) {
            arrayList.add(wingedEdge.getOtherEndFor(this));
        }
        return arrayList;
    }

    public void removeEdge(WingedEdge wingedEdge) {
        this.edges.remove(wingedEdge);
    }

    @Override
    public String toString() {
        return this.id + " {" + this.x + "," + this.y + "," + this.z + "}";
    }
}

