/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom.mesh.subdiv;

import java.util.ArrayList;
import java.util.List;
import toxi.geom.Vec3D;
import toxi.geom.mesh.WingedEdge;
import toxi.geom.mesh.subdiv.SubdivisionStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DualDisplacementSubdivision
extends SubdivisionStrategy {
    public Vec3D centroid;
    public float ampA;
    public float ampB;

    public DualDisplacementSubdivision(Vec3D vec3D, float f2, float f3) {
        this.centroid = vec3D;
        this.ampA = f2;
        this.ampB = f3;
    }

    @Override
    public List<Vec3D> computeSplitPoints(WingedEdge wingedEdge) {
        ArrayList<Vec3D> arrayList = new ArrayList<Vec3D>(2);
        float f2 = wingedEdge.getLength();
        Vec3D vec3D = wingedEdge.a.interpolateTo(wingedEdge.b, 0.3333f);
        vec3D.addSelf(vec3D.sub(this.centroid).normalizeTo(this.ampA * f2));
        Vec3D vec3D2 = wingedEdge.a.interpolateTo(wingedEdge.b, 0.6666f);
        vec3D2.addSelf(vec3D2.sub(this.centroid).normalizeTo(this.ampB * f2));
        arrayList.add(vec3D);
        arrayList.add(vec3D2);
        return arrayList;
    }
}

