/*
 * Decompiled with CFR 0.152.
 */
package toxi.math;

import java.util.Random;

public final class MathUtils {
    public static final float SQRT2 = (float)Math.sqrt(2.0);
    public static final float SQRT3 = (float)Math.sqrt(3.0);
    public static final float LOG2 = (float)Math.log(2.0);
    public static final float PI = (float)Math.PI;
    public static final float INV_PI = 0.31830987f;
    public static final float HALF_PI = 1.5707964f;
    public static final float THIRD_PI = 1.0471976f;
    public static final float QUARTER_PI = 0.7853982f;
    public static final float TWO_PI = (float)Math.PI * 2;
    public static final float THREE_HALVES_PI = 4.712389f;
    public static final float PI_SQUARED = 9.869605f;
    public static final float EPS = 1.1920929E-7f;
    public static final float DEG2RAD = (float)Math.PI / 180;
    public static final float RAD2DEG = 57.295776f;
    private static final float SHIFT23 = 8388608.0f;
    private static final float INV_SHIFT23 = 1.1920929E-7f;
    private static final double SIN_A = -0.40528470733153665;
    private static final double SIN_B = 1.2732395093040454;
    private static final double SIN_P = 0.225;
    public static Random RND = new Random();

    public static final double abs(double d2) {
        return d2 < 0.0 ? -d2 : d2;
    }

    public static final float abs(float f2) {
        return f2 < 0.0f ? -f2 : f2;
    }

    public static final int abs(int n) {
        int n2 = n >> 31;
        return (n ^ n2) - n2;
    }

    public static final int ceilPowerOf2(int n) {
        int n2;
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        return n2;
    }

    public static final double clip(double d2, double d3, double d4) {
        return d2 < d3 ? d3 : (d2 > d4 ? d4 : d2);
    }

    public static final float clip(float f2, float f3, float f4) {
        return f2 < f3 ? f3 : (f2 > f4 ? f4 : f2);
    }

    public static final int clip(int n, int n2, int n3) {
        return n < n2 ? n2 : (n > n3 ? n3 : n);
    }

    public static final float clipNormalized(float f2) {
        if (f2 < 0.0f) {
            return 0.0f;
        }
        if (f2 > 1.0f) {
            return 1.0f;
        }
        return f2;
    }

    public static final double cos(double d2) {
        return MathUtils.sin(d2 + 1.5707963705062866);
    }

    public static final float cos(float f2) {
        return MathUtils.sin(f2 + 1.5707964f);
    }

    public static final float degrees(float f2) {
        return f2 * 57.295776f;
    }

    public static final double fastCos(double d2) {
        return MathUtils.fastSin(d2 + (double)(d2 > 1.5707963705062866 ? -4.712389f : 1.5707964f));
    }

    @Deprecated
    public static final int fastFloor(float f2) {
        return MathUtils.floor(f2);
    }

    @Deprecated
    public static final float fastInverseSqrt(float f2) {
        float f3 = 0.5f * f2;
        int n = Float.floatToIntBits(f2);
        n = 1597463174 - (n >> 1);
        f2 = Float.intBitsToFloat(n);
        return f2 * (1.5f - f3 * f2 * f2);
    }

    public static final float fastPow(float f2, float f3) {
        float f4 = Float.floatToRawIntBits(f2);
        f4 *= 1.1920929E-7f;
        float f5 = f4 - (float)((f4 -= 127.0f) >= 0.0f ? (int)f4 : (int)f4 - 1);
        f5 = f3 - (float)(f3 >= 0.0f ? (int)f3 : (int)(f3 *= f4 + (f5 - f5 * f5) * 0.346607f) - 1);
        f5 = (f5 - f5 * f5) * 0.33971f;
        return Float.intBitsToFloat((int)((f3 + 127.0f - f5) * 8388608.0f));
    }

    public static final double fastSin(double d2) {
        d2 = 1.2732395093040454 * d2 + -0.40528470733153665 * d2 * MathUtils.abs(d2);
        return 0.225 * (d2 * MathUtils.abs(d2) - d2) + d2;
    }

    public static final boolean flipCoin() {
        return Math.random() < 0.5;
    }

    public static final boolean flipCoin(Random random) {
        return random.nextBoolean();
    }

    public static final int floor(double d2) {
        int n = (int)d2;
        if (d2 < 0.0 && d2 != (double)n) {
            --n;
        }
        return n;
    }

    public static final int floor(float f2) {
        int n = (int)f2;
        if (f2 < 0.0f && f2 != (float)n) {
            --n;
        }
        return n;
    }

    public static final int floorPowerOf2(int n) {
        return (int)Math.pow(2.0, (int)(Math.log(n) / (double)LOG2));
    }

    public static final double max(double d2, double d3) {
        return d2 > d3 ? d2 : d3;
    }

    public static final double max(double d2, double d3, double d4) {
        return d2 > d3 ? (d2 > d4 ? d2 : d4) : (d3 > d4 ? d3 : d4);
    }

    public static final float max(float f2, float f3) {
        return f2 > f3 ? f2 : f3;
    }

    public static final float max(float f2, float f3, float f4) {
        return f2 > f3 ? (f2 > f4 ? f2 : f4) : (f3 > f4 ? f3 : f4);
    }

    public static final int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    public static final int max(int n, int n2, int n3) {
        return n > n2 ? (n > n3 ? n : n3) : (n2 > n3 ? n2 : n3);
    }

    public static final double min(double d2, double d3) {
        return d2 < d3 ? d2 : d3;
    }

    public static final double min(double d2, double d3, double d4) {
        return d2 < d3 ? (d2 < d4 ? d2 : d4) : (d3 < d4 ? d3 : d4);
    }

    public static final float min(float f2, float f3) {
        return f2 < f3 ? f2 : f3;
    }

    public static final float min(float f2, float f3, float f4) {
        return f2 < f3 ? (f2 < f4 ? f2 : f4) : (f3 < f4 ? f3 : f4);
    }

    public static final int min(int n, int n2) {
        return n < n2 ? n : n2;
    }

    public static final int min(int n, int n2, int n3) {
        return n < n2 ? (n < n3 ? n : n3) : (n2 < n3 ? n2 : n3);
    }

    public static final float normalizedRandom() {
        return RND.nextFloat() * 2.0f - 1.0f;
    }

    public static final float normalizedRandom(Random random) {
        return random.nextFloat() * 2.0f - 1.0f;
    }

    public static final float radians(float f2) {
        return f2 * ((float)Math.PI / 180);
    }

    public static final float random(float f2) {
        return RND.nextFloat() * f2;
    }

    public static final float random(float f2, float f3) {
        return RND.nextFloat() * (f3 - f2) + f2;
    }

    public static final int random(int n) {
        return (int)(RND.nextFloat() * (float)n);
    }

    public static final int random(int n, int n2) {
        return (int)(RND.nextFloat() * (float)(n2 - n)) + n;
    }

    public static final double random(Random random, double d2) {
        return random.nextDouble() * d2;
    }

    public static final double random(Random random, double d2, double d3) {
        return random.nextDouble() * (d3 - d2) + d2;
    }

    public static final float random(Random random, float f2) {
        return random.nextFloat() * f2;
    }

    public static final float random(Random random, float f2, float f3) {
        return random.nextFloat() * (f3 - f2) + f2;
    }

    public static final int random(Random random, int n) {
        return (int)(random.nextDouble() * (double)n);
    }

    public static final int random(Random random, int n, int n2) {
        return (int)(random.nextDouble() * (double)(n2 - n)) + n;
    }

    public static final double reduceAngle(double d2) {
        if (MathUtils.abs(d2 %= 6.2831854820251465) > 3.1415927410125732) {
            d2 -= 6.2831854820251465;
        }
        if (MathUtils.abs(d2) > 1.5707963705062866) {
            d2 = 3.1415927410125732 - d2;
        }
        return d2;
    }

    public static final float reduceAngle(float f2) {
        if (MathUtils.abs(f2 %= (float)Math.PI * 2) > (float)Math.PI) {
            f2 -= (float)Math.PI * 2;
        }
        if (MathUtils.abs(f2) > 1.5707964f) {
            f2 = (float)Math.PI - f2;
        }
        return f2;
    }

    public static void setDefaultRandomGenerator(Random random) {
        RND = random;
    }

    public static int sign(double d2) {
        return d2 < 0.0 ? -1 : (d2 > 0.0 ? 1 : 0);
    }

    public static int sign(float f2) {
        return f2 < 0.0f ? -1 : (f2 > 0.0f ? 1 : 0);
    }

    public static int sign(int n) {
        return n < 0 ? -1 : (n > 0 ? 1 : 0);
    }

    public static final double sin(double d2) {
        if (MathUtils.abs(d2 = MathUtils.reduceAngle(d2)) <= 0.7853981852531433) {
            return (float)MathUtils.fastSin(d2);
        }
        return (float)MathUtils.fastCos(1.5707963705062866 - d2);
    }

    public static final float sin(float f2) {
        if (MathUtils.abs(f2 = MathUtils.reduceAngle(f2)) <= 0.7853982f) {
            return (float)MathUtils.fastSin(f2);
        }
        return (float)MathUtils.fastCos(1.5707964f - f2);
    }

    @Deprecated
    public static final float sqrt(float f2) {
        if ((f2 = MathUtils.fastInverseSqrt(f2)) > 0.0f) {
            return 1.0f / f2;
        }
        return 0.0f;
    }
}

